/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.widget;

import com.google.common.collect.ImmutableList;
import com.lovetropics.tutorials.repack.ltlib.codec.MoreCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import org.lovetropics.tutorials.widget.DisplayPlane;
import org.lovetropics.tutorials.widget.TutorialWidget;
import org.lovetropics.tutorials.widget.TutorialWidgetType;

public final class ImageDisplayWidget
implements TutorialWidget {
    public static final Codec<ImageDisplayWidget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MoreCodecs.VECTOR_3D.fieldOf("pos").forGetter(c -> c.pos), (App)Texture.CODEC.fieldOf("texture").forGetter(c -> c.texture), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(0.0625f)).forGetter(c -> Float.valueOf(c.scale)), (App)MoreCodecs.VECTOR_3F.optionalFieldOf("point_along").forGetter(c -> Optional.ofNullable(c.pointAlong))).apply((Applicative)instance, ImageDisplayWidget::new));
    public static final TutorialWidgetType<ImageDisplayWidget> TYPE = TutorialWidgetType.register("image", CODEC);
    private final Vector3d pos;
    private final Texture texture;
    private final float scale;
    private final Vector3f pointAlong;
    private final DisplayPlane plane;

    private ImageDisplayWidget(Vector3d pos, Texture texture, float scale, Optional<Vector3f> pointAlong) {
        this.pos = pos;
        this.texture = texture;
        this.scale = scale;
        this.pointAlong = pointAlong.orElse(null);
        this.plane = pointAlong.map(DisplayPlane::new).orElse(null);
    }

    public Vector3d getPos() {
        return this.pos;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public float getScale() {
        return this.scale;
    }

    @Nullable
    public Matrix4f getPointAlongMatrix() {
        DisplayPlane plane = this.plane;
        return plane != null ? plane.getPointAlongMatrix() : null;
    }

    @Override
    public TutorialWidgetType<?> getType() {
        return TYPE;
    }

    public static final class Texture {
        private static final Codec<float[]> UV_CODEC = Codec.FLOAT.listOf().comapFlatMap(floats -> {
            if (floats.size() == 4) {
                return DataResult.success((Object)new float[]{((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), ((Float)floats.get(2)).floatValue(), ((Float)floats.get(3)).floatValue()});
            }
            return DataResult.error((String)"Malformed uvs, expected 4 components");
        }, uv -> ImmutableList.of((Object)Float.valueOf(uv[0]), (Object)Float.valueOf(uv[1]), (Object)Float.valueOf(uv[2]), (Object)Float.valueOf(uv[3])));
        private static final Codec<int[]> SIZE_CODEC = Codec.INT.listOf().comapFlatMap(ints -> {
            if (ints.size() == 2) {
                return DataResult.success((Object)new int[]{(Integer)ints.get(0), (Integer)ints.get(1)});
            }
            return DataResult.error((String)"Malformed texture size, expected 2 components");
        }, size -> ImmutableList.of((Object)size[0], (Object)size[1]));
        public static final Codec<Texture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("path").forGetter(c -> c.path), (App)SIZE_CODEC.fieldOf("size").forGetter(c -> c.size), (App)UV_CODEC.optionalFieldOf("uv").forGetter(c -> Optional.ofNullable(c.uv))).apply((Applicative)instance, Texture::new));
        private final ResourceLocation path;
        private final int[] size;
        private final float[] uv;

        Texture(ResourceLocation path, int[] size, Optional<float[]> uv) {
            this.path = path;
            this.size = size;
            this.uv = uv.orElse(new float[]{0.0f, 0.0f, size[0], size[1]});
        }

        public ResourceLocation getPath() {
            return this.path;
        }

        public int getWidth() {
            return this.size[0];
        }

        public int getHeight() {
            return this.size[1];
        }

        public float getMinU() {
            return this.uv[0] / (float)this.getWidth();
        }

        public float getMinV() {
            return this.uv[1] / (float)this.getHeight();
        }

        public float getMaxU() {
            return this.uv[2] / (float)this.getWidth();
        }

        public float getMaxV() {
            return this.uv[3] / (float)this.getHeight();
        }
    }
}

