/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.widget;

import com.lovetropics.tutorials.repack.ltlib.codec.MoreCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import org.lovetropics.tutorials.widget.DisplayPlane;
import org.lovetropics.tutorials.widget.TutorialWidget;
import org.lovetropics.tutorials.widget.TutorialWidgetType;

public final class TextDisplayWidget
implements TutorialWidget {
    public static final Codec<TextDisplayWidget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MoreCodecs.VECTOR_3D.fieldOf("pos").forGetter(c -> c.pos), (App)MoreCodecs.TEXT.fieldOf("text").forGetter(c -> c.text), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(0.0625f)).forGetter(c -> Float.valueOf(c.scale)), (App)MoreCodecs.VECTOR_3F.optionalFieldOf("point_along").forGetter(c -> Optional.ofNullable(c.pointAlong))).apply((Applicative)instance, TextDisplayWidget::new));
    public static final TutorialWidgetType<TextDisplayWidget> TYPE = TutorialWidgetType.register("text", CODEC);
    private final Vector3d pos;
    private final ITextComponent text;
    private final float scale;
    private final Vector3f pointAlong;
    private final DisplayPlane plane;

    private TextDisplayWidget(Vector3d pos, ITextComponent text, float scale, Optional<Vector3f> pointAlong) {
        this.pos = pos;
        this.text = text;
        this.scale = scale;
        this.pointAlong = pointAlong.orElse(null);
        this.plane = pointAlong.map(DisplayPlane::new).orElse(null);
    }

    public Vector3d getPos() {
        return this.pos;
    }

    public ITextComponent getText() {
        return this.text;
    }

    public float getScale() {
        return this.scale;
    }

    @Nullable
    public Matrix4f getPointAlongMatrix() {
        DisplayPlane plane = this.plane;
        return plane != null ? plane.getPointAlongMatrix() : null;
    }

    @Override
    public TutorialWidgetType<?> getType() {
        return TYPE;
    }
}

