/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.tutorials.widget.focus;

import com.lovetropics.tutorials.repack.ltlib.BlockBox;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public final class WidgetFocus {
    public static final Codec<WidgetFocus> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockBox.CODEC.fieldOf("looking_at").forGetter(c -> c.lookingAt), (App)Codec.FLOAT.optionalFieldOf("distance", (Object)Float.valueOf(10.0f)).forGetter(c -> Float.valueOf(c.distance))).apply((Applicative)instance, WidgetFocus::new));
    private final BlockBox lookingAt;
    private final AxisAlignedBB lookingAtAabb;
    private final float distance;

    public WidgetFocus(BlockBox lookingAt, float distance) {
        this.lookingAt = lookingAt;
        this.lookingAtAabb = lookingAt.asAabb();
        this.distance = distance;
    }

    public boolean test(Entity camera) {
        Vector3d eyes = camera.func_174824_e(1.0f);
        Vector3d view = camera.func_70676_i(1.0f);
        Vector3d lookingAt = eyes.func_178787_e(view.func_186678_a((double)this.distance));
        return this.lookingAtAabb.func_216365_b(eyes, lookingAt).isPresent();
    }
}

