/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import team.chisel.ctm.CTM;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.model.ModelCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;

public enum TextureMetadataHandler {
    INSTANCE;

    private final Set<ResourceLocation> registeredTextures = new HashSet<ResourceLocation>();
    private final Object2BooleanMap<ResourceLocation> wrappedModels = new Object2BooleanLinkedOpenHashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        HashSet sprites = new HashSet((Collection)ObfuscationReflectionHelper.getPrivateValue(TextureStitchEvent.Pre.class, (Object)event, (String)"sprites"));
        for (ResourceLocation rel : sprites) {
            try {
                IMetadataSectionCTM metadata = ResourceUtil.getMetadata(rel = new ResourceLocation(rel.func_110624_b(), "textures/" + rel.func_110623_a() + ".png"));
                if (metadata == null) continue;
                if (metadata.getProxy() != null) {
                    ResourceLocation proxysprite = new ResourceLocation(metadata.getProxy());
                    IMetadataSectionCTM proxymeta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(proxysprite));
                    event.addSprite(proxysprite);
                    if (proxymeta != null) {
                        for (ResourceLocation r : proxymeta.getAdditionalTextures()) {
                            if (!this.registeredTextures.add(r)) continue;
                            event.addSprite(r);
                        }
                    }
                }
                for (ResourceLocation r : metadata.getAdditionalTextures()) {
                    if (!this.registeredTextures.add(r)) continue;
                    event.addSprite(r);
                }
            }
            catch (FileNotFoundException metadata) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelBakeEvent event) {
        Map stateModels = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, (Object)event.getModelLoader(), (String)"field_217849_F");
        for (ResourceLocation rl : event.getModelRegistry().keySet()) {
            IBakedModel baked;
            IUnbakedModel rootModel = (IUnbakedModel)stateModels.get(rl);
            if (rootModel == null || (baked = (IBakedModel)event.getModelRegistry().get(rl)) instanceof AbstractCTMBakedModel || baked.func_188618_c()) continue;
            ArrayDeque<ResourceLocation> dependencies = new ArrayDeque<ResourceLocation>();
            HashSet<ResourceLocation> seenModels = new HashSet<ResourceLocation>();
            dependencies.push(rl);
            seenModels.add(rl);
            boolean shouldWrap = this.wrappedModels.getOrDefault((Object)rl, false);
            while (!shouldWrap && !dependencies.isEmpty()) {
                IUnbakedModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == rl ? rootModel : event.getModelLoader().func_209597_a(dep);
                }
                catch (Exception e) {
                    continue;
                }
                HashSet textures = Sets.newHashSet((Iterable)model.func_225614_a_(arg_0 -> ((ModelLoader)event.getModelLoader()).func_209597_a(arg_0), (Set)Sets.newHashSet()));
                HashSet newDependencies = Sets.newHashSet((Iterable)model.func_187965_e());
                for (RenderMaterial tex : textures) {
                    IMetadataSectionCTM meta = null;
                    try {
                        meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(tex.func_229313_b_()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (meta == null) continue;
                    shouldWrap = true;
                }
                for (ResourceLocation newDep : newDependencies) {
                    if (!seenModels.add(newDep)) continue;
                    dependencies.push(newDep);
                }
            }
            this.wrappedModels.put((Object)rl, shouldWrap);
            if (!shouldWrap) continue;
            try {
                event.getModelRegistry().put(rl, this.wrap(rl, rootModel, baked, event.getModelLoader()));
                dependencies.clear();
            }
            catch (IOException e) {
                CTM.logger.error("Could not wrap model " + rl + ". Aborting...", (Throwable)e);
            }
        }
    }

    @Nonnull
    private IBakedModel wrap(ResourceLocation loc, IUnbakedModel model, IBakedModel object, ModelLoader loader) throws IOException {
        ModelCTM modelchisel = new ModelCTM(model);
        modelchisel.initializeTextures((ModelBakery)loader, m -> (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(m.func_229310_a_()).apply(m.func_229313_b_()));
        return new ModelBakedCTM(modelchisel, object);
    }

    public void invalidateCaches() {
        this.registeredTextures.clear();
        this.wrappedModels.clear();
    }
}

