/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class RopeBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty KNOT = BooleanProperty.m_61465_((String)"knot");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !this.canHangFrom((LevelReader)world, facingPos, facingState)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)state.m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(!facingState.m_60713_((Block)this)));
        }
        return state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        if (this.canHangAt((LevelReader)world, pos = context.m_8083_())) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)KNOT, (Comparable)Boolean.valueOf(this.isKnottedAt((LevelReader)world, pos)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return this.canHangAt(world, pos);
    }

    private boolean canHangAt(LevelReader world, BlockPos pos) {
        BlockPos attachPos = pos.m_7494_();
        BlockState attachState = world.m_8055_(attachPos);
        return this.canHangFrom(world, attachPos, attachState);
    }

    private boolean canHangFrom(LevelReader world, BlockPos attachPos, BlockState attachState) {
        return attachState.m_60713_((Block)this) || Block.m_49863_((LevelReader)world, (BlockPos)attachPos, (Direction)Direction.DOWN) || attachState.m_204336_(BlockTags.f_13035_);
    }

    private boolean isKnottedAt(LevelReader world, BlockPos pos) {
        return !world.m_8055_(pos.m_7495_()).m_60713_((Block)this);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{KNOT, WATERLOGGED});
    }
}

