/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.entity.vfx.PartyBeamEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PartyBeamRenderer
extends EntityRenderer<PartyBeamEntity> {
    private static final ResourceLocation END_CRYSTAL_LOCATION = new ResourceLocation("textures/entity/end_crystal/end_crystal.png");
    private static final RenderType BEAM = RenderType.m_110476_((ResourceLocation)EnderDragonRenderer.f_114174_);
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)END_CRYSTAL_LOCATION);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private static final String GLASS = "glass";
    private static final String BASE = "base";
    private final ModelPart cube;
    private final ModelPart glass;
    private final ModelPart base;

    public PartyBeamRenderer(EntityRendererProvider.Context p_173970_) {
        super(p_173970_);
        this.f_114477_ = 0.5f;
        ModelPart modelpart = p_173970_.m_174023_(ModelLayers.f_171145_);
        this.glass = modelpart.m_171324_(GLASS);
        this.cube = modelpart.m_171324_("cube");
        this.base = modelpart.m_171324_(BASE);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(GLASS, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partdefinition.m_171599_("cube", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partdefinition.m_171599_(BASE, CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-6.0f, 0.0f, -6.0f, 12.0f, 4.0f, 12.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void render(PartyBeamEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        float f = PartyBeamRenderer.getY(pEntity, pPartialTicks);
        float f1 = ((float)pEntity.f_31032_ + pPartialTicks) * 3.0f;
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RENDER_TYPE);
        pMatrixStack.m_85836_();
        pMatrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        pMatrixStack.m_85837_(0.0, -0.5, 0.0);
        int i = OverlayTexture.f_118083_;
        if (pEntity.m_31065_()) {
            this.base.m_104301_(pMatrixStack, vertexconsumer, pPackedLight, i);
        }
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        pMatrixStack.m_85837_(0.0, (double)(1.5f + f / 2.0f), 0.0);
        pMatrixStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        this.glass.m_104301_(pMatrixStack, vertexconsumer, pPackedLight, i);
        float f2 = 0.875f;
        pMatrixStack.m_85841_(0.875f, 0.875f, 0.875f);
        pMatrixStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        this.glass.m_104301_(pMatrixStack, vertexconsumer, pPackedLight, i);
        pMatrixStack.m_85841_(0.875f, 0.875f, 0.875f);
        pMatrixStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        this.cube.m_104301_(pMatrixStack, vertexconsumer, pPackedLight, i);
        pMatrixStack.m_85849_();
        pMatrixStack.m_85849_();
        BlockPos blockpos = pEntity.m_31064_();
        if (blockpos != null) {
            float f3 = (float)blockpos.m_123341_() + 0.5f;
            float f4 = (float)blockpos.m_123342_() + 0.5f;
            float f5 = (float)blockpos.m_123343_() + 0.5f;
            float f6 = (float)((double)f3 - pEntity.m_20185_());
            float f7 = (float)((double)f4 - pEntity.m_20186_());
            float f8 = (float)((double)f5 - pEntity.m_20189_());
            pMatrixStack.m_85837_((double)f6, (double)f7, (double)f8);
            this.renderCrystalBeams(pEntity, -f6, -f7 + f, -f8, pPartialTicks, pEntity.f_31032_, pMatrixStack, pBuffer, pPackedLight);
        }
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public void renderCrystalBeams(PartyBeamEntity beam, float p_114188_, float p_114189_, float p_114190_, float p_114191_, int p_114192_, PoseStack p_114193_, MultiBufferSource p_114194_, int p_114195_) {
        float f = Mth.m_14116_((float)(p_114188_ * p_114188_ + p_114190_ * p_114190_));
        float f1 = Mth.m_14116_((float)(p_114188_ * p_114188_ + p_114189_ * p_114189_ + p_114190_ * p_114190_));
        p_114193_.m_85836_();
        p_114193_.m_85837_(0.0, 2.0, 0.0);
        p_114193_.m_85845_(Vector3f.f_122225_.m_122270_((float)(-Math.atan2(p_114190_, p_114188_)) - 1.5707964f));
        p_114193_.m_85845_(Vector3f.f_122223_.m_122270_((float)(-Math.atan2(f, p_114189_)) - 1.5707964f));
        VertexConsumer vertexconsumer = p_114194_.m_6299_(BEAM);
        float f2 = 0.0f - ((float)p_114192_ + p_114191_) * 0.01f;
        float f3 = Mth.m_14116_((float)(p_114188_ * p_114188_ + p_114189_ * p_114189_ + p_114190_ * p_114190_)) / 32.0f - ((float)p_114192_ + p_114191_) * 0.01f;
        int i = 8;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = p_114193_.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_85861_();
        Matrix3f matrix3f = posestack$pose.m_85864_();
        for (int j = 1; j <= 8; ++j) {
            float f7 = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float f8 = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float f9 = (float)j / 8.0f;
            int r = 0;
            int g = 0;
            int b = 0;
            BlockPos color = beam.getColor();
            if (color != null) {
                r = color.m_123341_();
                g = color.m_123342_();
                b = color.m_123343_();
            }
            vertexconsumer.m_85982_(matrix4f, f4 * 0.2f, f5 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114195_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_85982_(matrix4f, f4, f5, f1).m_6122_(r, g, b, 255).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114195_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_85982_(matrix4f, f7, f8, f1).m_6122_(r, g, b, 255).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114195_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_85982_(matrix4f, f7 * 0.2f, f8 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114195_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        p_114193_.m_85849_();
    }

    public static float getY(PartyBeamEntity p_114159_, float p_114160_) {
        float f = (float)p_114159_.f_31032_ + p_114160_;
        float f1 = Mth.m_14031_((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    public ResourceLocation getTextureLocation(PartyBeamEntity pEntity) {
        return END_CRYSTAL_LOCATION;
    }

    public boolean shouldRender(PartyBeamEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return super.m_5523_((Entity)pLivingEntity, pCamera, pCamX, pCamY, pCamZ) || pLivingEntity.m_31064_() != null;
    }
}

