/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.entity.TextEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class TextEntityRenderer
extends EntityRenderer<TextEntity> {
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public TextEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TextEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float alpha = entity.alpha(partialTicks);
        if (alpha < 0.1f) {
            return;
        }
        poseStack.m_85836_();
        Matrix4f pointAlong = entity.pointAlongMatrix();
        if (pointAlong != null) {
            poseStack.m_166854_(pointAlong);
        } else {
            poseStack.m_85845_(this.f_114476_.m_114470_());
        }
        float scale = entity.scale();
        poseStack.m_85841_(-scale, -scale, scale);
        int color = TextEntityRenderer.alphaToColor(alpha) | 0xFFFFFF;
        int backgroundColor = TextEntityRenderer.alphaToColor(alpha * TextEntityRenderer.CLIENT.f_91066_.m_92141_(0.25f));
        Font font = this.f_114476_.f_114365_;
        List lines = font.m_92923_((FormattedText)entity.text(), Integer.MAX_VALUE);
        int n = lines.size();
        Objects.requireNonNull(font);
        float lineY = (float)(-(n * 9)) / 2.0f;
        for (FormattedCharSequence line : lines) {
            font.m_92733_(line, (float)(-font.m_92724_(line)) / 2.0f, lineY, color, false, poseStack.m_85850_().m_85861_(), bufferSource, false, backgroundColor, entity.fullbright() ? 0xF000F0 : packedLight);
            Objects.requireNonNull(font);
            lineY += 9.0f;
        }
        poseStack.m_85849_();
    }

    private static int alphaToColor(float alpha) {
        return Mth.m_14143_((float)(alpha * 255.0f)) << 24;
    }

    public ResourceLocation getTextureLocation(TextEntity entity) {
        return MissingTextureAtlasSprite.m_118071_();
    }
}

