/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class TextEntity
extends Entity {
    private static final EntityDataAccessor<Component> DATA_TEXT = SynchedEntityData.m_135353_(TextEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(TextEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FORWARD_X = SynchedEntityData.m_135353_(TextEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FORWARD_Y = SynchedEntityData.m_135353_(TextEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_FORWARD_Z = SynchedEntityData.m_135353_(TextEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_FULLBRIGHT = SynchedEntityData.m_135353_(TextEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_TARGET_ALPHA = SynchedEntityData.m_135353_(TextEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final float ALPHA_LERP_SPEED = 0.1f;
    private float alpha = 1.0f;
    private float prevAlpha = 1.0f;
    @Nullable
    private Matrix4f pointAlongMatrix;
    private boolean pointAlongMatrixValid;

    public TextEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TEXT, (Object)TextComponent.f_131282_);
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(0.0625f));
        this.f_19804_.m_135372_(DATA_FORWARD_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FORWARD_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FORWARD_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FULLBRIGHT, (Object)false);
        this.f_19804_.m_135372_(DATA_TARGET_ALPHA, (Object)Float.valueOf(1.0f));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (DATA_FORWARD_X.equals(key) || DATA_FORWARD_Y.equals(key) || DATA_FORWARD_Z.equals(key)) {
            this.pointAlongMatrixValid = false;
        } else if (DATA_TARGET_ALPHA.equals(key) && this.f_19803_) {
            this.prevAlpha = this.alpha = ((Float)this.f_19804_.m_135370_(DATA_TARGET_ALPHA)).floatValue();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevAlpha = this.alpha;
        float delta = this.targetAlpha() - this.alpha;
        if (delta > 0.01f) {
            this.alpha += Math.min(0.1f, delta);
        } else if (delta < -0.01f) {
            this.alpha += Math.max(-0.1f, delta);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("text", 8)) {
            try {
                this.setText((Component)Component.Serializer.m_130701_((String)tag.m_128461_("text")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tag.m_128425_("scale", 5)) {
            this.setScale(tag.m_128457_("scale"));
        }
        if (tag.m_128425_("forward", 10)) {
            CompoundTag forward = tag.m_128469_("forward");
            this.setForward(new Vector3f(forward.m_128457_("x"), forward.m_128457_("y"), forward.m_128457_("z")));
        }
        if (tag.m_128425_("fullbright", 1)) {
            this.setFullbright(tag.m_128471_("fullbright"));
        }
        if (tag.m_128425_("alpha", 5)) {
            this.setTargetAlpha(tag.m_128457_("alpha"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("text", Component.Serializer.m_130703_((Component)this.text()));
        tag.m_128350_("scale", this.scale());
        Vector3f forward = this.forward();
        if (forward != null) {
            CompoundTag forwardTag = new CompoundTag();
            forwardTag.m_128350_("x", forward.m_122239_());
            forwardTag.m_128350_("y", forward.m_122260_());
            forwardTag.m_128350_("z", forward.m_122269_());
        }
        tag.m_128379_("fullbright", this.fullbright());
        tag.m_128350_("alpha", this.targetAlpha());
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void setText(Component text) {
        this.f_19804_.m_135381_(DATA_TEXT, (Object)text);
    }

    public Component text() {
        return (Component)this.f_19804_.m_135370_(DATA_TEXT);
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    public float scale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public void setForward(@Nullable Vector3f forward) {
        forward = Objects.requireNonNullElse(forward, Vector3f.f_176763_);
        this.f_19804_.m_135381_(DATA_FORWARD_X, (Object)Float.valueOf(forward.m_122239_()));
        this.f_19804_.m_135381_(DATA_FORWARD_Y, (Object)Float.valueOf(forward.m_122260_()));
        this.f_19804_.m_135381_(DATA_FORWARD_Z, (Object)Float.valueOf(forward.m_122269_()));
    }

    @Nullable
    public Vector3f forward() {
        float x = ((Float)this.f_19804_.m_135370_(DATA_FORWARD_X)).floatValue();
        float y = ((Float)this.f_19804_.m_135370_(DATA_FORWARD_Y)).floatValue();
        float z = ((Float)this.f_19804_.m_135370_(DATA_FORWARD_Z)).floatValue();
        if (Mth.m_14033_((float)x, (float)0.0f) && Mth.m_14033_((float)y, (float)0.0f) && Mth.m_14033_((float)z, (float)0.0f)) {
            return null;
        }
        return new Vector3f(x, y, z);
    }

    public void setFullbright(boolean fullbright) {
        this.f_19804_.m_135381_(DATA_FULLBRIGHT, (Object)fullbright);
    }

    public boolean fullbright() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FULLBRIGHT);
    }

    public void setTargetAlpha(float alpha) {
        this.f_19804_.m_135381_(DATA_TARGET_ALPHA, (Object)Float.valueOf(alpha));
    }

    public float targetAlpha() {
        return ((Float)this.f_19804_.m_135370_(DATA_TARGET_ALPHA)).floatValue();
    }

    public float alpha(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevAlpha, (float)this.alpha);
    }

    @Nullable
    public Matrix4f pointAlongMatrix() {
        if (!this.pointAlongMatrixValid) {
            Vector3f forward = this.forward();
            this.pointAlongMatrix = forward != null ? TextEntity.createPointAlongMatrix(forward) : null;
            this.pointAlongMatrixValid = true;
        }
        return this.pointAlongMatrix;
    }

    private static Matrix4f createPointAlongMatrix(Vector3f pointAlong) {
        pointAlong = pointAlong.m_122281_();
        pointAlong.m_122261_(-1.0f);
        pointAlong.m_122278_();
        Vector3f left = Vector3f.f_122225_.m_122281_();
        left.m_122279_(pointAlong);
        left.m_122278_();
        Vector3f up = pointAlong.m_122281_();
        up.m_122279_(left);
        up.m_122278_();
        return new Matrix4f(new float[]{left.m_122239_(), up.m_122239_(), pointAlong.m_122239_(), 0.0f, left.m_122260_(), up.m_122260_(), pointAlong.m_122260_(), 0.0f, left.m_122269_(), up.m_122269_(), pointAlong.m_122269_(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    }
}

