/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity.vfx;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;

public class PartyBeamEntity
extends EndCrystal {
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_COLOR = SynchedEntityData.m_135353_(PartyBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private BlockPos targetPos = null;

    public PartyBeamEntity(EntityType<? extends EndCrystal> p_31037_, Level p_31038_) {
        super(p_31037_, p_31038_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_ instanceof ServerLevel && this.targetPos != null && this.f_19853_.m_46467_() % 100L == 0L) {
            Random random = this.f_19796_;
            random.setSeed(this.f_19853_.m_46467_());
            int ax = this.targetPos.m_123341_() + (random.nextInt(5) - random.nextInt(5));
            int az = this.targetPos.m_123343_() + (random.nextInt(5) - random.nextInt(5));
            int packed = Mth.m_14169_((float)random.nextFloat(), (float)0.8f, (float)0.8f);
            int r = packed >> 16 & 0xFF;
            int g = packed >> 8 & 0xFF;
            int b = packed & 0xFF;
            this.setColor(new BlockPos(r, g, b));
            this.m_31052_(new BlockPos(ax, this.targetPos.m_123342_(), az));
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.targetPos != null) {
            pCompound.m_128365_("TargetPos", (Tag)NbtUtils.m_129224_((BlockPos)this.targetPos));
        }
        if (this.getColor() != null) {
            pCompound.m_128365_("TargetColor", (Tag)NbtUtils.m_129224_((BlockPos)this.getColor()));
        }
    }

    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("TargetPos", 10)) {
            this.targetPos = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("TargetPos"));
        }
        if (pCompound.m_128425_("TargetColor", 10)) {
            this.setColor(NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("TargetColor")));
        }
    }

    public void setColor(@Nullable BlockPos rgbColorVector) {
        this.m_20088_().m_135381_(DATA_COLOR, Optional.ofNullable(rgbColorVector));
    }

    @Nullable
    public BlockPos getColor() {
        return ((Optional)this.m_20088_().m_135370_(DATA_COLOR)).orElse(null);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLOR, Optional.empty());
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_7639_() instanceof EnderDragon) {
            return false;
        }
        if (!this.m_146910_() && !this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_6074_();
        }
        return true;
    }
}

