/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.ltmoveplus.forge;

import com.corosus.ltmoveplus.config.MovePlusCfgForge;
import com.corosus.ltmoveplus.forge.EventHandlerForge;
import com.corosus.ltmoveplus.forge.MovePlus;
import com.corosus.ltmoveplus.network.MovePlusNetwork;
import com.corosus.ltmoveplus.network.ToServerPlayerCrawlState;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ClientTicker {
    public static boolean needsInit = true;
    public static Vec3 prevMotion;
    public static HashMap<KeyMapping, Long> keyTimesLastPressed;
    public static HashMap<KeyMapping, Boolean> keyLastState;
    public static HashMap<KeyMapping, Vector3f> lookupKeyToDirection;
    public static boolean keepSpectatingPlayer;
    public static String lastPlayerSpectated;
    public static long lastTick;
    public static boolean debug;
    public static int syncDelay;
    public static String csvSpecPlayers;
    public static HashMap<Class, String> cacheClassToCanonicalName;
    public static boolean spectateFixes;

    public static void tickInit() {
        lookupKeyToDirection.put(Minecraft.m_91087_().f_91066_.f_92085_, new Vector3f(1.0f, 0.0f, 0.0f));
        lookupKeyToDirection.put(Minecraft.m_91087_().f_91066_.f_92087_, new Vector3f(-1.0f, 0.0f, 0.0f));
        lookupKeyToDirection.put(Minecraft.m_91087_().f_91066_.f_92086_, new Vector3f(0.0f, -1.0f, 0.0f));
        lookupKeyToDirection.put(Minecraft.m_91087_().f_91066_.f_92088_, new Vector3f(0.0f, 1.0f, 0.0f));
        keyLastState.put(Minecraft.m_91087_().f_91066_.f_92085_, false);
        keyLastState.put(Minecraft.m_91087_().f_91066_.f_92087_, false);
        keyLastState.put(Minecraft.m_91087_().f_91066_.f_92086_, false);
        keyLastState.put(Minecraft.m_91087_().f_91066_.f_92088_, false);
    }

    public static void tickClientRender() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Entity camera = Minecraft.m_91087_().m_91288_();
        if (player == null || camera == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null && (!((Boolean)MovePlusCfgForge.GENERAL.dontGroundDodgeIfSneaking.get()).booleanValue() || player.m_20089_() != Pose.CROUCHING) && ((Boolean)MovePlusCfgForge.GENERAL.useGroundDodge.get()).booleanValue()) {
            ClientTicker.tickDodging();
        }
    }

    public static void tickClientRenderScreen(RenderGameOverlayEvent.Pre event) {
    }

    public static void tickClientRenderWorldLast() {
    }

    public static void tickClientGame() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Entity camera = Minecraft.m_91087_().m_91288_();
        if (player == null || camera == null) {
            return;
        }
        if (needsInit) {
            needsInit = false;
            ClientTicker.tickInit();
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            if (((Boolean)MovePlusCfgForge.GENERAL.useLedgeClimb.get()).booleanValue()) {
                ClientTicker.tickLedgeClimb();
            }
            if ((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get() > 0.0) {
                ClientTicker.tickKnockbackResistence();
            }
        }
        ClientTicker.tickSpectating();
        if (((Boolean)MovePlusCfgForge.GENERAL.useCrawlAnywhere.get()).booleanValue()) {
            ClientTicker.tickCrawl();
        }
    }

    public static void tickSpectating() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Entity camera = Minecraft.m_91087_().m_91288_();
        Minecraft mc = Minecraft.m_91087_();
        long curTime = System.currentTimeMillis();
        if (player == null || camera == null) {
            return;
        }
        if (spectateFixes) {
            Entity specEnt = mc.m_91288_();
            LocalPlayer clientPlayer = mc.f_91074_;
            if (specEnt != null && player != null && player.f_19853_ != null && player.m_5833_()) {
                if (curTime > lastTick + (long)syncDelay) {
                    lastTick = curTime;
                    if (specEnt != clientPlayer) {
                        lastPlayerSpectated = specEnt.m_7755_().getString();
                        keepSpectatingPlayer = true;
                        ClientTicker.dbg("syncing client player to spectator position: " + specEnt);
                        clientPlayer.m_6034_(specEnt.m_20185_(), specEnt.m_20186_(), specEnt.m_20189_());
                    }
                    if (keepSpectatingPlayer && !lastPlayerSpectated.equals("")) {
                        boolean ghostPlayer = false;
                        boolean diffDimensionPlayer = false;
                        AbstractClientPlayer foundNonSpectatingPlayerInSameDimension = null;
                        for (AbstractClientPlayer otherPlayer : mc.f_91073_.m_6907_()) {
                            if (!otherPlayer.m_7755_().getString().equals(lastPlayerSpectated)) continue;
                            foundNonSpectatingPlayerInSameDimension = otherPlayer;
                        }
                        ClientPacketListener clientplaynethandler = mc.f_91074_.f_108617_;
                        PlayerInfo netInfo = clientplaynethandler.m_104938_(lastPlayerSpectated);
                        if (netInfo == null) {
                            ClientTicker.dbg("detected target player not on server");
                        } else if (foundNonSpectatingPlayerInSameDimension == null) {
                            ClientTicker.dbg("detected player in diff dimension");
                            diffDimensionPlayer = true;
                        }
                        boolean isSpectatingASpectator = false;
                        if (specEnt != clientPlayer && specEnt.m_5833_()) {
                            isSpectatingASpectator = true;
                        }
                        if (foundNonSpectatingPlayerInSameDimension != null && foundNonSpectatingPlayerInSameDimension != specEnt) {
                            ghostPlayer = true;
                        }
                        boolean noPlayerToTrack = foundNonSpectatingPlayerInSameDimension == null && !diffDimensionPlayer;
                        boolean usePlayerList = true;
                        if (usePlayerList && !csvSpecPlayers.equals("") && !csvSpecPlayers.equals("OFF")) {
                            ClientTicker.dbg("spec cycle starting: " + csvSpecPlayers);
                            String[] names = csvSpecPlayers.split(",");
                            boolean abort = false;
                            block1: for (int i = 0; i < names.length && !abort; ++i) {
                                names[i] = names[i].trim();
                                ClientTicker.dbg("spec cycle considering: " + names[i]);
                                AbstractClientPlayer foundNonSpectatingPlayerInSameDimension2 = null;
                                for (AbstractClientPlayer otherPlayer : mc.f_91073_.m_6907_()) {
                                    if (abort) continue block1;
                                    if (!otherPlayer.m_7755_().getString().equals(names[i])) continue;
                                    foundNonSpectatingPlayerInSameDimension2 = otherPlayer;
                                    if (!lastPlayerSpectated.equals(foundNonSpectatingPlayerInSameDimension2.m_7755_().getString())) {
                                        lastPlayerSpectated = foundNonSpectatingPlayerInSameDimension2.m_7755_().getString();
                                        ClientTicker.dbg("spec cycle found: " + names[i] + " in dim to spectate, setting " + lastPlayerSpectated);
                                        abort = true;
                                        continue;
                                    }
                                    abort = true;
                                }
                            }
                        }
                    }
                }
                if (clientPlayer.m_20089_() == Pose.CROUCHING) {
                    keepSpectatingPlayer = false;
                    lastPlayerSpectated = "";
                    ClientTicker.dbg("setting keepSpectatingPlayer = false");
                }
            }
        }
    }

    public static void clientChatEvent(ClientChatEvent event) {
        if (!spectateFixes) {
            return;
        }
        ClientTicker.dbg("intercepting chat event: " + event.getMessage());
        if (event.getMessage().startsWith("/mp_spec_csv")) {
            ClientTicker.dbg("mp_spec_csv firing");
            try {
                String[] args = event.getMessage().split(" ");
                csvSpecPlayers = args[1];
                ClientTicker.dbg("csvSpecPlayers set to: " + csvSpecPlayers);
                event.setCanceled(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void dbg(Object obj) {
        if (debug) {
            System.out.println(obj);
        }
    }

    public static void tickDodging() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        lookupKeyToDirection.forEach((k, v) -> ClientTicker.processDodgeKey(k, v));
    }

    public static void processDodgeKey(KeyMapping key, Vector3f vec) {
        long curTime = System.currentTimeMillis();
        long lastTime = ClientTicker.getLastKeyTime(key);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (key.m_90857_() && !keyLastState.get(key).booleanValue()) {
            if (lastTime == -1L) {
                ClientTicker.setLastKeyTime(key, curTime);
            } else if (player.m_20096_() && lastTime + (long)((Integer)MovePlusCfgForge.GENERAL.doubleTapDodgeMaxTimeInMilliseconds.get()).intValue() > curTime) {
                double forceVertical = (Double)MovePlusCfgForge.GENERAL.groundDodgeForceVertical.get();
                double forceHorizontal = (Double)MovePlusCfgForge.GENERAL.groundDodgeForceHorizontal.get();
                ClientTicker.setRelVel((Entity)player, vec.m_122260_(), (float)forceVertical, vec.m_122239_(), (float)forceHorizontal);
                ClientTicker.setLastKeyTime(key, -1L);
                MovePlus.LOGGER.info(":|");
                ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, FMLPaths.CONFIGDIR.get());
            } else {
                ClientTicker.setLastKeyTime(key, curTime);
            }
        }
        if (!key.m_90857_() && keyLastState.get(key).booleanValue()) {
            for (Map.Entry<KeyMapping, Long> entry : keyTimesLastPressed.entrySet()) {
                if (entry.getKey() == key) continue;
                entry.setValue(-1L);
            }
        }
        keyLastState.put(key, key.m_90857_());
    }

    public static void tickLedgeClimb() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Entity camera = Minecraft.m_91087_().m_91288_();
        boolean renderDebug = true;
        if (Minecraft.m_91087_().f_91066_.f_92091_.m_90857_()) {
            float climbSpeed;
            float grabDist = 0.75f;
            Vec3 vec1 = player.m_20154_().m_82490_((double)grabDist);
            Vec3 vec2 = player.m_20154_().m_82490_(-0.25);
            Vector3d lookVec = new Vector3d(vec1.f_82479_, vec1.f_82480_, vec1.f_82481_);
            Vector3d lookVecBehind = new Vector3d(vec2.f_82479_, vec2.f_82480_, vec2.f_82481_);
            double yScanRangeAir = (double)player.m_20192_() + 0.2;
            double yScanRangeSolid = 0.4;
            double yScanRes = 0.2;
            double yAirSize = 0.25;
            double xzSize = 0.3;
            double xzSizeBehind = 0.1;
            AABB playerAABB = player.m_142469_();
            AABB spotForHandsAir = new AABB(player.m_20185_() + lookVec.f_86214_, playerAABB.f_82289_, player.m_20189_() + lookVec.f_86216_, player.m_20185_() + lookVec.f_86214_, playerAABB.f_82289_, player.m_20189_() + lookVec.f_86216_).m_82363_(xzSize, yAirSize, xzSize);
            AABB behindUnderFeet = new AABB(player.m_20185_() + lookVecBehind.f_86214_, playerAABB.f_82289_, player.m_20189_() + lookVecBehind.f_86216_, player.m_20185_() + lookVecBehind.f_86214_, playerAABB.f_82289_, player.m_20189_() + lookVecBehind.f_86216_).m_82377_(xzSizeBehind, xzSizeBehind, xzSizeBehind);
            if (renderDebug) {
                ClientTicker.renderOffsetAABB(behindUnderFeet.m_82386_(-player.m_20185_(), -playerAABB.f_82289_, -player.m_20189_()), 0.0, 0.0, 0.0, 0.0f, 1.0f, 0.0f);
            }
            boolean foundGrabbableSpot = false;
            if (!player.m_20096_() && player.f_19853_.m_45756_((Entity)player, behindUnderFeet)) {
                block0: for (double y = yScanRangeAir; y > 0.25 && !foundGrabbableSpot; y -= yScanRes) {
                    if (!player.f_19853_.m_45756_((Entity)player, spotForHandsAir.m_82386_(0.0, y, 0.0))) continue;
                    AABB aabbRenderAir = spotForHandsAir.m_82386_(-player.m_20185_(), -playerAABB.f_82289_ + y, -player.m_20189_());
                    if (renderDebug) {
                        ClientTicker.renderOffsetAABB(aabbRenderAir.m_82377_(xzSize, 0.0, xzSize), 0.0, 0.0, 0.0, 0.0f, 0.0f, 1.0f);
                    }
                    for (double y2 = 0.0; y2 < yScanRangeSolid; y2 += yScanRes) {
                        AABB aabbTry2 = spotForHandsAir.m_82386_(0.0, y - yAirSize * 1.0 - y2, 0.0);
                        AABB aabbRenderSolid = aabbTry2.m_82386_(-player.m_20185_(), -playerAABB.f_82289_, -player.m_20189_());
                        AABB aabb2 = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).m_82377_(1.0, 1.0, 1.0);
                        if (player.f_19853_.m_45756_((Entity)player, aabbTry2) || !(aabbTry2.f_82289_ + 0.15 > playerAABB.f_82289_)) continue;
                        foundGrabbableSpot = true;
                        if (!renderDebug) continue block0;
                        ClientTicker.renderOffsetAABB(aabbRenderSolid.m_82377_(xzSize, 0.0, xzSize), 0.0, 0.0, 0.0, 1.0f, 0.0f, 0.0f);
                        continue block0;
                    }
                }
            }
            if (foundGrabbableSpot && player.m_20184_().f_82480_ < (double)(climbSpeed = 0.08f)) {
                Vec3 speed = player.m_20184_();
                player.m_20334_(speed.f_82479_, (double)climbSpeed, speed.f_82481_);
            }
        }
    }

    public static void tickKnockbackResistence() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float speed = (float)player.m_20184_().m_82556_();
        if (player.f_20916_ > 0) {
            player.f_20916_ = 0;
            if ((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get() == 1.0) {
                player.m_20256_(prevMotion);
            } else {
                player.m_20334_(ClientTicker.prevMotion.f_82479_ + player.m_20184_().f_82479_ * (1.0 - Math.min((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get(), 1.0)), ClientTicker.prevMotion.f_82480_ + player.m_20184_().f_82480_ > 0.1 ? 0.0 : player.m_20184_().f_82480_ * (1.0 - Math.min((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get(), 1.0)), ClientTicker.prevMotion.f_82481_ + player.m_20184_().f_82479_ * (1.0 - Math.min((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get(), 1.0)));
            }
        } else {
            prevMotion = player.m_20184_().m_82490_(1.0);
        }
    }

    public static long getLastKeyTime(KeyMapping keybind) {
        if (!keyTimesLastPressed.containsKey(keybind)) {
            keyTimesLastPressed.put(keybind, -1L);
        }
        return keyTimesLastPressed.get(keybind);
    }

    public static void setLastKeyTime(KeyMapping keybind, long time) {
        keyTimesLastPressed.put(keybind, time);
    }

    public static void setRelVel(Entity entity, float rightSpeed, float y, float forwardSpeed, float horizontalMultiplier) {
        float var5 = 10.0f;
        float var6 = 0.0f;
        float var7 = entity.f_19859_ + (entity.m_146908_() - entity.f_19859_) * var5;
        int var8 = (int)Math.floor((double)(var7 / 360.0f) + 0.5);
        var7 = var7 - (float)var8 * 360.0f + 270.0f;
        if (forwardSpeed <= 0.0f && forwardSpeed < 0.0f) {
            var7 += 180.0f;
        }
        if (rightSpeed > 0.0f) {
            var7 += 90.0f - forwardSpeed * 10.0f;
        } else if (rightSpeed < 0.0f) {
            var7 += 270.0f + forwardSpeed * 10.0f;
        }
        float var9 = Mth.m_14089_((float)(-var7 * 0.01745329f - 3.141593f));
        float var10 = Mth.m_14031_((float)(-var7 * 0.01745329f - 3.141593f));
        float var11 = -Mth.m_14089_((float)(-var6 * 0.01745329f - 0.7853982f));
        float var13 = var9 * var11;
        float var15 = var10 * var11;
        if (rightSpeed == 0.0f && forwardSpeed == 0.0f) {
            ClientTicker.AddHorizAndSetVerticalVel(entity, (float)entity.m_20184_().f_82479_ / 2.0f, y, (float)entity.m_20184_().f_82481_ / 2.0f);
        } else {
            ClientTicker.AddHorizAndSetVerticalVel(entity, var13 * horizontalMultiplier * -1.0f, y, var15 * horizontalMultiplier);
        }
    }

    public static void AddHorizAndSetVerticalVel(Entity entity, float x, float y, float z) {
        entity.m_20334_(entity.m_20184_().f_82479_ + (double)x, (double)y, entity.m_20184_().f_82481_ + (double)z);
    }

    public static void renderOffsetAABB(AABB bounds, double x, double y, double z, float r, float g, float b) {
    }

    public static String getCanonicalNameCached(Class clazz) {
        if (!cacheClassToCanonicalName.containsKey(clazz)) {
            cacheClassToCanonicalName.put(clazz, clazz.getCanonicalName());
        }
        return cacheClassToCanonicalName.get(clazz);
    }

    public static void tickCrawl() {
        try {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                KeyMapping keySneak = Minecraft.m_91087_().f_91066_.f_92090_;
                KeyMapping keySprint = Minecraft.m_91087_().f_91066_.f_92091_;
                if (keySneak.m_90857_()) {
                    if (keySprint.m_90857_() && !ClientTicker.isCurrentlyCrawling()) {
                        ClientTicker.setCrawling(true);
                        ClientTicker.sendCrawlPacketToServer(true);
                    }
                } else {
                    if (ClientTicker.isCurrentlyCrawling()) {
                        ClientTicker.sendCrawlPacketToServer(false);
                    }
                    ClientTicker.setCrawling(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isCurrentlyCrawling() {
        return EventHandlerForge.playerCrawlingClient;
    }

    public static void setCrawling(boolean crawling) {
        EventHandlerForge.playerCrawlingClient = crawling;
    }

    public static void sendCrawlPacketToServer(boolean isCrawling) {
        MovePlusNetwork.CHANNEL.sendToServer((Object)new ToServerPlayerCrawlState(isCrawling));
    }

    public static boolean isMainClientPlayer(Player player) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        return player.m_142081_() == Minecraft.m_91087_().f_91074_.m_142081_();
    }

    static {
        keyTimesLastPressed = new HashMap();
        keyLastState = new HashMap();
        lookupKeyToDirection = new HashMap();
        keepSpectatingPlayer = false;
        lastPlayerSpectated = "";
        lastTick = 0L;
        debug = false;
        syncDelay = 5000;
        csvSpecPlayers = "";
        cacheClassToCanonicalName = new HashMap();
        spectateFixes = false;
    }
}

