/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.ltmoveplus.forge;

import com.corosus.ltmoveplus.command.CommandReloadConfig;
import com.corosus.ltmoveplus.forge.ClientTicker;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="moveplus")
public class EventHandlerForge {
    public static HashMap<UUID, Boolean> lookupPlayerUUIDToCrawlActive_Server = new HashMap();
    public static boolean playerCrawlingClient = false;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void tickClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientTicker.tickClientGame();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void tickClient(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientTicker.tickClientRender();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            try {
                if (!event.player.f_19853_.m_5776_()) {
                    if (lookupPlayerUUIDToCrawlActive_Server.containsKey(event.player.m_142081_()) && lookupPlayerUUIDToCrawlActive_Server.get(event.player.m_142081_()).booleanValue()) {
                        if (event.player.m_20089_() != Pose.SWIMMING) {
                            event.player.setForcedPose(Pose.SWIMMING);
                        }
                    } else if (event.player.m_20089_() != null) {
                        event.player.setForcedPose(null);
                    }
                } else if (playerCrawlingClient) {
                    if (ClientTicker.isMainClientPlayer(event.player) && event.player.m_20089_() != Pose.SWIMMING) {
                        event.player.setForcedPose(Pose.SWIMMING);
                    }
                } else if (ClientTicker.isMainClientPlayer(event.player) && event.player.m_20089_() != null) {
                    event.player.setForcedPose(null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setPlayerCrawlStateServer(Player player, boolean isCrawling) {
        lookupPlayerUUIDToCrawlActive_Server.put(player.m_142081_(), isCrawling);
    }

    public static void forcePlayerCrawling(Player player) {
        player.setForcedPose(Pose.SWIMMING);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void tickClient(ClientChatEvent event) {
        ClientTicker.clientChatEvent(event);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientChat(ClientChatEvent event) {
        String msg = event.getMessage();
        if (msg.equals("/" + CommandReloadConfig.getCommandName() + " client")) {
            ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, FMLPaths.CONFIGDIR.get());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void drawScreen(RenderGameOverlayEvent.Pre event) {
        ClientTicker.tickClientRenderScreen(event);
    }
}

