/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.IMovedDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MovedDefaultDispenseItemBehaviour
implements IMovedDispenseItemBehaviour {
    private static final MovedDefaultDispenseItemBehaviour DEFAULT_INSTANCE = new MovedDefaultDispenseItemBehaviour();

    public static void doDispense(Level p_82486_0_, ItemStack p_82486_1_, int p_82486_2_, Vec3 facing, BlockPos p_82486_4_, MovementContext context) {
        double d0 = (double)p_82486_4_.m_123341_() + facing.f_82479_ + 0.5;
        double d1 = (double)p_82486_4_.m_123342_() + facing.f_82480_ + 0.5;
        double d2 = (double)p_82486_4_.m_123343_() + facing.f_82481_ + 0.5;
        d1 = Direction.m_122366_((double)facing.f_82479_, (double)facing.f_82480_, (double)facing.f_82481_).m_122434_() == Direction.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        ItemEntity itementity = new ItemEntity(p_82486_0_, d0, d1, d2, p_82486_1_);
        double d3 = p_82486_0_.f_46441_.nextDouble() * 0.1 + 0.2;
        itementity.m_20334_(p_82486_0_.f_46441_.nextGaussian() * (double)0.0075f * (double)p_82486_2_ + facing.m_7096_() * d3 + context.motion.f_82479_, p_82486_0_.f_46441_.nextGaussian() * (double)0.0075f * (double)p_82486_2_ + facing.m_7098_() * d3 + context.motion.f_82480_, p_82486_0_.f_46441_.nextGaussian() * (double)0.0075f * (double)p_82486_2_ + facing.m_7094_() * d3 + context.motion.f_82481_);
        p_82486_0_.m_7967_((Entity)itementity);
    }

    @Override
    public ItemStack dispense(ItemStack itemStack, MovementContext context, BlockPos pos) {
        Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)DispenserBlock.f_52659_)).m_122436_());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        facingVec.m_82541_();
        Direction closestToFacing = this.getClosestFacingDirection(facingVec);
        Container iinventory = HopperBlockEntity.m_59390_((Level)context.world, (BlockPos)pos.m_142300_(closestToFacing));
        if (iinventory == null) {
            this.playDispenseSound((LevelAccessor)context.world, pos);
            this.spawnDispenseParticles((LevelAccessor)context.world, pos, closestToFacing);
            return this.dispenseStack(itemStack, context, pos, facingVec);
        }
        if (HopperBlockEntity.m_59326_(null, (Container)iinventory, (ItemStack)itemStack.m_41777_().m_41620_(1), (Direction)closestToFacing.m_122424_()).m_41619_()) {
            itemStack.m_41774_(1);
        }
        return itemStack;
    }

    protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3 facing) {
        ItemStack itemstack = itemStack.m_41620_(1);
        MovedDefaultDispenseItemBehaviour.doDispense(context.world, itemstack, 6, facing, pos, context);
        return itemStack;
    }

    protected void playDispenseSound(LevelAccessor world, BlockPos pos) {
        world.m_46796_(1000, pos, 0);
    }

    protected void spawnDispenseParticles(LevelAccessor world, BlockPos pos, Vec3 facing) {
        this.spawnDispenseParticles(world, pos, this.getClosestFacingDirection(facing));
    }

    protected void spawnDispenseParticles(LevelAccessor world, BlockPos pos, Direction direction) {
        world.m_46796_(2000, pos, direction.m_122411_());
    }

    protected Direction getClosestFacingDirection(Vec3 exactFacing) {
        return Direction.m_122366_((double)exactFacing.f_82479_, (double)exactFacing.f_82480_, (double)exactFacing.f_82481_);
    }

    protected ItemStack placeItemInInventory(ItemStack consumedFrom, ItemStack output, MovementContext context, BlockPos pos, Vec3 facing) {
        consumedFrom.m_41774_(1);
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)context.contraption.getSharedInventory(), (ItemStack)output.m_41777_(), (boolean)false);
        if (!remainder.m_41619_()) {
            DEFAULT_INSTANCE.dispenseStack(output, context, pos, facing);
        }
        return consumedFrom;
    }
}

