/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.belts.tunnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelFilterSlot;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelItemHandler;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BrassTunnelTileEntity
extends BeltTunnelTileEntity
implements IHaveGoggleInformation {
    SidedFilteringBehaviour filtering;
    boolean connectedLeft;
    boolean connectedRight;
    ItemStack stackToDistribute;
    Direction stackEnteredFrom = null;
    float distributionProgress;
    int distributionDistanceLeft;
    int distributionDistanceRight;
    int previousOutputIndex = 0;
    Couple<List<Pair<BlockPos, Direction>>> distributionTargets = Couple.create(ArrayList::new);
    private boolean syncedOutputActive = false;
    private Set<BrassTunnelTileEntity> syncSet = new HashSet<BrassTunnelTileEntity>();
    protected ScrollOptionBehaviour<SelectionMode> selectionMode;
    private LazyOptional<IItemHandler> beltCapability;
    private LazyOptional<IItemHandler> tunnelCapability;
    private static Random rand = new Random();
    private static Map<Pair<BrassTunnelTileEntity, Direction>, ItemStack> distributed = new IdentityHashMap<Pair<BrassTunnelTileEntity, Direction>, ItemStack>();
    private static Set<Pair<BrassTunnelTileEntity, Direction>> full = new HashSet<Pair<BrassTunnelTileEntity, Direction>>();

    public BrassTunnelTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.stackToDistribute = ItemStack.f_41583_;
        this.beltCapability = LazyOptional.empty();
        this.tunnelCapability = LazyOptional.of(() -> new BrassTunnelItemHandler(this));
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour<SelectionMode>(SelectionMode.class, (Component)Lang.translateDirect("logistics.when_multiple_outputs_available", new Object[0]), this, new CenteredSideValueBoxTransform((state, d) -> d == Direction.UP));
        behaviours.add(this.selectionMode);
        this.selectionMode.requiresWrench();
        this.selectionMode.withCallback(setting -> {
            for (boolean side : Iterate.trueAndFalse) {
                BrassTunnelTileEntity adjacent;
                if (!this.isConnected(side) || (adjacent = this.getAdjacent(side)) == null) continue;
                adjacent.selectionMode.setValue((int)setting);
            }
        });
    }

    @Override
    public void tick() {
        super.tick();
        BeltTileEntity beltBelow = BeltHelper.getSegmentTE((LevelAccessor)this.f_58857_, this.f_58858_.m_7495_());
        if (this.distributionProgress > 0.0f) {
            this.distributionProgress -= 1.0f;
        }
        if (beltBelow == null || beltBelow.getSpeed() == 0.0f) {
            return;
        }
        if (this.stackToDistribute.m_41619_() && !this.syncedOutputActive) {
            return;
        }
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (this.distributionProgress == -1.0f) {
            this.distributionTargets.forEach(List::clear);
            this.distributionDistanceLeft = 0;
            this.distributionDistanceRight = 0;
            this.syncSet.clear();
            List<Pair<BrassTunnelTileEntity, Direction>> validOutputs = this.gatherValidOutputs();
            if (this.selectionMode.get() == SelectionMode.SYNCHRONIZE) {
                boolean notifySyncedOut;
                boolean allEmpty = true;
                boolean allFull = true;
                for (BrassTunnelTileEntity te2 : this.syncSet) {
                    boolean hasStack = !te2.stackToDistribute.m_41619_();
                    allEmpty &= !hasStack;
                    allFull &= hasStack;
                }
                boolean bl = notifySyncedOut = !allEmpty;
                if (allFull || allEmpty) {
                    this.syncSet.forEach(te -> {
                        te.syncedOutputActive = notifySyncedOut;
                    });
                }
            }
            if (validOutputs == null) {
                return;
            }
            if (this.stackToDistribute.m_41619_()) {
                return;
            }
            for (Pair<BrassTunnelTileEntity, Direction> pair : validOutputs) {
                Direction output;
                BrassTunnelTileEntity tunnel = (BrassTunnelTileEntity)pair.getKey();
                if (this.insertIntoTunnel(tunnel, output = (Direction)pair.getValue(), this.stackToDistribute, true) == null) continue;
                this.distributionTargets.get(!tunnel.flapFilterEmpty(output)).add((Pair<BlockPos, Direction>)Pair.of((Object)tunnel.f_58858_, (Object)output));
                int distance = tunnel.f_58858_.m_123341_() + tunnel.f_58858_.m_123343_() - this.f_58858_.m_123341_() - this.f_58858_.m_123343_();
                if (distance < 0) {
                    this.distributionDistanceLeft = Math.max(this.distributionDistanceLeft, -distance);
                    continue;
                }
                this.distributionDistanceRight = Math.max(this.distributionDistanceRight, distance);
            }
            if (((List)this.distributionTargets.getFirst()).isEmpty() && ((List)this.distributionTargets.getSecond()).isEmpty()) {
                return;
            }
            if (this.selectionMode.get() != SelectionMode.SYNCHRONIZE || this.syncedOutputActive) {
                this.distributionProgress = 10.0f;
                this.sendData();
            }
            return;
        }
        if (this.distributionProgress != 0.0f) {
            return;
        }
        this.distributionTargets.forEach(list -> {
            if (this.stackToDistribute.m_41619_()) {
                return;
            }
            ArrayList<Pair<BrassTunnelTileEntity, Direction>> validTargets = new ArrayList<Pair<BrassTunnelTileEntity, Direction>>();
            for (Pair pair : list) {
                BlockEntity te;
                BlockPos tunnelPos = (BlockPos)pair.getKey();
                Direction output = (Direction)pair.getValue();
                if (tunnelPos.equals((Object)this.f_58858_) && output == this.stackEnteredFrom || !((te = this.f_58857_.m_7702_(tunnelPos)) instanceof BrassTunnelTileEntity)) continue;
                validTargets.add((Pair<BrassTunnelTileEntity, Direction>)Pair.of((Object)((BrassTunnelTileEntity)te), (Object)output));
            }
            this.distribute(validTargets);
            this.distributionProgress = -1.0f;
        });
    }

    private void distribute(List<Pair<BrassTunnelTileEntity, Direction>> validTargets) {
        boolean robin;
        int amountTargets = validTargets.size();
        if (amountTargets == 0) {
            return;
        }
        distributed.clear();
        full.clear();
        int indexStart = this.previousOutputIndex % amountTargets;
        SelectionMode mode = this.selectionMode.get();
        boolean force = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.FORCED_SPLIT;
        boolean split = mode == SelectionMode.FORCED_SPLIT || mode == SelectionMode.SPLIT;
        boolean bl = robin = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.ROUND_ROBIN;
        if (mode == SelectionMode.RANDOMIZE) {
            indexStart = rand.nextInt(amountTargets);
        }
        if (mode == SelectionMode.PREFER_NEAREST || mode == SelectionMode.SYNCHRONIZE) {
            indexStart = 0;
        }
        ItemStack toDistribute = this.stackToDistribute.m_41777_();
        for (boolean distributeAgain : Iterate.trueAndFalse) {
            ItemStack toDistributeThisCycle = null;
            int remainingOutputs = amountTargets;
            int leftovers = 0;
            block1: for (boolean simulate : Iterate.trueAndFalse) {
                if (remainingOutputs == 0) break;
                leftovers = 0;
                int index = indexStart;
                int stackSize = toDistribute.m_41613_();
                int splitStackSize = stackSize / remainingOutputs;
                int splitRemainder = stackSize % remainingOutputs;
                int visited = 0;
                toDistributeThisCycle = toDistribute.m_41777_();
                if (!force && !split && simulate) continue;
                while (visited < amountTargets) {
                    ItemStack remainder;
                    int increasedCount;
                    Pair<BrassTunnelTileEntity, Direction> pair = validTargets.get(index);
                    BrassTunnelTileEntity tunnel = (BrassTunnelTileEntity)pair.getKey();
                    Direction side = (Direction)pair.getValue();
                    index = (index + 1) % amountTargets;
                    ++visited;
                    if (full.contains(pair)) {
                        if (!split || !simulate) continue;
                        --remainingOutputs;
                        continue;
                    }
                    int count = split ? splitStackSize + (splitRemainder > 0 ? 1 : 0) : stackSize;
                    ItemStack toOutput = ItemHandlerHelper.copyStackWithSize((ItemStack)toDistributeThisCycle, (int)count);
                    boolean testWithIncreasedCount = distributed.containsKey(pair);
                    int n = increasedCount = testWithIncreasedCount ? distributed.get(pair).m_41613_() : 0;
                    if (testWithIncreasedCount) {
                        toOutput.m_41769_(increasedCount);
                    }
                    if ((remainder = this.insertIntoTunnel(tunnel, side, toOutput, true)) == null || remainder.m_41613_() == (testWithIncreasedCount ? count + 1 : count)) {
                        if (force) {
                            return;
                        }
                        if (split && simulate) {
                            --remainingOutputs;
                        }
                        if (!simulate) {
                            full.add(pair);
                        }
                        if (!robin) continue;
                        continue block1;
                    }
                    if (!remainder.m_41619_() && !simulate) {
                        full.add(pair);
                    }
                    if (!simulate) {
                        toOutput.m_41774_(remainder.m_41613_());
                        distributed.put(pair, toOutput);
                    }
                    leftovers += remainder.m_41613_();
                    toDistributeThisCycle.m_41774_(count);
                    if (toDistributeThisCycle.m_41619_()) continue block1;
                    --splitRemainder;
                    if (split) continue;
                    continue block1;
                }
            }
            toDistribute.m_41764_(toDistributeThisCycle.m_41613_() + leftovers);
            if (leftovers == 0 && distributeAgain || !split) break;
        }
        int failedTransferrals = 0;
        for (Map.Entry<Pair<BrassTunnelTileEntity, Direction>, ItemStack> entry : distributed.entrySet()) {
            Pair<BrassTunnelTileEntity, Direction> pair = entry.getKey();
            failedTransferrals += this.insertIntoTunnel((BrassTunnelTileEntity)pair.getKey(), (Direction)pair.getValue(), entry.getValue(), false).m_41613_();
        }
        toDistribute.m_41769_(failedTransferrals);
        this.stackToDistribute = ItemHandlerHelper.copyStackWithSize((ItemStack)this.stackToDistribute, (int)toDistribute.m_41613_());
        if (this.stackToDistribute.m_41619_()) {
            this.stackEnteredFrom = null;
        }
        ++this.previousOutputIndex;
        this.previousOutputIndex %= amountTargets;
        this.notifyUpdate();
    }

    public void setStackToDistribute(ItemStack stack, @Nullable Direction enteredFrom) {
        this.stackToDistribute = stack;
        this.stackEnteredFrom = enteredFrom;
        this.distributionProgress = -1.0f;
        this.sendData();
        this.m_6596_();
    }

    public ItemStack getStackToDistribute() {
        return this.stackToDistribute;
    }

    public List<ItemStack> grabAllStacksOfGroup(boolean simulate) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack own = this.getStackToDistribute();
        if (!own.m_41619_()) {
            list.add(own);
            if (!simulate) {
                this.setStackToDistribute(ItemStack.f_41583_, null);
            }
        }
        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelTileEntity adjacent = this;
            while (adjacent != null) {
                ItemStack other;
                if (!this.f_58857_.m_46749_(adjacent.m_58899_())) {
                    return null;
                }
                if ((adjacent = adjacent.getAdjacent(left)) == null || (other = adjacent.getStackToDistribute()).m_41619_()) continue;
                list.add(other);
                if (simulate) continue;
                adjacent.setStackToDistribute(ItemStack.f_41583_, null);
            }
        }
        return list;
    }

    @Nullable
    protected ItemStack insertIntoTunnel(BrassTunnelTileEntity tunnel, Direction side, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return stack;
        }
        if (!tunnel.testFlapFilter(side, stack)) {
            return null;
        }
        BeltTileEntity below = BeltHelper.getSegmentTE((LevelAccessor)this.f_58857_, tunnel.f_58858_.m_7495_());
        if (below == null) {
            return null;
        }
        BlockPos offset = tunnel.m_58899_().m_7495_().m_142300_(side);
        DirectBeltInputBehaviour sideOutput = TileEntityBehaviour.get((BlockGetter)this.f_58857_, offset, DirectBeltInputBehaviour.TYPE);
        if (sideOutput != null) {
            if (!sideOutput.canInsertFromSide(side)) {
                return null;
            }
            ItemStack result = sideOutput.handleInsertion(stack, side, simulate);
            if (result.m_41619_() && !simulate) {
                tunnel.flap(side, false);
            }
            return result;
        }
        Direction movementFacing = below.getMovementFacing();
        if (side == movementFacing && !BlockHelper.hasBlockSolidSide(this.f_58857_.m_8055_(offset), (BlockGetter)this.f_58857_, offset, side.m_122424_())) {
            BeltTileEntity controllerTE = below.getControllerTE();
            if (controllerTE == null) {
                return null;
            }
            if (!simulate) {
                tunnel.flap(side, true);
                ItemStack ejected = stack;
                float beltMovementSpeed = below.getDirectionAwareBeltMovementSpeed();
                float movementSpeed = Math.max(Math.abs(beltMovementSpeed), 0.125f);
                int additionalOffset = beltMovementSpeed > 0.0f ? 1 : 0;
                Vec3 outPos = BeltHelper.getVectorForOffset(controllerTE, below.index + additionalOffset);
                Vec3 outMotion = Vec3.m_82528_((Vec3i)side.m_122436_()).m_82490_((double)movementSpeed).m_82520_(0.0, 0.125, 0.0);
                outPos.m_82549_(outMotion.m_82541_());
                ItemEntity entity = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_ + 0.375, outPos.f_82481_, ejected);
                entity.m_20256_(outMotion);
                entity.m_32060_();
                entity.f_19864_ = true;
                this.f_58857_.m_7967_((Entity)entity);
            }
            return ItemStack.f_41583_;
        }
        return null;
    }

    public boolean testFlapFilter(Direction side, ItemStack stack) {
        if (this.filtering == null) {
            return false;
        }
        if (this.filtering.get(side) == null) {
            FilteringBehaviour adjacentFilter = TileEntityBehaviour.get((BlockGetter)this.f_58857_, this.f_58858_.m_142300_(side), FilteringBehaviour.TYPE);
            if (adjacentFilter == null) {
                return true;
            }
            return adjacentFilter.test(stack);
        }
        return this.filtering.test(side, stack);
    }

    public boolean flapFilterEmpty(Direction side) {
        if (this.filtering == null) {
            return false;
        }
        if (this.filtering.get(side) == null) {
            FilteringBehaviour adjacentFilter = TileEntityBehaviour.get((BlockGetter)this.f_58857_, this.f_58858_.m_142300_(side), FilteringBehaviour.TYPE);
            if (adjacentFilter == null) {
                return true;
            }
            return adjacentFilter.getFilter().m_41619_();
        }
        return this.filtering.getFilter(side).m_41619_();
    }

    @Override
    public void initialize() {
        if (this.filtering == null) {
            this.filtering = this.createSidedFilter();
            this.attachBehaviourLate(this.filtering);
        }
        super.initialize();
    }

    public boolean canInsert(Direction side, ItemStack stack) {
        if (this.filtering != null && !this.filtering.test(side, stack)) {
            return false;
        }
        if (!this.hasDistributionBehaviour()) {
            return true;
        }
        return this.stackToDistribute.m_41619_();
    }

    public boolean hasDistributionBehaviour() {
        if (this.flaps.isEmpty()) {
            return false;
        }
        if (this.connectedLeft || this.connectedRight) {
            return true;
        }
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.BRASS_TUNNEL.has(blockState)) {
            return false;
        }
        Direction.Axis axis = (Direction.Axis)blockState.m_61143_(BrassTunnelBlock.HORIZONTAL_AXIS);
        for (Direction direction : this.flaps.keySet()) {
            if (direction.m_122434_() == axis) continue;
            return true;
        }
        return false;
    }

    private List<Pair<BrassTunnelTileEntity, Direction>> gatherValidOutputs() {
        ArrayList<Pair<BrassTunnelTileEntity, Direction>> validOutputs = new ArrayList<Pair<BrassTunnelTileEntity, Direction>>();
        boolean synchronize = this.selectionMode.get() == SelectionMode.SYNCHRONIZE;
        this.addValidOutputsOf(this, validOutputs);
        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelTileEntity adjacent = this;
            while (adjacent != null) {
                if (!this.f_58857_.m_46749_(adjacent.m_58899_())) {
                    return null;
                }
                if ((adjacent = adjacent.getAdjacent(left)) == null) continue;
                this.addValidOutputsOf(adjacent, validOutputs);
            }
        }
        if (!this.syncedOutputActive && synchronize) {
            return null;
        }
        return validOutputs;
    }

    private void addValidOutputsOf(BrassTunnelTileEntity tunnelTE, List<Pair<BrassTunnelTileEntity, Direction>> validOutputs) {
        this.syncSet.add(tunnelTE);
        BeltTileEntity below = BeltHelper.getSegmentTE((LevelAccessor)this.f_58857_, tunnelTE.f_58858_.m_7495_());
        if (below == null) {
            return;
        }
        Direction movementFacing = below.getMovementFacing();
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.BRASS_TUNNEL.has(blockState)) {
            return;
        }
        boolean prioritizeSides = tunnelTE == this;
        for (boolean sidePass : Iterate.trueAndFalse) {
            if (!prioritizeSides && sidePass) continue;
            for (Direction direction : Iterate.horizontalDirections) {
                BlockPos offset;
                BlockState potentialFunnel;
                if (direction == movementFacing && below.getSpeed() == 0.0f || prioritizeSides && sidePass == (direction.m_122434_() == movementFacing.m_122434_()) || direction == movementFacing.m_122424_() || !tunnelTE.sides.contains(direction) || (potentialFunnel = this.f_58857_.m_8055_((offset = tunnelTE.f_58858_.m_7495_().m_142300_(direction)).m_7494_())).m_60734_() instanceof BeltFunnelBlock && potentialFunnel.m_61143_(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.PULLING && FunnelBlock.getFunnelFacing(potentialFunnel) == direction) continue;
                DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get((BlockGetter)this.f_58857_, offset, DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null) {
                    if (direction != movementFacing || BlockHelper.hasBlockSolidSide(this.f_58857_.m_8055_(offset), (BlockGetter)this.f_58857_, offset, direction.m_122424_())) continue;
                    validOutputs.add((Pair<BrassTunnelTileEntity, Direction>)Pair.of((Object)tunnelTE, (Object)direction));
                    continue;
                }
                if (!inputBehaviour.canInsertFromSide(direction)) continue;
                validOutputs.add((Pair<BrassTunnelTileEntity, Direction>)Pair.of((Object)tunnelTE, (Object)direction));
            }
        }
    }

    @Override
    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
        super.addBehavioursDeferred(behaviours);
        this.filtering = this.createSidedFilter();
        behaviours.add(this.filtering);
    }

    protected SidedFilteringBehaviour createSidedFilter() {
        return new SidedFilteringBehaviour(this, new BrassTunnelFilterSlot(), this::makeFilter, this::isValidFaceForFilter);
    }

    private FilteringBehaviour makeFilter(Direction side, FilteringBehaviour filter) {
        return filter;
    }

    private boolean isValidFaceForFilter(Direction side) {
        return this.sides.contains(side);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("SyncedOutput", this.syncedOutputActive);
        compound.m_128379_("ConnectedLeft", this.connectedLeft);
        compound.m_128379_("ConnectedRight", this.connectedRight);
        compound.m_128365_("StackToDistribute", (Tag)this.stackToDistribute.serializeNBT());
        if (this.stackEnteredFrom != null) {
            NBTHelper.writeEnum(compound, "StackEnteredFrom", this.stackEnteredFrom);
        }
        compound.m_128350_("DistributionProgress", this.distributionProgress);
        compound.m_128405_("PreviousIndex", this.previousOutputIndex);
        compound.m_128405_("DistanceLeft", this.distributionDistanceLeft);
        compound.m_128405_("DistanceRight", this.distributionDistanceRight);
        for (boolean filtered : Iterate.trueAndFalse) {
            compound.m_128365_(filtered ? "FilteredTargets" : "Targets", (Tag)NBTHelper.writeCompoundList((Iterable)this.distributionTargets.get(filtered), pair -> {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)pair.getKey())));
                nbt.m_128405_("Face", ((Direction)pair.getValue()).m_122411_());
                return nbt;
            }));
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean wasConnectedLeft = this.connectedLeft;
        boolean wasConnectedRight = this.connectedRight;
        this.syncedOutputActive = compound.m_128471_("SyncedOutput");
        this.connectedLeft = compound.m_128471_("ConnectedLeft");
        this.connectedRight = compound.m_128471_("ConnectedRight");
        this.stackToDistribute = ItemStack.m_41712_((CompoundTag)compound.m_128469_("StackToDistribute"));
        this.stackEnteredFrom = compound.m_128441_("StackEnteredFrom") ? NBTHelper.readEnum(compound, "StackEnteredFrom", Direction.class) : null;
        this.distributionProgress = compound.m_128457_("DistributionProgress");
        this.previousOutputIndex = compound.m_128451_("PreviousIndex");
        this.distributionDistanceLeft = compound.m_128451_("DistanceLeft");
        this.distributionDistanceRight = compound.m_128451_("DistanceRight");
        for (boolean filtered : Iterate.trueAndFalse) {
            this.distributionTargets.set(filtered, NBTHelper.readCompoundList(compound.m_128437_(filtered ? "FilteredTargets" : "Targets", 10), nbt -> {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Pos"));
                Direction face = Direction.m_122376_((int)nbt.m_128451_("Face"));
                return Pair.of((Object)pos, (Object)face);
            }));
        }
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (wasConnectedLeft != this.connectedLeft || wasConnectedRight != this.connectedRight) {
            this.requestModelDataUpdate();
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
        }
        this.filtering.updateFilterPresence();
    }

    public boolean isConnected(boolean leftSide) {
        return leftSide ? this.connectedLeft : this.connectedRight;
    }

    @Override
    public void updateTunnelConnections() {
        BrassTunnelTileEntity adjacent;
        super.updateTunnelConnections();
        boolean connectivityChanged = false;
        boolean nowConnectedLeft = this.determineIfConnected(true);
        boolean nowConnectedRight = this.determineIfConnected(false);
        if (this.connectedLeft != nowConnectedLeft) {
            this.connectedLeft = nowConnectedLeft;
            connectivityChanged = true;
            adjacent = this.getAdjacent(true);
            if (adjacent != null && !this.f_58857_.f_46443_) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(this.selectionMode.getValue());
            }
        }
        if (this.connectedRight != nowConnectedRight) {
            this.connectedRight = nowConnectedRight;
            connectivityChanged = true;
            adjacent = this.getAdjacent(false);
            if (adjacent != null && !this.f_58857_.f_46443_) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(this.selectionMode.getValue());
            }
        }
        if (this.filtering != null) {
            this.filtering.updateFilterPresence();
        }
        if (connectivityChanged) {
            this.sendData();
        }
    }

    protected boolean determineIfConnected(boolean leftSide) {
        if (this.flaps.isEmpty()) {
            return false;
        }
        BrassTunnelTileEntity adjacentTunnelTE = this.getAdjacent(leftSide);
        return adjacentTunnelTE != null && !adjacentTunnelTE.flaps.isEmpty();
    }

    @Nullable
    protected BrassTunnelTileEntity getAdjacent(boolean leftSide) {
        if (!this.m_58898_()) {
            return null;
        }
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.BRASS_TUNNEL.has(blockState)) {
            return null;
        }
        Direction.Axis axis = (Direction.Axis)blockState.m_61143_(BrassTunnelBlock.HORIZONTAL_AXIS);
        Direction baseDirection = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        Direction direction = leftSide ? baseDirection.m_122428_() : baseDirection.m_122427_();
        BlockPos adjacentPos = this.f_58858_.m_142300_(direction);
        BlockState adjacentBlockState = this.f_58857_.m_8055_(adjacentPos);
        if (!AllBlocks.BRASS_TUNNEL.has(adjacentBlockState)) {
            return null;
        }
        if (adjacentBlockState.m_61143_(BrassTunnelBlock.HORIZONTAL_AXIS) != axis) {
            return null;
        }
        BlockEntity adjacentTE = this.f_58857_.m_7702_(adjacentPos);
        if (adjacentTE.m_58901_()) {
            return null;
        }
        if (!(adjacentTE instanceof BrassTunnelTileEntity)) {
            return null;
        }
        return (BrassTunnelTileEntity)adjacentTE;
    }

    @Override
    public void m_7651_() {
        this.tunnelCapability.invalidate();
        super.m_7651_();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.tunnelCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public LazyOptional<IItemHandler> getBeltCapability() {
        BlockEntity tileEntity;
        if (!this.beltCapability.isPresent() && (tileEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) != null) {
            this.beltCapability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        }
        return this.beltCapability;
    }

    public boolean canTakeItems() {
        return this.stackToDistribute.m_41619_() && !this.syncedOutputActive;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        List<ItemStack> allStacks = this.grabAllStacksOfGroup(true);
        if (allStacks.isEmpty()) {
            return false;
        }
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect("tooltip.brass_tunnel.contains", new Object[0])).m_130940_(ChatFormatting.WHITE));
        for (ItemStack item : allStacks) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect("tooltip.brass_tunnel.contains_entry", Components.translatable(item.m_41778_()).getString(), item.m_41613_())).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect("tooltip.brass_tunnel.retrieve", new Object[0])).m_130940_(ChatFormatting.DARK_GRAY));
        return true;
    }

    public static enum SelectionMode implements INamedIconOptions
    {
        SPLIT(AllIcons.I_TUNNEL_SPLIT),
        FORCED_SPLIT(AllIcons.I_TUNNEL_FORCED_SPLIT),
        ROUND_ROBIN(AllIcons.I_TUNNEL_ROUND_ROBIN),
        FORCED_ROUND_ROBIN(AllIcons.I_TUNNEL_FORCED_ROUND_ROBIN),
        PREFER_NEAREST(AllIcons.I_TUNNEL_PREFER_NEAREST),
        RANDOMIZE(AllIcons.I_TUNNEL_RANDOMIZE),
        SYNCHRONIZE(AllIcons.I_TUNNEL_SYNCHRONIZE);

        private final String translationKey;
        private final AllIcons icon;

        private SelectionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "tunnel.selection_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

