/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchTileEntity;
import com.simibubi.create.content.logistics.packet.ConfigureStockswitchPacket;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class StockpileSwitchScreen
extends AbstractSimiScreen {
    private ScrollInput offBelow;
    private ScrollInput onAbove;
    private IconButton confirmButton;
    private IconButton flipSignals;
    private final Component invertSignal = Lang.translateDirect("gui.stockpile_switch.invert_signal", new Object[0]);
    private final ItemStack renderedItem = new ItemStack((ItemLike)AllBlocks.STOCKPILE_SWITCH.get());
    private AllGuiTextures background = AllGuiTextures.STOCKSWITCH;
    private StockpileSwitchTileEntity te;
    private int lastModification;
    private LerpedFloat cursor;
    private LerpedFloat cursorLane;

    public StockpileSwitchScreen(StockpileSwitchTileEntity te) {
        super((Component)Lang.translateDirect("gui.stockpile_switch.title", new Object[0]));
        this.te = te;
        this.lastModification = -1;
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-20, 0);
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.cursor = LerpedFloat.linear().startWithValue(this.te.getLevelForDisplay());
        this.cursorLane = LerpedFloat.linear().startWithValue(this.te.getState() ? 1.0 : 0.0);
        this.offBelow = new ScrollInput(x + 36, y + 40, 102, 18).withRange(0, 100).titled(Components.empty()).calling(state -> {
            this.lastModification = 0;
            this.offBelow.titled(Lang.translateDirect("gui.stockpile_switch.move_to_upper_at", state));
            if (this.onAbove.getState() <= state) {
                this.onAbove.setState(state + 1);
                this.onAbove.onChanged();
            }
        }).setState((int)(this.te.offWhenBelow * 100.0f));
        this.onAbove = new ScrollInput(x + 36, y + 18, 102, 18).withRange(1, 101).titled(Components.empty()).calling(state -> {
            this.lastModification = 0;
            this.onAbove.titled(Lang.translateDirect("gui.stockpile_switch.move_to_lower_at", state));
            if (this.offBelow.getState() >= state) {
                this.offBelow.setState(state - 1);
                this.offBelow.onChanged();
            }
        }).setState((int)(this.te.onWhenAbove * 100.0f));
        this.onAbove.onChanged();
        this.offBelow.onChanged();
        this.m_142416_(this.onAbove);
        this.m_142416_(this.offBelow);
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.m_7379_());
        this.m_142416_(this.confirmButton);
        this.flipSignals = new IconButton(x + 14, y + 40, AllIcons.I_FLIP);
        this.flipSignals.withCallback(() -> this.send(!this.te.isInverted()));
        this.flipSignals.setToolTip(this.invertSignal);
        this.m_142416_(this.flipSignals);
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(ms, x, y, (GuiComponent)this);
        AllGuiTextures.STOCKSWITCH_POWERED_LANE.render(ms, x + 36, y + (this.te.isInverted() ? 18 : 40), (GuiComponent)this);
        AllGuiTextures.STOCKSWITCH_UNPOWERED_LANE.render(ms, x + 36, y + (this.te.isInverted() ? 40 : 18), (GuiComponent)this);
        StockpileSwitchScreen.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)this.f_96539_, (int)(x + (this.background.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        AllGuiTextures sprite = AllGuiTextures.STOCKSWITCH_INTERVAL;
        float lowerBound = this.offBelow.getState();
        float upperBound = this.onAbove.getState();
        sprite.bind();
        this.m_93228_(ms, (int)((float)x + upperBound) + 37, y + 18, (int)((float)sprite.startX + upperBound), sprite.startY, (int)((float)sprite.width - upperBound), sprite.height);
        this.m_93228_(ms, x + 37, y + 40, sprite.startX, sprite.startY, (int)lowerBound, sprite.height);
        AllGuiTextures.STOCKSWITCH_ARROW_UP.render(ms, (int)((float)x + lowerBound + 36.0f) - 2, y + 35, (GuiComponent)this);
        AllGuiTextures.STOCKSWITCH_ARROW_DOWN.render(ms, (int)((float)x + upperBound + 36.0f) - 3, y + 17, (GuiComponent)this);
        if (this.te.currentLevel != -1.0f) {
            AllGuiTextures cursor = AllGuiTextures.STOCKSWITCH_CURSOR;
            ms.m_85836_();
            ms.m_85837_((double)Math.min(99.0f, this.cursor.getValue(partialTicks) * (float)sprite.width), (double)(this.cursorLane.getValue(partialTicks) * 22.0f), 0.0);
            cursor.render(ms, x + 34, y + 19, (GuiComponent)this);
            ms.m_85849_();
        }
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.renderedItem).at(x + this.background.width + 6, y + this.background.height - 56, -200.0f)).scale(5.0).render(ms);
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        this.cursor.chase(this.te.getLevelForDisplay(), 0.25, LerpedFloat.Chaser.EXP);
        this.cursor.tickChaser();
        this.cursorLane.chase(this.te.getState() ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.cursorLane.tickChaser();
        if (this.lastModification >= 0) {
            ++this.lastModification;
        }
        if (this.lastModification >= 20) {
            this.lastModification = -1;
            this.send(this.te.isInverted());
        }
    }

    public void m_7861_() {
        this.send(this.te.isInverted());
    }

    protected void send(boolean invert) {
        AllPackets.channel.sendToServer((Object)new ConfigureStockswitchPacket(this.te.m_58899_(), (float)this.offBelow.getState() / 100.0f, (float)this.onAbove.getState() / 100.0f, invert));
    }
}

