/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandlerClient;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackGraphHelper;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainRelocationPacket;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.content.logistics.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.logistics.trains.track.TrackBlockOutline;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class TrainRelocator {
    static WeakReference<CarriageContraptionEntity> hoveredEntity = new WeakReference<Object>(null);
    static UUID relocatingTrain;
    static Vec3 relocatingOrigin;
    static int relocatingEntityId;
    static BlockPos lastHoveredPos;
    static BezierTrackPointLocation lastHoveredBezierSegment;
    static Boolean lastHoveredResult;
    static List<Vec3> toVisualise;

    public static boolean isRelocating() {
        return relocatingTrain != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onClicked(InputEvent.ClickInputEvent event) {
        if (relocatingTrain == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (!player.m_20182_().m_82509_((Position)relocatingOrigin, 24.0) || player.m_20161_()) {
            relocatingTrain = null;
            player.m_5661_((Component)Lang.translateDirect("train.relocate.abort", new Object[0]).m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (player.m_20159_()) {
            return;
        }
        if (mc.f_91073_ == null) {
            return;
        }
        Train relocating = TrainRelocator.getRelocating((LevelAccessor)mc.f_91073_);
        if (relocating != null) {
            Boolean relocate = TrainRelocator.relocateClient(relocating, false);
            if (relocate != null && relocate.booleanValue()) {
                relocatingTrain = null;
            }
            if (relocate != null) {
                event.setCanceled(true);
            }
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Boolean relocateClient(Train relocating, boolean simulate) {
        BlockState blockState;
        Block block;
        TrackBlockOutline.BezierPointSelection bezierSelection;
        Minecraft mc = Minecraft.m_91087_();
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult blockhit = (BlockHitResult)hitResult;
        BlockPos blockPos = blockhit.m_82425_();
        BezierTrackPointLocation hoveredBezier = null;
        if (simulate && toVisualise != null && lastHoveredResult != null) {
            for (int i = 0; i < toVisualise.size() - 1; ++i) {
                Vec3 vec1 = toVisualise.get(i);
                Vec3 vec2 = toVisualise.get(i + 1);
                CreateClient.OUTLINER.showLine(Pair.of(relocating, i), vec1.m_82520_(0.0, (double)-0.925f, 0.0), vec2.m_82520_(0.0, (double)-0.925f, 0.0)).colored(lastHoveredResult != false || i != toVisualise.size() - 2 ? 9817409 : 15359019).disableNormals().lineWidth(i % 2 == 1 ? 0.16666667f : 0.25f);
            }
        }
        if ((bezierSelection = TrackBlockOutline.result) != null) {
            blockPos = bezierSelection.te().m_58899_();
            hoveredBezier = bezierSelection.loc();
        }
        if (simulate) {
            if (lastHoveredPos != null && lastHoveredPos.equals((Object)blockPos) && Objects.equals(lastHoveredBezierSegment, hoveredBezier)) {
                return lastHoveredResult;
            }
            lastHoveredPos = blockPos;
            lastHoveredBezierSegment = hoveredBezier;
            toVisualise = null;
        }
        if (!((block = (blockState = mc.f_91073_.m_8055_(blockPos)).m_60734_()) instanceof ITrackBlock)) {
            lastHoveredResult = null;
            return null;
        }
        ITrackBlock track = (ITrackBlock)block;
        Vec3 lookAngle = mc.f_91074_.m_20154_();
        boolean direction = bezierSelection != null && lookAngle.m_82526_(bezierSelection.direction()) < 0.0;
        boolean result = TrainRelocator.relocate(relocating, (Level)mc.f_91073_, blockPos, hoveredBezier, direction, lookAngle, true);
        if (!simulate && result) {
            relocating.carriages.forEach(c -> c.forEachPresentEntity(e -> {
                e.nonDamageTicks = 10;
            }));
            AllPackets.channel.sendToServer((Object)new TrainRelocationPacket(relocatingTrain, blockPos, hoveredBezier, direction, lookAngle, relocatingEntityId));
        }
        lastHoveredResult = result;
        return lastHoveredResult;
    }

    public static boolean relocate(Train train, Level level, BlockPos pos, BezierTrackPointLocation bezier, boolean bezierDirection, Vec3 lookAngle, boolean simulate) {
        GraphLocation graphLocation;
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return false;
        }
        ITrackBlock track = (ITrackBlock)block;
        Pair<Vec3, Direction.AxisDirection> nearestTrackAxis = track.getNearestTrackAxis((BlockGetter)level, pos, blockState, lookAngle);
        GraphLocation graphLocation2 = bezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, bezierDirection ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE, bezier) : (graphLocation = TrackGraphHelper.getGraphLocationAt(level, pos, nearestTrackAxis.getSecond(), nearestTrackAxis.getFirst()));
        if (graphLocation == null) {
            return false;
        }
        TrackGraph graph = graphLocation.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)graphLocation.edge.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)graphLocation.edge.getSecond()));
        TrackEdge edge = graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return false;
        }
        TravellingPoint probe = new TravellingPoint(node1, node2, edge, graphLocation.position);
        TravellingPoint.IEdgePointListener ignoreSignals = probe.ignoreEdgePoints();
        TravellingPoint.ITurnListener ignoreTurns = probe.ignoreTurns();
        ArrayList recordedLocations = new ArrayList();
        ArrayList recordedVecs = new ArrayList();
        Consumer<TravellingPoint> recorder = tp -> {
            recordedLocations.add(Pair.of(Couple.create(tp.node1, tp.node2), tp.position));
            recordedVecs.add(tp.getPosition());
        };
        TravellingPoint.ITrackSelector steer = probe.steer(TravellingPoint.SteerDirection.NONE, track.getUpNormal((BlockGetter)level, pos, blockState));
        MutableBoolean blocked = new MutableBoolean(false);
        MutableBoolean portal = new MutableBoolean(false);
        MutableInt blockingIndex = new MutableInt(0);
        train.forEachTravellingPointBackwards((tp, d) -> {
            if (blocked.booleanValue()) {
                return;
            }
            probe.travel(graph, (double)d, steer, ignoreSignals, ignoreTurns, $ -> {
                portal.setTrue();
                return true;
            });
            recorder.accept(probe);
            if (probe.blocked || portal.booleanValue()) {
                blocked.setTrue();
                return;
            }
            blockingIndex.increment();
        });
        if (level.f_46443_ && simulate && !recordedVecs.isEmpty()) {
            toVisualise = new ArrayList<Vec3>();
            toVisualise.add((Vec3)recordedVecs.get(0));
        }
        for (int i = 0; i < recordedVecs.size() - 1; ++i) {
            boolean collided;
            Vec3 vec1 = (Vec3)recordedVecs.get(i);
            Vec3 vec2 = (Vec3)recordedVecs.get(i + 1);
            boolean blocking = i >= blockingIndex.intValue() - 1;
            boolean bl = collided = !blocked.booleanValue() && Train.findCollidingTrain(level, vec1, vec2, train, (ResourceKey<Level>)level.m_46472_()) != null;
            if (level.f_46443_ && simulate) {
                toVisualise.add(vec2);
            }
            if (!collided && !blocking) continue;
            return false;
        }
        if (blocked.booleanValue()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        train.leaveStation();
        train.derailed = false;
        train.navigation.waitingForSignal = null;
        train.occupiedSignalBlocks.clear();
        train.graph = graph;
        train.speed = 0.0;
        train.migratingPoints.clear();
        train.cancelStall();
        if (train.navigation.destination != null) {
            train.navigation.cancelNavigation();
        }
        train.forEachTravellingPoint(tp -> {
            Pair last = (Pair)recordedLocations.remove(recordedLocations.size() - 1);
            tp.node1 = (TrackNode)((Couple)last.getFirst()).getFirst();
            tp.node2 = (TrackNode)((Couple)last.getFirst()).getSecond();
            tp.position = (Double)last.getSecond();
            tp.edge = graph.getConnectionsFrom(tp.node1).get(tp.node2);
        });
        for (Carriage carriage : train.carriages) {
            carriage.updateContraptionAnchors();
        }
        train.status.successfulMigration();
        train.collectInitiallyOccupiedSignalBlocks();
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void visualise(Train train, int i, Vec3 v1, Vec3 v2, boolean valid) {
        CreateClient.OUTLINER.showLine(Pair.of(train, i), v1.m_82520_(0.0, (double)-0.825f, 0.0), v2.m_82520_(0.0, (double)-0.825f, 0.0)).colored(valid ? 9817409 : 15359019).disableNormals().lineWidth(i % 2 == 1 ? 0.16666667f : 0.25f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_20159_()) {
            return;
        }
        if (mc.f_91073_ == null) {
            return;
        }
        if (relocatingTrain != null) {
            AbstractContraptionEntity ce;
            Train relocating = TrainRelocator.getRelocating((LevelAccessor)mc.f_91073_);
            if (relocating == null) {
                relocatingTrain = null;
                return;
            }
            Entity entity = mc.f_91073_.m_6815_(relocatingEntityId);
            if (entity instanceof AbstractContraptionEntity && Math.abs((ce = (AbstractContraptionEntity)entity).m_20318_(0.0f).m_82546_(ce.m_20318_(1.0f)).m_82556_()) > 9.765625E-4) {
                player.m_5661_((Component)Lang.translateDirect("train.cannot_relocate_moving", new Object[0]).m_130940_(ChatFormatting.RED), true);
                relocatingTrain = null;
                return;
            }
            if (!AllItems.WRENCH.isIn(player.m_21205_())) {
                player.m_5661_((Component)Lang.translateDirect("train.relocate.abort", new Object[0]).m_130940_(ChatFormatting.RED), true);
                relocatingTrain = null;
                return;
            }
            if (!player.m_20182_().m_82509_((Position)relocatingOrigin, 24.0)) {
                player.m_5661_((Component)Lang.translateDirect("train.relocate.too_far", new Object[0]).m_130940_(ChatFormatting.RED), true);
                return;
            }
            Boolean success = TrainRelocator.relocateClient(relocating, true);
            if (success == null) {
                player.m_5661_((Component)Lang.translateDirect("train.relocate", relocating.name), true);
            } else if (success.booleanValue()) {
                player.m_5661_((Component)Lang.translateDirect("train.relocate.valid", new Object[0]).m_130940_(ChatFormatting.GREEN), true);
            } else {
                player.m_5661_((Component)Lang.translateDirect("train.relocate.invalid", new Object[0]).m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        Couple<Vec3> rayInputs = ContraptionHandlerClient.getRayInputs(player);
        Vec3 origin = (Vec3)rayInputs.getFirst();
        Vec3 target = (Vec3)rayInputs.getSecond();
        CarriageContraptionEntity currentEntity = (CarriageContraptionEntity)((Object)hoveredEntity.get());
        if (currentEntity != null) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, currentEntity) != null) {
                return;
            }
            hoveredEntity = new WeakReference<Object>(null);
        }
        AABB aabb = new AABB(origin, target);
        List intersectingContraptions = mc.f_91073_.m_45976_(CarriageContraptionEntity.class, aabb);
        for (CarriageContraptionEntity contraptionEntity : intersectingContraptions) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity) == null) continue;
            hoveredEntity = new WeakReference<CarriageContraptionEntity>(contraptionEntity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean carriageWrenched(Vec3 vec3, CarriageContraptionEntity entity) {
        Train train = TrainRelocator.getTrainFromEntity(entity);
        if (train == null) {
            return false;
        }
        relocatingOrigin = vec3;
        relocatingTrain = train.id;
        relocatingEntityId = entity.m_142049_();
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean addToTooltip(List<Component> tooltip, boolean shiftKeyDown) {
        Train train = TrainRelocator.getTrainFromEntity((CarriageContraptionEntity)((Object)hoveredEntity.get()));
        if (train != null && train.derailed) {
            TooltipHelper.addHint(tooltip, "hint.derailed_train", new Object[0]);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Train getRelocating(LevelAccessor level) {
        return relocatingTrain == null ? null : Create.RAILWAYS.sided((LevelAccessor)level).trains.get(relocatingTrain);
    }

    private static Train getTrainFromEntity(CarriageContraptionEntity carriageContraptionEntity) {
        if (carriageContraptionEntity == null) {
            return null;
        }
        Carriage carriage = carriageContraptionEntity.getCarriage();
        if (carriage == null) {
            return null;
        }
        return carriage.train;
    }
}

