/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.config.ui.ConfigAnnotations;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.entries.NumberEntry;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.TickableGuiEventListener;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.element.TextStencilElement;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ConfigScreenList
extends ObjectSelectionList<Entry>
implements TickableGuiEventListener {
    public static EditBox currentText;

    public ConfigScreenList(Minecraft client, int width, int height, int top, int bottom, int elementHeight) {
        super(client, width, height, top, bottom, elementHeight);
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93471_(false);
        currentText = null;
        this.f_93395_ = 3;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        Color c = new Color(0x60000000);
        UIRenderHelper.angledGradient(ms, 90.0f, this.f_93393_ + this.f_93388_ / 2, this.f_93390_, this.f_93388_, 5, c, Color.TRANSPARENT_BLACK);
        UIRenderHelper.angledGradient(ms, -90.0f, this.f_93393_ + this.f_93388_ / 2, this.f_93391_, this.f_93388_, 5, c, Color.TRANSPARENT_BLACK);
        UIRenderHelper.angledGradient(ms, 0.0f, this.f_93393_, this.f_93390_ + this.f_93389_ / 2, this.f_93389_, 5, c, Color.TRANSPARENT_BLACK);
        UIRenderHelper.angledGradient(ms, 180.0f, this.f_93392_, this.f_93390_ + this.f_93389_ / 2, this.f_93389_, 5, c, Color.TRANSPARENT_BLACK);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
    }

    protected void m_93451_(PoseStack p_238478_1_, int p_238478_2_, int p_238478_3_, int p_238478_4_, int p_238478_5_, float p_238478_6_) {
        Window window = this.f_93386_.m_91268_();
        double d0 = window.m_85449_();
        RenderSystem.m_69488_((int)((int)((double)this.f_93393_ * d0)), (int)((int)((double)window.m_85442_() - (double)this.f_93391_ * d0)), (int)((int)((double)this.f_93388_ * d0)), (int)((int)((double)this.f_93389_ * d0)));
        super.m_93451_(p_238478_1_, p_238478_2_, p_238478_3_, p_238478_4_, p_238478_5_, p_238478_6_);
        RenderSystem.m_69471_();
    }

    public boolean m_6375_(double x, double y, int button) {
        this.m_6702_().stream().filter(e -> e instanceof NumberEntry).forEach(e -> e.m_6375_(x, y, button));
        return super.m_6375_(x, y, button);
    }

    public int m_5759_() {
        return this.f_93388_ - 16;
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ - 6;
    }

    @Override
    public void tick() {
        this.m_6702_().forEach(Entry::tick);
    }

    public boolean search(String query) {
        if (query == null || query.isEmpty()) {
            this.m_93410_(0.0);
            return true;
        }
        String q = query.toLowerCase(Locale.ROOT);
        Optional<Entry> first = this.m_6702_().stream().filter(entry -> {
            if (entry.path == null) {
                return false;
            }
            String[] split = entry.path.split("\\.");
            String key = split[split.length - 1].toLowerCase(Locale.ROOT);
            return key.contains(q);
        }).findFirst();
        if (!first.isPresent()) {
            this.m_93410_(0.0);
            return false;
        }
        Entry e = first.get();
        e.annotations.put("highlight", "(:");
        this.m_93494_((AbstractSelectionList.Entry)e);
        return true;
    }

    public void bumpCog(float force) {
        ConfigScreen.cogSpin.bump(3, force);
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements TickableGuiEventListener {
        protected List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
        protected Map<String, String> annotations = new HashMap<String, String>();
        protected String path;

        protected Entry() {
        }

        public boolean m_6375_(double x, double y, int button) {
            return this.getGuiListeners().stream().anyMatch(l -> l.m_6375_(x, y, button));
        }

        public boolean m_7933_(int code, int keyPressed_2_, int keyPressed_3_) {
            return this.getGuiListeners().stream().anyMatch(l -> l.m_7933_(code, keyPressed_2_, keyPressed_3_));
        }

        public boolean m_5534_(char ch, int code) {
            return this.getGuiListeners().stream().anyMatch(l -> l.m_5534_(ch, code));
        }

        @Override
        public void tick() {
        }

        public List<GuiEventListener> getGuiListeners() {
            return this.listeners;
        }

        protected void setEditable(boolean b) {
        }

        protected boolean isCurrentValueChanged() {
            if (this.path == null) {
                return false;
            }
            return ConfigHelper.changes.containsKey(this.path);
        }
    }

    public static class LabeledEntry
    extends Entry {
        protected static final float labelWidthMult = 0.4f;
        protected TextStencilElement label;
        protected List<Component> labelTooltip;
        protected String unit = null;
        protected LerpedFloat differenceAnimation = LerpedFloat.linear().startWithValue(0.0);
        protected LerpedFloat highlightAnimation = LerpedFloat.linear().startWithValue(0.0);

        public LabeledEntry(String label) {
            this.label = new TextStencilElement(Minecraft.m_91087_().f_91062_, label);
            this.label.withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, Theme.p(Theme.Key.TEXT_ACCENT_STRONG)));
            this.labelTooltip = new ArrayList<Component>();
        }

        public LabeledEntry(String label, String path) {
            this(label);
            this.path = path;
        }

        @Override
        public void tick() {
            this.differenceAnimation.tickChaser();
            this.highlightAnimation.tickChaser();
            super.tick();
        }

        public void m_6311_(PoseStack ms, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            float animation;
            if (this.isCurrentValueChanged()) {
                if (this.differenceAnimation.getChaseTarget() != 1.0f) {
                    this.differenceAnimation.chase(1.0, 0.5, LerpedFloat.Chaser.EXP);
                }
            } else if (this.differenceAnimation.getChaseTarget() != 0.0f) {
                this.differenceAnimation.chase(0.0, 0.6f, LerpedFloat.Chaser.EXP);
            }
            if ((animation = this.differenceAnimation.getValue(partialTicks)) > 0.1f) {
                int offset = (int)(30.0f * (1.0f - animation));
                if (this.annotations.containsKey(ConfigAnnotations.RequiresRestart.CLIENT.getName())) {
                    UIRenderHelper.streak(ms, 180.0f, x + width + 10 + offset, y + height / 2, height - 6, 110, new Color(1348472848));
                } else if (this.annotations.containsKey(ConfigAnnotations.RequiresRelog.TRUE.getName())) {
                    UIRenderHelper.streak(ms, 180.0f, x + width + 10 + offset, y + height / 2, height - 6, 110, new Color(1089403671));
                }
                UIRenderHelper.breadcrumbArrow(ms, x - 10 - offset, y + 6, 0, -20, 24, -18, new Color(0x70FFFFFF), Color.TRANSPARENT_BLACK);
            }
            UIRenderHelper.streak(ms, 0.0f, x - 10, y + height / 2, height - 6, width / 8 * 7, -587202560);
            UIRenderHelper.streak(ms, 180.0f, x + (int)((float)width * 1.35f) + 10, y + height / 2, height - 6, width / 8 * 7, -587202560);
            MutableComponent component = this.label.getComponent();
            Font font = Minecraft.m_91087_().f_91062_;
            if (font.m_92852_((FormattedText)component) > this.getLabelWidth(width) - 10) {
                this.label.withText(font.m_92854_((FormattedText)component, this.getLabelWidth(width) - 15).getString() + "...");
            }
            if (this.unit != null) {
                int unitWidth = font.m_92895_(this.unit);
                font.m_92883_(ms, this.unit, (float)(x + this.getLabelWidth(width) - unitWidth - 5), (float)(y + height / 2 + 2), Theme.i(Theme.Key.TEXT_DARKER));
                ((RenderElement)this.label.at(x + 10, y + height / 2 - 10, 0.0f)).render(ms);
            } else {
                ((RenderElement)this.label.at(x + 10, y + height / 2 - 4, 0.0f)).render(ms);
            }
            if (this.annotations.containsKey("highlight")) {
                this.highlightAnimation.startWithValue(1.0).chase(0.0, 0.1f, LerpedFloat.Chaser.LINEAR);
                this.annotations.remove("highlight");
            }
            if ((animation = this.highlightAnimation.getValue(partialTicks)) > 0.01f) {
                Color highlight = new Color(-1593835521).scaleAlpha(animation);
                UIRenderHelper.streak(ms, 0.0f, x - 10, y + height / 2, height - 6, 5, highlight);
                UIRenderHelper.streak(ms, 180.0f, x + width, y + height / 2, height - 6, 5, highlight);
                UIRenderHelper.streak(ms, 90.0f, x + width / 2 - 5, y + 3, width + 10, 5, highlight);
                UIRenderHelper.streak(ms, -90.0f, x + width / 2 - 5, y + height - 3, width + 10, 5, highlight);
            }
            if (mouseX > x && mouseX < x + this.getLabelWidth(width) && mouseY > y + 5 && mouseY < y + height - 5) {
                List<Component> tooltip = this.getLabelTooltip();
                if (tooltip.isEmpty()) {
                    return;
                }
                RenderSystem.m_69471_();
                Screen screen = Minecraft.m_91087_().f_91080_;
                ms.m_85836_();
                ms.m_85837_(0.0, 0.0, 400.0);
                RemovedGuiUtils.drawHoveringText(ms, tooltip, mouseX, mouseY, screen.f_96543_, screen.f_96544_, 300, font);
                ms.m_85849_();
                GlStateManager.m_84501_();
            }
        }

        public List<Component> getLabelTooltip() {
            return this.labelTooltip;
        }

        protected int getLabelWidth(int totalWidth) {
            return totalWidth;
        }

        public Component m_142172_() {
            return Components.immutableEmpty();
        }
    }
}

