/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data.recipe;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.data.recipe.CompactingRecipeGen;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.data.recipe.CrushingRecipeGen;
import com.simibubi.create.foundation.data.recipe.CuttingRecipeGen;
import com.simibubi.create.foundation.data.recipe.DeployingRecipeGen;
import com.simibubi.create.foundation.data.recipe.EmptyingRecipeGen;
import com.simibubi.create.foundation.data.recipe.FillingRecipeGen;
import com.simibubi.create.foundation.data.recipe.HauntingRecipeGen;
import com.simibubi.create.foundation.data.recipe.ItemApplicationRecipeGen;
import com.simibubi.create.foundation.data.recipe.MillingRecipeGen;
import com.simibubi.create.foundation.data.recipe.MixingRecipeGen;
import com.simibubi.create.foundation.data.recipe.PolishingRecipeGen;
import com.simibubi.create.foundation.data.recipe.PressingRecipeGen;
import com.simibubi.create.foundation.data.recipe.WashingRecipeGen;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class ProcessingRecipeGen
extends CreateRecipeProvider {
    protected static final List<ProcessingRecipeGen> GENERATORS = new ArrayList<ProcessingRecipeGen>();
    protected static final int BUCKET = 1000;
    protected static final int BOTTLE = 250;

    public static void registerAll(DataGenerator gen) {
        GENERATORS.add(new CrushingRecipeGen(gen));
        GENERATORS.add(new MillingRecipeGen(gen));
        GENERATORS.add(new CuttingRecipeGen(gen));
        GENERATORS.add(new WashingRecipeGen(gen));
        GENERATORS.add(new PolishingRecipeGen(gen));
        GENERATORS.add(new DeployingRecipeGen(gen));
        GENERATORS.add(new MixingRecipeGen(gen));
        GENERATORS.add(new CompactingRecipeGen(gen));
        GENERATORS.add(new PressingRecipeGen(gen));
        GENERATORS.add(new FillingRecipeGen(gen));
        GENERATORS.add(new EmptyingRecipeGen(gen));
        GENERATORS.add(new HauntingRecipeGen(gen));
        GENERATORS.add(new ItemApplicationRecipeGen(gen));
        gen.m_123914_(new DataProvider(){

            public String m_6055_() {
                return "Create's Processing Recipes";
            }

            public void m_6865_(HashCache dc) throws IOException {
                GENERATORS.forEach(g -> {
                    try {
                        g.m_6865_(dc);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        });
    }

    public ProcessingRecipeGen(DataGenerator generator) {
        super(generator);
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(String namespace, Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        CreateRecipeProvider.GeneratedRecipe generatedRecipe = c -> {
            ItemLike iItemProvider = (ItemLike)singleIngredient.get();
            ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), new ResourceLocation(namespace, RegisteredObjects.getKeyOrThrow(iItemProvider.m_5456_()).m_135815_())).withItemIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{iItemProvider})))).build(c);
        };
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create("create", singleIngredient, transform);
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe createWithDeferredId(Supplier<ResourceLocation> name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        CreateRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), (ResourceLocation)name.get()))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(ResourceLocation name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.createWithDeferredId(() -> name, transform);
    }

    <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create(Create.asResource(name), transform);
    }

    protected abstract IRecipeTypeInfo getRecipeType();

    protected <T extends ProcessingRecipe<?>> ProcessingRecipeSerializer<T> getSerializer() {
        return (ProcessingRecipeSerializer)((Object)this.getRecipeType().getSerializer());
    }

    protected Supplier<ResourceLocation> idWithSuffix(Supplier<ItemLike> item, String suffix) {
        return () -> {
            ResourceLocation registryName = RegisteredObjects.getKeyOrThrow(((ItemLike)item.get()).m_5456_());
            return Create.asResource(registryName.m_135815_() + suffix);
        };
    }

    public String m_6055_() {
        return "Create's Processing Recipes: " + this.getRecipeType().getId().m_135815_();
    }
}

