/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.mixin;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandler;
import java.lang.ref.Reference;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityContraptionInteractionMixin
extends CapabilityProvider<Entity> {
    private final Entity self = (Entity)this;
    private AbstractContraptionEntity contraption;
    @Final
    @Shadow
    protected Random f_19796_;
    @Shadow
    private float f_19829_;

    private EntityContraptionInteractionMixin(Class<Entity> baseClass) {
        super(baseClass);
    }

    @Shadow
    protected abstract float m_6059_();

    @Shadow
    protected abstract void m_7355_(BlockPos var1, BlockState var2);

    private Set<AbstractContraptionEntity> getIntersectingContraptions() {
        Set<AbstractContraptionEntity> contraptions = this.getIntersectionContraptionsStream().collect(Collectors.toSet());
        contraptions.addAll(this.self.f_19853_.m_45976_(AbstractContraptionEntity.class, this.self.m_142469_().m_82400_(1.0)));
        return contraptions;
    }

    private Stream<AbstractContraptionEntity> getIntersectionContraptionsStream() {
        return ContraptionHandler.loadedContraptions.get((LevelAccessor)this.self.f_19853_).values().stream().map(Reference::get).filter(cEntity -> cEntity != null && cEntity.collidingEntities.containsKey(this.self));
    }

    private void forCollision(Vec3 anchorPos, TriConsumer<Contraption, BlockState, BlockPos> action) {
        this.getIntersectingContraptions().forEach(cEntity -> {
            Vec3 localPos = ContraptionCollider.getWorldToLocalTranslation(anchorPos, cEntity);
            localPos = anchorPos.m_82549_(localPos);
            BlockPos blockPos = new BlockPos(localPos);
            Contraption contraption = cEntity.getContraption();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(blockPos);
            if (info != null) {
                BlockState blockstate = info.f_74676_;
                action.accept((Object)contraption, (Object)blockstate, (Object)blockPos);
            }
        });
    }

    @Inject(at={@At(value="JUMP", opcode=154, ordinal=7)}, method={"move"})
    private void movementStepMixin(MoverType mover, Vec3 movement, CallbackInfo ci) {
        Vec3 worldPos = this.self.m_20182_().m_82520_(0.0, -0.2, 0.0);
        AtomicBoolean stepped = new AtomicBoolean(false);
        this.forCollision(worldPos, (TriConsumer<Contraption, BlockState, BlockPos>)((TriConsumer)(contraption, blockstate, blockPos) -> {
            this.bindContraption((Contraption)contraption);
            this.m_7355_((BlockPos)blockPos, (BlockState)blockstate);
            this.unbindContraption();
            stepped.set(true);
        }));
        if (stepped.get()) {
            this.f_19829_ = this.m_6059_();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"move"})
    private void movementMixin(MoverType mover, Vec3 movement, CallbackInfo ci) {
        if (!this.self.f_19853_.f_46443_) {
            return;
        }
        if (this.self.m_20096_()) {
            return;
        }
        if (this.self.m_20159_()) {
            return;
        }
        Vec3 worldPos = this.self.m_20182_().m_82520_(0.0, -0.2, 0.0);
        boolean onAtLeastOneContraption = this.getIntersectionContraptionsStream().anyMatch(cEntity -> {
            Vec3 localPos = ContraptionCollider.getWorldToLocalTranslation(worldPos, cEntity);
            localPos = worldPos.m_82549_(localPos);
            BlockPos blockPos = new BlockPos(localPos);
            Contraption contraption = cEntity.getContraption();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(blockPos);
            if (info == null) {
                return false;
            }
            cEntity.registerColliding(this.self);
            return true;
        });
        if (!onAtLeastOneContraption) {
            return;
        }
        this.self.m_6853_(true);
        this.self.getPersistentData().m_128379_("ContraptionGrounded", true);
    }

    @Inject(method={"spawnSprintParticle"}, at={@At(value="TAIL")})
    private void createRunningParticlesMixin(CallbackInfo ci) {
        Vec3 worldPos = this.self.m_20182_().m_82520_(0.0, -0.2, 0.0);
        BlockPos pos = new BlockPos(worldPos);
        this.forCollision(worldPos, (TriConsumer<Contraption, BlockState, BlockPos>)((TriConsumer)(contraption, blockstate, blockpos) -> {
            if (!blockstate.addRunningEffects(this.self.f_19853_, blockpos, this.self) && blockstate.m_60799_() != RenderShape.INVISIBLE) {
                Vec3 vec3d = this.self.m_20184_();
                this.self.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.self.m_20185_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.self.m_20205_(), this.self.m_20186_() + 0.1, this.self.m_20189_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.self.m_20205_(), vec3d.f_82479_ * -4.0, 1.5, vec3d.f_82481_ * -4.0);
            }
        }));
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void playSoundShifted(SoundEvent event, float pitch, float volume, CallbackInfo ci) {
        if (this.contraption != null && (!this.self.m_20067_() || this.self instanceof Player)) {
            double x = this.self.m_20185_();
            double y = this.self.m_20186_();
            double z = this.self.m_20189_();
            Vec3 worldPos = ContraptionCollider.getWorldToLocalTranslation(new Vec3(x, y, z), this.contraption);
            worldPos = worldPos.m_82520_(x, y, z);
            this.self.f_19853_.m_6263_(null, worldPos.f_82479_ + x, worldPos.f_82480_ + y, worldPos.f_82481_ + z, event, this.self.m_5720_(), pitch, volume);
            ci.cancel();
        }
    }

    private void bindContraption(Contraption contraption) {
        this.bindContraption(contraption.entity);
    }

    private void bindContraption(AbstractContraptionEntity contraption) {
        this.contraption = contraption;
    }

    private void unbindContraption() {
        this.contraption = null;
    }
}

