/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.batching;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.struct.Batched;
import com.jozufozu.flywheel.backend.instancing.AbstractInstancer;
import com.jozufozu.flywheel.backend.instancing.batching.CPUInstancer;
import com.jozufozu.flywheel.core.model.Model;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class BatchedMaterial<D extends InstanceData>
implements Material<D> {
    protected final Map<Object, CPUInstancer<D>> models;
    private final Batched<D> type;

    public BatchedMaterial(Batched<D> type) {
        this.type = type;
        this.models = new HashMap<Object, CPUInstancer<D>>();
    }

    @Override
    public Instancer<D> model(Object key, Supplier<Model> modelSupplier) {
        return this.models.computeIfAbsent(key, $ -> new CPUInstancer<D>(this.type, (Model)modelSupplier.get()));
    }

    public void setupAndRenderInto(PoseStack stack, VertexConsumer buffer) {
        for (CPUInstancer<D> instancer : this.models.values()) {
            instancer.setup();
            instancer.drawAll(stack, buffer);
        }
    }

    public void clear() {
        this.models.values().forEach(AbstractInstancer::clear);
    }
}

