/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Reflection;
import com.mojang.brigadier.CommandDispatcher;
import java.util.regex.Pattern;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.client.BasicColorHandler;
import net.tropicraft.core.client.ClientSetup;
import net.tropicraft.core.client.data.TropicraftBlockstateProvider;
import net.tropicraft.core.client.data.TropicraftItemModelProvider;
import net.tropicraft.core.client.data.TropicraftLangProvider;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.TropicraftBlockEntityTypes;
import net.tropicraft.core.common.command.TropicraftCommands;
import net.tropicraft.core.common.command.debug.MapBiomesCommand;
import net.tropicraft.core.common.data.TropicraftBlockTagsProvider;
import net.tropicraft.core.common.data.TropicraftEntityTypeTagsProvider;
import net.tropicraft.core.common.data.TropicraftItemTagsProvider;
import net.tropicraft.core.common.data.TropicraftLootTableProvider;
import net.tropicraft.core.common.data.TropicraftRecipeProvider;
import net.tropicraft.core.common.data.loot.TropicraftLootConditions;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeSource;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;
import net.tropicraft.core.common.dimension.carver.TropicraftCarvers;
import net.tropicraft.core.common.dimension.carver.TropicraftConfiguredCarvers;
import net.tropicraft.core.common.dimension.chunk.TropicraftChunkGenerator;
import net.tropicraft.core.common.dimension.feature.TropicraftConfiguredStructures;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftMiscFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftMiscPlacements;
import net.tropicraft.core.common.dimension.feature.TropicraftStructureSets;
import net.tropicraft.core.common.dimension.feature.TropicraftTreeFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftTreePlacements;
import net.tropicraft.core.common.dimension.feature.TropicraftVegetationFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftVegetationPlacements;
import net.tropicraft.core.common.dimension.feature.block_state_provider.TropicraftBlockStateProviders;
import net.tropicraft.core.common.dimension.feature.jigsaw.AdjustBuildingHeightProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.AirToCaveAirProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SinkInGroundProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SmoothingGravityProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SteepPathProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureSupportsProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureVoidProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorLists;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.HomeTreeBranchPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.NoRotateSingleJigsawPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.SingleNoAirJigsawPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.TropicraftStructurePieceTypes;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.TropicraftStructurePoolElementTypes;
import net.tropicraft.core.common.dimension.feature.pools.TropicraftTemplatePools;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftFoliagePlacers;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;
import net.tropicraft.core.common.dimension.noise.TropicraftNoiseGenSettings;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.IColoredItem;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.item.scuba.ScubaData;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.network.TropicraftPackets;

@Mod(value="tropicraft")
public class Tropicraft {
    public static final CreativeModeTab TROPICRAFT_ITEM_GROUP = new CreativeModeTab("tropicraft"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)TropicraftBlocks.PALM_SAPLING.get());
        }
    };
    private static final Pattern QUALIFIER = Pattern.compile("-\\w+\\+\\d+");

    public Tropicraft() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(Tropicraft::getCompatVersion, (s, v) -> Tropicraft.isCompatibleVersion(s)));
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::gatherData);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modBus.addListener(this::setupClient);
            modBus.addListener(this::registerItemColors);
        });
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        TropicraftDimension.addDefaultDimensionKey();
        TropicraftBlocks.BLOCKS.register(modBus);
        TropicraftBlocks.BLOCKITEMS.register(modBus);
        TropicraftItems.ITEMS.register(modBus);
        ScubaGogglesItem.ATTRIBUTES.register(modBus);
        MixerRecipes.addMixerRecipes();
        TropicraftBlockEntityTypes.BLOCK_ENTITIES.register(modBus);
        TropicraftEntities.ENTITIES.register(modBus);
        TropicraftCarvers.CARVERS.register(modBus);
        TropicraftFoliagePlacers.REGISTER.register(modBus);
        TropicraftTrunkPlacers.REGISTER.register(modBus);
        TropicraftTreeDecorators.REGISTER.register(modBus);
        TropicraftFeatures.FEATURES.register(modBus);
        TropicraftFeatures.STRUCTURES.register(modBus);
        TropicraftBlockStateProviders.BLOCK_STATE_PROVIDERS.register(modBus);
        TropicraftStructurePieceTypes.REGISTER.register(modBus);
        TropicraftStructurePoolElementTypes.REGISTER.register(modBus);
        TropicraftProcessorTypes.REGISTER.register(modBus);
        TropicraftMiscFeatures.REGISTER.registerTo(modBus);
        TropicraftMiscPlacements.REGISTER.registerTo(modBus);
        TropicraftTreeFeatures.REGISTER.registerTo(modBus);
        TropicraftTreePlacements.REGISTER.registerTo(modBus);
        TropicraftVegetationFeatures.REGISTER.registerTo(modBus);
        TropicraftVegetationPlacements.REGISTER.registerTo(modBus);
        TropicraftProcessorLists.REGISTER.register(modBus);
        TropicraftConfiguredCarvers.REGISTER.register(modBus);
        TropicraftTemplatePools.REGISTER.register(modBus);
        TropicraftConfiguredStructures.REGISTER.register(modBus);
        TropicraftBiomes.REGISTER.register(modBus);
        TropicraftStructureSets.REGISTER.register(modBus);
        TropicraftNoiseGenSettings.REGISTER.register(modBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            StateDefinition frameState = new StateDefinition.Builder((Object)Blocks.f_50016_).m_61104_(new Property[]{BooleanProperty.m_61465_((String)"map")}).m_61101_(Block::m_49966_, BlockState::new);
            ModelBakery.f_119242_ = ImmutableMap.builder().putAll(ModelBakery.f_119242_).put((Object)TropicraftItems.BAMBOO_ITEM_FRAME.getId(), (Object)frameState).build();
        });
    }

    public static String getCompatVersion() {
        return Tropicraft.getCompatVersion(((ModContainer)ModList.get().getModContainerById("tropicraft").orElseThrow(IllegalStateException::new)).getModInfo().getVersion().toString());
    }

    private static String getCompatVersion(String fullVersion) {
        return QUALIFIER.matcher(fullVersion).replaceAll("");
    }

    public static boolean isCompatibleVersion(String version) {
        return Tropicraft.getCompatVersion().equals(Tropicraft.getCompatVersion(version));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        ClientSetup.setupBlockRenderLayers();
        ClientSetup.setupDimensionRenderInfo();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item evt) {
        BasicColorHandler basic = new BasicColorHandler();
        for (RegistryObject ro : TropicraftItems.ITEMS.getEntries()) {
            Item item = (Item)ro.get();
            if (!(item instanceof IColoredItem)) continue;
            evt.getItemColors().m_92689_((ItemColor)basic, new ItemLike[]{item});
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        TropicraftPackets.init();
        TropicraftEntities.registerSpawns();
        TropicraftChunkGenerator.register();
        TropicraftBiomeSource.register();
        Reflection.initialize((Class[])new Class[]{SingleNoAirJigsawPiece.class, NoRotateSingleJigsawPiece.class, HomeTreeBranchPiece.class, AdjustBuildingHeightProcessor.class, AirToCaveAirProcessor.class, SinkInGroundProcessor.class, SmoothingGravityProcessor.class, SteepPathProcessor.class, StructureSupportsProcessor.class, StructureVoidProcessor.class, TropicraftTrunkPlacers.class, TropicraftFoliagePlacers.class, TropicraftTreeDecorators.class, TropicraftLootConditions.class});
    }

    private void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(ScubaData.class);
    }

    private void onServerStarting(ServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        TropicraftCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        if (!FMLEnvironment.production) {
            MapBiomesCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            TropicraftBlockstateProvider blockstates = new TropicraftBlockstateProvider(gen, existingFileHelper);
            gen.m_123914_((DataProvider)blockstates);
            gen.m_123914_((DataProvider)new TropicraftItemModelProvider(gen, blockstates.getExistingHelper()));
            gen.m_123914_((DataProvider)new TropicraftLangProvider(gen));
        }
        if (event.includeServer()) {
            TropicraftBlockTagsProvider blockTags = new TropicraftBlockTagsProvider(gen, existingFileHelper);
            gen.m_123914_((DataProvider)blockTags);
            gen.m_123914_((DataProvider)new TropicraftItemTagsProvider(gen, blockTags, existingFileHelper));
            gen.m_123914_((DataProvider)new TropicraftRecipeProvider(gen));
            gen.m_123914_((DataProvider)new TropicraftLootTableProvider(gen));
            gen.m_123914_((DataProvider)new TropicraftEntityTypeTagsProvider(gen, existingFileHelper));
        }
    }
}

