/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.data;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.AshenMaskItem;
import net.tropicraft.core.common.item.TropicalMusicDiscItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropicraftLangProvider
extends LanguageProvider {
    private final AccessibleLanguageProvider upsideDown;
    private static final String NORMAL_CHARS = "abcdefghijklmn\u00f1opqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'";
    private static final String UPSIDE_DOWN_CHARS = "\u0250q\u0254p\u01dd\u025fb\u0265\u0131\u0638\u029e\u05df\u026fuuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u017f\u029e\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u0196\u1105\u0190\u3123\u03db9\u312586\u203e'\u061b\u02d9\u00bf\u00a1/\\,";

    public TropicraftLangProvider(DataGenerator gen) {
        super(gen, "tropicraft", "en_us");
        this.upsideDown = new AccessibleLanguageProvider(gen, "tropicraft", "en_ud");
    }

    protected void addTranslations() {
        this.addBlock((Supplier)TropicraftBlocks.CHUNK, "Chunk O' Head");
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.AZURITE_ORE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.EUDIALYTE_ORE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGANESE_ORE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.SHAKA_ORE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.ZIRCON_ORE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.AZURITE_BLOCK);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.EUDIALYTE_BLOCK);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGANESE_BLOCK);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.SHAKA_BLOCK);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.ZIRCON_BLOCK);
        TropicraftBlocks.FLOWERS.forEach((f, b) -> this.addBlock((Supplier)b, f.getEnglishName()));
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PURIFIED_SAND);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PACKED_PURIFIED_SAND);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.CORAL_SAND);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.FOAMY_SAND);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.VOLCANIC_SAND);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MINERAL_SAND);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MUD);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MUD_WITH_PIANGUAS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_BUNDLE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.THATCH_BUNDLE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_PLANKS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_PLANKS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_LOG);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_LOG);
        this.addBlock((Supplier)TropicraftBlocks.MAHOGANY_WOOD, "Mahogany Wood");
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_WOOD);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_LOG);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_WOOD);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_LOG);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_WOOD);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_ROOTS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_LOG);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_WOOD);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_ROOTS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_LOG);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_WOOD);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_ROOTS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.STRIPPED_MANGROVE_LOG);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.STRIPPED_MANGROVE_WOOD);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_PLANKS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_STAIRS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.THATCH_STAIRS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.CHUNK_STAIRS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_STAIRS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_STAIRS);
        this.addBlock((Supplier)TropicraftBlocks.THATCH_STAIRS_FUZZY, "Thatch Roof");
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_STAIRS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_SLAB);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.THATCH_SLAB);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.CHUNK_SLAB);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_SLAB);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_SLAB);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_SLAB);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.KAPOK_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.FRUIT_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.GRAPEFRUIT_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.LEMON_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.LIME_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.ORANGE_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.TALL_MANGROVE_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.TEA_MANGROVE_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_LEAVES);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_SAPLING);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_SAPLING);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.GRAPEFRUIT_SAPLING);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.LEMON_SAPLING);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.LIME_SAPLING);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.ORANGE_SAPLING);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_SAPLING);
        this.addBlockWithTooltip((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_PROPAGULE, "Rhizophora mangle");
        this.addBlockWithTooltip((Supplier<? extends Block>)TropicraftBlocks.TALL_MANGROVE_PROPAGULE, "Rhizophora racemosa");
        this.addBlockWithTooltip((Supplier<? extends Block>)TropicraftBlocks.TEA_MANGROVE_PROPAGULE, "Pelliciera rhizophorae");
        this.addBlockWithTooltip((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_PROPAGULE, "Avicennia germinans");
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FENCE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.THATCH_FENCE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.CHUNK_FENCE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_FENCE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_FENCE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_FENCE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FENCE_GATE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.THATCH_FENCE_GATE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.CHUNK_FENCE_GATE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_FENCE_GATE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_FENCE_GATE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_FENCE_GATE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.CHUNK_WALL);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_DOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.THATCH_DOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_DOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_DOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_DOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_TRAPDOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.THATCH_TRAPDOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_TRAPDOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_TRAPDOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_TRAPDOOR);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.IRIS);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PINEAPPLE);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.SMALL_BONGO_DRUM);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MEDIUM_BONGO_DRUM);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.LARGE_BONGO_DRUM);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_LADDER);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_BOARDWALK);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_BOARDWALK);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_BOARDWALK);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_BOARDWALK);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_CHEST);
        this.add("tropicraft.container.bambooChest", "Bamboo Chest");
        this.add("tropicraft.container.bambooChestDouble", "Large Bamboo Chest");
        this.addBlockWithTooltip((Supplier<? extends Block>)TropicraftBlocks.SIFTER, "Place any type of tropics or regular sand in the sifter. What treasures are hidden inside?");
        this.addBlockWithTooltip((Supplier<? extends Block>)TropicraftBlocks.DRINK_MIXER, "Place two drink ingredients on the mixer, then place an empty mug on the base, then ???, then enjoy!");
        this.addBlockWithTooltip((Supplier<? extends Block>)TropicraftBlocks.AIR_COMPRESSOR, "Place an empty scuba harness in the compressor to fill it with air!");
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.VOLCANO);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.TIKI_TORCH);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.COCONUT);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.PAPAYA);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FLOWER_POT);
        TropicraftBlocks.ALL_POTTED_PLANTS.forEach(this::addBlock);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.ZIRCONIUM_BLOCK);
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.COFFEE_BUSH);
        this.addBlock((Supplier)TropicraftBlocks.GOLDEN_LEATHER_FERN, "Golden Leather Fern");
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.TALL_GOLDEN_LEATHER_FERN);
        this.addBlock((Supplier)TropicraftBlocks.LARGE_GOLDEN_LEATHER_FERN, "Large Golden Leather Fern");
        this.addBlock((Supplier<? extends Block>)TropicraftBlocks.REEDS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.AZURITE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.EUDIALYTE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCON);
        this.addItem((Supplier)TropicraftItems.ZIRCONIUM, "Zirconium");
        this.addItem((Supplier<? extends Item>)TropicraftItems.SHAKA);
        this.addItem((Supplier<? extends Item>)TropicraftItems.MANGANESE);
        TropicraftItems.UMBRELLAS.values().forEach(this::addItem);
        TropicraftItems.CHAIRS.values().forEach(this::addItem);
        TropicraftItems.BEACH_FLOATS.values().forEach(this::addItem);
        this.addItem((Supplier<? extends Item>)TropicraftItems.BAMBOO_STICK);
        this.addItem((Supplier<? extends Item>)TropicraftItems.BAMBOO_SPEAR);
        this.addItem((Supplier<? extends Item>)TropicraftItems.BAMBOO_ITEM_FRAME);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SOLONOX_SHELL);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FROX_CONCH);
        this.addItem((Supplier<? extends Item>)TropicraftItems.PAB_SHELL);
        this.addItem((Supplier<? extends Item>)TropicraftItems.RUBE_NAUTILUS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.STARFISH);
        this.addItem((Supplier<? extends Item>)TropicraftItems.TURTLE_SHELL);
        this.addItem((Supplier<? extends Item>)TropicraftItems.LOVE_TROPICS_SHELL);
        this.add("item.tropicraft.shell.owned.normal", "%s's Shell");
        this.add("item.tropicraft.shell.owned.with_s", "%s' Shell");
        this.addItem((Supplier<? extends Item>)TropicraftItems.LEMON);
        this.addItem((Supplier<? extends Item>)TropicraftItems.LIME);
        this.addItem((Supplier<? extends Item>)TropicraftItems.GRAPEFRUIT);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ORANGE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.PINEAPPLE_CUBES);
        this.addItem((Supplier<? extends Item>)TropicraftItems.COCONUT_CHUNK);
        this.addItem((Supplier<? extends Item>)TropicraftItems.RAW_COFFEE_BEAN);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ROASTED_COFFEE_BEAN);
        this.addItem((Supplier<? extends Item>)TropicraftItems.COFFEE_BERRY);
        this.addItem((Supplier<? extends Item>)TropicraftItems.BAMBOO_MUG);
        TropicraftItems.COCKTAILS.forEach((d, c) -> {
            if (d == Drink.PINA_COLADA) {
                this.addItem((Supplier)c, "Pi\u00f1a Colada");
            } else {
                this.addItem((Supplier<? extends Item>)c);
            }
        });
        this.addItem((Supplier<? extends Item>)TropicraftItems.WHITE_PEARL);
        this.addItem((Supplier<? extends Item>)TropicraftItems.BLACK_PEARL);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SCALE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FRESH_MARLIN);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SEARED_MARLIN);
        this.addItem((Supplier<? extends Item>)TropicraftItems.RAW_RAY);
        this.addItem((Supplier<? extends Item>)TropicraftItems.COOKED_RAY);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FROG_LEG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.COOKED_FROG_LEG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SEA_URCHIN_ROE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.TOASTED_NORI);
        this.addItem((Supplier<? extends Item>)TropicraftItems.RAW_FISH);
        this.addItem((Supplier<? extends Item>)TropicraftItems.COOKED_FISH);
        this.addItem((Supplier<? extends Item>)TropicraftItems.POISON_FROG_SKIN);
        this.addItem((Supplier<? extends Item>)TropicraftItems.IGUANA_LEATHER);
        this.addItem((Supplier<? extends Item>)TropicraftItems.TROPICAL_FERTILIZER);
        this.addItem((Supplier<? extends Item>)TropicraftItems.TROPICAL_FISH_BUCKET);
        this.addItem((Supplier<? extends Item>)TropicraftItems.PIRANHA_BUCKET);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SARDINE_BUCKET);
        this.addItem((Supplier<? extends Item>)TropicraftItems.DAGGER);
        TropicraftItems.ASHEN_MASKS.values().forEach(item -> this.addItem((Supplier)item, ((AshenMaskItem)((Object)((Object)item.get()))).getMaskType().getName()));
        this.addItem((Supplier<? extends Item>)TropicraftItems.BLOW_GUN);
        this.addItem((Supplier)TropicraftItems.NIGEL_STACHE, "Nigel's Moustache");
        this.addItem((Supplier<? extends Item>)TropicraftItems.WATER_WAND);
        this.addItem((Supplier<? extends Item>)TropicraftItems.EXPLODING_COCONUT);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FISHING_NET);
        this.addItem((Supplier<? extends Item>)TropicraftItems.PIANGUAS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCON_AXE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCON_HOE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCON_PICKAXE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCON_SHOVEL);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCON_SWORD);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCONIUM_AXE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCONIUM_HOE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCONIUM_PICKAXE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCONIUM_SHOVEL);
        this.addItem((Supplier<? extends Item>)TropicraftItems.ZIRCONIUM_SWORD);
        this.addItem((Supplier<? extends Item>)TropicraftItems.EUDIALYTE_AXE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.EUDIALYTE_HOE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.EUDIALYTE_PICKAXE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.EUDIALYTE_SHOVEL);
        this.addItem((Supplier<? extends Item>)TropicraftItems.EUDIALYTE_SWORD);
        TropicraftItems.MUSIC_DISCS.values().forEach(item -> this.addItemWithTooltip((Supplier<? extends Item>)item, "Music Disc", ((TropicalMusicDiscItem)((Object)((Object)item.get()))).getType().getTooltip()));
        this.addItem((Supplier)TropicraftItems.KOA_SPAWN_EGG, "Koa Headband");
        this.addItem((Supplier)TropicraftItems.TROPICREEPER_SPAWN_EGG, "TropiCreeper Hat");
        this.addItem((Supplier<? extends Item>)TropicraftItems.IGUANA_SPAWN_EGG);
        this.addItem((Supplier)TropicraftItems.TROPISKELLY_SPAWN_EGG, "TropiSkelly Skirt");
        this.addItem((Supplier)TropicraftItems.EIH_SPAWN_EGG, "Eye of Head");
        this.addItem((Supplier<? extends Item>)TropicraftItems.SEA_TURTLE_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.MARLIN_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FAILGULL_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.DOLPHIN_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SEAHORSE_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.TREE_FROG_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SEA_URCHIN_SPAWN_EGG);
        this.addItem((Supplier)TropicraftItems.V_MONKEY_SPAWN_EGG, "Vervet Monkey Spawn Egg");
        this.addItem((Supplier<? extends Item>)TropicraftItems.PIRANHA_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SARDINE_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.TROPICAL_FISH_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.EAGLE_RAY_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.TROPI_SPIDER_SPAWN_EGG);
        this.addItem((Supplier)TropicraftItems.ASHEN_SPAWN_EGG, "Ashen Ash");
        this.addItem((Supplier<? extends Item>)TropicraftItems.HAMMERHEAD_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.COWKTAIL_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.MAN_O_WAR_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.TROPIBEE_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.TAPIR_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.JAGUAR_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.BROWN_BASILISK_LIZARD_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.GREEN_BASILISK_LIZARD_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.HUMMINGBIRD_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FIDDLER_CRAB_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SPIDER_MONKEY_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.WHITE_LIPPED_PECCARY_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.CUBERA_SPAWN_EGG);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FIRE_BOOTS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FIRE_CHESTPLATE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FIRE_HELMET);
        this.addItem((Supplier<? extends Item>)TropicraftItems.FIRE_LEGGINGS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SCALE_BOOTS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SCALE_CHESTPLATE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SCALE_HELMET);
        this.addItem((Supplier<? extends Item>)TropicraftItems.SCALE_LEGGINGS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.YELLOW_SCUBA_GOGGLES);
        this.addItem((Supplier<? extends Item>)TropicraftItems.YELLOW_SCUBA_HARNESS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.YELLOW_SCUBA_FLIPPERS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.PINK_SCUBA_GOGGLES);
        this.addItem((Supplier<? extends Item>)TropicraftItems.PINK_SCUBA_HARNESS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.PINK_SCUBA_FLIPPERS);
        this.addItem((Supplier<? extends Item>)TropicraftItems.YELLOW_PONY_BOTTLE);
        this.addItem((Supplier<? extends Item>)TropicraftItems.PINK_PONY_BOTTLE);
        this.addEntityType((Supplier)TropicraftEntities.KOA_HUNTER, "Koa");
        this.addEntityType((Supplier)TropicraftEntities.TROPI_CREEPER, "Tropicreeper");
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.IGUANA);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.UMBRELLA);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.CHAIR);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.BEACH_FLOAT);
        this.addEntityType((Supplier)TropicraftEntities.TROPI_SKELLY, "Tropiskelly");
        this.addEntityType((Supplier)TropicraftEntities.EIH, "Easter Island Head");
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.WALL_ITEM);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.BAMBOO_ITEM_FRAME);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.SEA_TURTLE);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.MARLIN);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.FAILGULL);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.DOLPHIN);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.SEAHORSE);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.TREE_FROG);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.SEA_URCHIN);
        this.addEntityType((Supplier)TropicraftEntities.SEA_URCHIN_EGG_ENTITY, "Sea Urchin Egg");
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.STARFISH);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.STARFISH_EGG);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.PIRANHA);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.RIVER_SARDINE);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.TROPICAL_FISH);
        this.addEntityType((Supplier)TropicraftEntities.EAGLE_RAY, "Spotted Eagle Ray");
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.TROPI_SPIDER);
        this.addEntityType((Supplier)TropicraftEntities.TROPI_SPIDER_EGG, "Tropics Spider Egg");
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.ASHEN);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.ASHEN_MASK);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.EXPLODING_COCONUT);
        this.addEntityType((Supplier)TropicraftEntities.SEA_TURTLE_EGG, "Sea Turtle Egg");
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.COWKTAIL);
        this.addEntityType((Supplier)TropicraftEntities.MAN_O_WAR, "Man o' War");
        this.addEntityType((Supplier)TropicraftEntities.TROPI_BEE, "Tropibee");
        this.addEntityType((Supplier)TropicraftEntities.V_MONKEY, "Vervet Monkey");
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.TAPIR);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.JAGUAR);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.BROWN_BASILISK_LIZARD);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.GREEN_BASILISK_LIZARD);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.HUMMINGBIRD);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.FIDDLER_CRAB);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.SPIDER_MONKEY);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.WHITE_LIPPED_PECCARY);
        this.addEntityType((Supplier<? extends EntityType<?>>)TropicraftEntities.CUBERA);
        this.addBiome(TropicraftBiomes.OCEAN);
        this.addBiome(TropicraftBiomes.TROPICS);
        this.addBiome(TropicraftBiomes.KELP_FOREST);
        this.addBiome(TropicraftBiomes.RAINFOREST);
        this.addBiome(TropicraftBiomes.BAMBOO_RAINFOREST);
        this.addBiome(TropicraftBiomes.RIVER);
        this.addBiome(TropicraftBiomes.BEACH);
        this.addBiome(TropicraftBiomes.MANGROVES);
        this.addBiome(TropicraftBiomes.OVERGROWN_MANGROVES);
        this.addBiome(TropicraftBiomes.OSA_RAINFOREST);
        this.add(Tropicraft.TROPICRAFT_ITEM_GROUP, "Tropicraft");
        this.add("attribute.name." + ((Attribute)ForgeMod.SWIM_SPEED.get()).getRegistryName().m_135815_(), "Swim Speed");
        this.add("entity.tropicraft.koa.female.hunter.name", "Koa Hunter");
        this.add("entity.tropicraft.koa.female.fisherman.name", "Koa Fisher");
        this.add("entity.tropicraft.koa.male.hunter.name", "Koa Hunter");
        this.add("entity.tropicraft.koa.male.fisherman.name", "Koa Fisher");
        TropicraftLangKeys.generate(this);
    }

    private String getAutomaticName(Supplier<? extends IForgeRegistryEntry<?>> sup) {
        return Util.toEnglishName(sup.get().getRegistryName().m_135815_());
    }

    private void addBlock(Supplier<? extends Block> block) {
        this.addBlock(block, this.getAutomaticName(block));
    }

    private void addBlockWithTooltip(Supplier<? extends Block> block, String tooltip) {
        this.addBlock(block);
        this.addTooltip(block, tooltip);
    }

    private void addItem(Supplier<? extends Item> item) {
        this.addItem(item, this.getAutomaticName(item));
    }

    private void addItemWithTooltip(Supplier<? extends Item> block, String name, List<String> tooltip) {
        this.addItem(block, name);
        this.addTooltip(block, tooltip);
    }

    private void addTooltip(Supplier<? extends ItemLike> item, String tooltip) {
        this.add(item.get().m_5456_().m_5524_() + ".desc", tooltip);
    }

    private void addTooltip(Supplier<? extends ItemLike> item, List<String> tooltip) {
        for (int i = 0; i < tooltip.size(); ++i) {
            String key = item.get().m_5456_().m_5524_() + ".desc." + i;
            this.add(key, tooltip.get(i));
        }
    }

    private void add(CreativeModeTab group, String name) {
        this.add("itemGroup." + group.m_40783_(), name);
    }

    private void addEntityType(Supplier<? extends EntityType<?>> entity) {
        this.addEntityType(entity, this.getAutomaticName(entity));
    }

    private void addBiome(RegistryObject<Biome> biome) {
        ResourceLocation id = biome.getId();
        this.add("biome." + id.m_135827_() + "." + id.m_135815_(), Util.toEnglishName(id.m_135815_()));
    }

    private String toUpsideDown(String normal) {
        char[] ud = new char[normal.length()];
        for (int i = 0; i < normal.length(); ++i) {
            char c = normal.charAt(i);
            if (c == '%') {
                Object fmtArg = "";
                while (Character.isDigit(c) || c == '%' || c == '$' || c == 's' || c == 'd') {
                    fmtArg = (String)fmtArg + c;
                    c = ++i == normal.length() ? (char)'\u0000' : normal.charAt(i);
                }
                --i;
                for (int j = 0; j < ((String)fmtArg).length(); ++j) {
                    ud[normal.length() - 1 - i + j] = ((String)fmtArg).charAt(j);
                }
                continue;
            }
            int lookup = NORMAL_CHARS.indexOf(c);
            if (lookup >= 0) {
                c = UPSIDE_DOWN_CHARS.charAt(lookup);
            }
            ud[normal.length() - 1 - i] = c;
        }
        return new String(ud);
    }

    public void add(String key, String value) {
        super.add(key, value);
        this.upsideDown.add(key, this.toUpsideDown(value));
    }

    public void m_6865_(HashCache cache) throws IOException {
        super.m_6865_(cache);
        this.upsideDown.m_6865_(cache);
    }

    static {
        if (NORMAL_CHARS.length() != UPSIDE_DOWN_CHARS.length()) {
            throw new AssertionError((Object)"Char maps do not match in length!");
        }
    }

    private static class AccessibleLanguageProvider
    extends LanguageProvider {
        public AccessibleLanguageProvider(DataGenerator gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        public void add(String key, String value) {
            super.add(key, value);
        }

        protected void addTranslations() {
        }
    }
}

