/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.common.entity.passive.monkey.SpiderMonkeyEntity;

public class SpiderMonkeyModel<T extends SpiderMonkeyEntity>
extends EntityModel<T> {
    private final ModelPart body_base;
    private final ModelPart head_base;
    private final ModelPart monke;
    private final ModelPart tail_a;
    private final ModelPart tail_b;
    private final ModelPart arm_left_a;
    private final ModelPart leg_left_a;
    private final ModelPart leg_left_a_r1;
    private final ModelPart leg_right_a;
    private final ModelPart leg_right_a_r1;
    private final ModelPart arm_right_a;

    public SpiderMonkeyModel(ModelPart root) {
        this.body_base = root.m_171324_("body_base");
        this.head_base = this.body_base.m_171324_("head_base");
        this.monke = this.head_base.m_171324_("monke");
        this.tail_a = this.body_base.m_171324_("tail_a");
        this.tail_b = this.tail_a.m_171324_("tail_b");
        this.arm_left_a = this.body_base.m_171324_("arm_left_a");
        this.leg_left_a = this.body_base.m_171324_("leg_left_a");
        this.leg_left_a_r1 = this.leg_left_a.m_171324_("leg_left_a_r1");
        this.arm_right_a = this.body_base.m_171324_("arm_right_a");
        this.leg_right_a = this.body_base.m_171324_("leg_right_a");
        this.leg_right_a_r1 = this.leg_right_a.m_171324_("leg_right_a_r1");
    }

    public static LayerDefinition create() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartBody = modelPartData.m_171599_("body_base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.5f, -9.0f, -2.0f, 5.0f, 10.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)4.0f, (float)80.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartHead = modelPartBody.m_171599_("head_base", CubeListBuilder.m_171558_().m_171514_(17, 0).m_171506_(-2.0f, -4.0f, -3.0f, 4.0f, 4.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)0.0f, (float)-75.0f, (float)0.0f, (float)0.0f));
        modelPartHead.m_171599_("monke", CubeListBuilder.m_171558_().m_171514_(9, 39).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-2.5f));
        PartDefinition modelPartTail = modelPartBody.m_171599_("tail_a", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171506_(-1.0f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)65.0f, (float)0.0f, (float)0.0f));
        modelPartTail.m_171599_("tail_b", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171506_(-0.99f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)7.5f, (float)1.0f, (float)-35.0f, (float)0.0f, (float)0.0f));
        modelPartBody.m_171599_("arm_left_a", CubeListBuilder.m_171558_().m_171514_(9, 14).m_171506_(-1.0f, -1.0f, -1.0f, 2.0f, 11.0f, 2.0f, false), PartPose.m_171423_((float)-2.5f, (float)-7.5f, (float)-0.5f, (float)-82.5f, (float)2.5f, (float)2.5f));
        modelPartBody.m_171599_("arm_right_a", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171506_(-1.0f, -1.0f, -1.0f, 2.0f, 11.0f, 2.0f, false), PartPose.m_171423_((float)2.5f, (float)-7.5f, (float)-0.5f, (float)-82.5f, (float)-2.5f, (float)-2.5f));
        PartDefinition modelPartLegLeft = modelPartBody.m_171599_("leg_left_a", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)1.0f, (float)-1.5f));
        modelPartLegLeft.m_171599_("leg_left_a_r1", CubeListBuilder.m_171558_().m_171514_(18, 28).m_171506_(-0.5f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-75.0f, (float)5.0f, (float)-2.5f));
        PartDefinition modelPartLegRight = modelPartBody.m_171599_("leg_right_a", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)1.0f, (float)-1.5f));
        modelPartLegRight.m_171599_("leg_right_a_r1", CubeListBuilder.m_171558_().m_171514_(9, 28).m_171506_(-1.5f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-75.0f, (float)-5.0f, (float)2.5f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    private void setDefaultRotationAngles() {
        this.setRotationAngle(this.body_base, 80.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.head_base, -75.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.tail_a, 65.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.tail_b, -35.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.arm_left_a, -82.5f, 2.5f, 2.5f);
        this.setRotationAngle(this.leg_left_a_r1, -75.0f, 5.0f, -2.5f);
        this.setRotationAngle(this.leg_right_a_r1, -75.0f, -5.0f, 2.5f);
        this.setRotationAngle(this.arm_right_a, -82.5f, -2.5f, -2.5f);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float age, float headYaw, float headPitch) {
        this.head_base.f_104203_ += headPitch * ((float)Math.PI / 180);
        this.head_base.f_104205_ -= headYaw * ((float)Math.PI / 180);
        try (ModelAnimator.Cycle idle = ModelAnimator.cycle(age * 0.025f, 0.05f);){
            this.tail_a.f_104203_ += idle.eval(1.0f, 1.0f, 0.0f, 0.0f);
            this.tail_b.f_104203_ += idle.eval(1.0f, 1.0f, 0.2f, 0.0f);
        }
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.setDefaultRotationAngles();
        float standAnimation = ((SpiderMonkeyEntity)((Object)entity)).getStandAnimation(partialTicks);
        float standAngle = standAnimation * 70.0f * ((float)Math.PI / 180);
        this.body_base.f_104203_ -= standAngle;
        this.head_base.f_104203_ += standAngle;
        this.arm_right_a.f_104203_ += standAngle;
        this.arm_left_a.f_104203_ += standAngle;
        this.leg_left_a_r1.f_104203_ += standAngle;
        this.leg_right_a_r1.f_104203_ += standAngle;
        try (ModelAnimator.Cycle walk = ModelAnimator.cycle(limbSwing * 0.2f, limbSwingAmount);){
            this.arm_left_a.f_104203_ += walk.eval(1.0f, 1.0f);
            this.arm_right_a.f_104203_ += walk.eval(-1.0f, 1.0f);
            this.leg_left_a_r1.f_104203_ += walk.eval(-1.0f, 1.0f);
            this.leg_right_a_r1.f_104203_ += walk.eval(1.0f, 1.0f);
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body_base.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    private void setRotationAngle(ModelPart part, float x, float y, float z) {
        part.f_104203_ = x * ((float)Math.PI / 180);
        part.f_104204_ = y * ((float)Math.PI / 180);
        part.f_104205_ = z * ((float)Math.PI / 180);
    }
}

