/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.MachineModel;
import net.tropicraft.core.common.block.tileentity.IMachineBlock;

public abstract class MachineRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final Block block;
    protected final MachineModel<T> model;

    public MachineRenderer(BlockEntityRendererProvider.Context context, Block block, MachineModel<T> model) {
        this.block = block;
        this.model = model;
    }

    public void m_6922_(T te, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        stack.m_85836_();
        stack.m_85837_(0.5, 1.5, 0.5);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        if (te == null || te.m_58904_() == null) {
            stack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        } else {
            BlockState state = te.m_58904_().m_8055_(te.m_58899_());
            Direction facing = state.m_60734_() != this.block ? Direction.NORTH : ((IMachineBlock)te).getDirection(state);
            stack.m_85845_(Vector3f.f_122225_.m_122240_(facing.m_122435_() + 90.0f));
        }
        if (te != null && ((IMachineBlock)te).isActive()) {
            this.animationTransform(te, stack, partialTicks);
        }
        TropicraftRenderUtils.renderModel(this.getMaterial(), this.model, stack, buffer, combinedLightIn, combinedOverlayIn);
        if (te != null) {
            this.renderIngredients(te, stack, buffer, combinedLightIn, combinedOverlayIn);
        }
        stack.m_85849_();
    }

    protected abstract Material getMaterial();

    protected void animationTransform(T te, PoseStack stack, float partialTicks) {
        float angle = Mth.m_14031_((float)((float)(157.07963267948966 * (double)((IMachineBlock)te).getProgress(partialTicks)))) * 15.0f;
        stack.m_85845_(Vector3f.f_122225_.m_122240_(angle));
    }

    protected abstract void renderIngredients(T var1, PoseStack var2, MultiBufferSource var3, int var4, int var5);
}

