/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import org.apache.commons.lang3.StringUtils;

public class Util {
    public static boolean tryMoveToEntityLivingLongDist(Mob entSource, Entity entityTo, double moveSpeedAmp) {
        return Util.tryMoveToXYZLongDist(entSource, entityTo.m_142538_(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(Mob ent, BlockPos pos, double moveSpeedAmp) {
        return Util.tryMoveToXYZLongDist(ent, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(Mob ent, int x, int y, int z, double moveSpeedAmp) {
        Level world = ent.f_19853_;
        boolean success = false;
        if (ent.m_21573_().m_26571_()) {
            double followDist;
            double distToPlayer = Util.getDistance((Entity)ent, x, y, z);
            if (distToPlayer <= (followDist = ent.m_21051_(Attributes.f_22277_).m_22135_())) {
                success = ent.m_21573_().m_26519_((double)x, (double)y, (double)z, moveSpeedAmp);
            } else {
                int tries;
                int gatherZ;
                int gatherY;
                double d = (double)((float)x + 0.5f) - ent.m_20185_();
                double d2 = (double)((float)z + 0.5f) - ent.m_20189_();
                double d1 = (double)((float)y + 0.5f) - (ent.m_20186_() + (double)ent.m_20192_());
                double d3 = Mth.m_14116_((float)((float)(d * d + d2 * d2)));
                float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
                float rotationPitch = -f3;
                float rotationYaw = f2;
                Mob center = ent;
                Random rand = world.f_46441_;
                float randLook = rand.nextInt(90) - 45;
                double dist = followDist * 0.75 + (double)rand.nextInt((int)followDist / 2);
                int gatherX = (int)Math.floor(center.m_20185_() + -Math.sin((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                BlockPos pos = new BlockPos(gatherX, gatherY = (int)center.m_20186_(), gatherZ = (int)Math.floor(center.m_20189_() + Math.cos((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist));
                if (!world.m_46805_(pos)) {
                    return false;
                }
                BlockState state = world.m_8055_(pos);
                Block block = state.m_60734_();
                if (!world.m_46859_(pos)) {
                    for (tries = 0; !(tries >= 30 || world.m_46859_(pos) && world.m_46859_(pos.m_7494_())); ++tries) {
                        pos = new BlockPos(gatherX, ++gatherY, gatherZ);
                        state = world.m_8055_(pos);
                        block = state.m_60734_();
                    }
                } else {
                    while (tries < 30 && (world.m_46859_(pos) || !state.m_60767_().m_76333_() && world.m_8055_(pos).m_60767_() != Material.f_76305_)) {
                        pos = new BlockPos(gatherX, --gatherY, gatherZ);
                        state = world.m_8055_(pos);
                        block = state.m_60734_();
                        ++tries;
                    }
                }
                if (tries < 30) {
                    success = ent.m_21573_().m_26519_((double)gatherX, (double)gatherY, (double)gatherZ, moveSpeedAmp);
                }
            }
        }
        return success;
    }

    public static BlockPos findBlock(Mob entity, int scanRange, BiPredicate<Level, BlockPos> predicate) {
        int scanSize = scanRange;
        int scanSizeY = scanRange / 2;
        int adjustRangeY = 10;
        int tryY = Mth.m_14107_((double)entity.m_20186_()) - 1;
        for (int ii = 0; ii <= 10; ++ii) {
            if (ii <= 3) {
                scanSize = 20;
                scanSizeY = 5;
            } else {
                scanSize = scanRange;
                scanSizeY = scanRange / 2;
            }
            int tryX = Mth.m_14107_((double)entity.m_20185_()) + (entity.f_19853_.f_46441_.nextInt(scanSize) - scanSize / 2);
            int i = tryY + entity.f_19853_.f_46441_.nextInt(scanSizeY) - scanSizeY / 2;
            int tryZ = Mth.m_14107_((double)entity.m_20189_()) + entity.f_19853_.f_46441_.nextInt(scanSize) - scanSize / 2;
            BlockPos posTry = new BlockPos(tryX, tryY, tryZ);
            boolean foundBlock = false;
            int newY = i;
            if (!entity.f_19853_.m_46859_(posTry)) {
                tryMax = adjustRangeY;
                while (!entity.f_19853_.m_46859_(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, ++newY, tryZ);
                }
                if (entity.f_19853_.m_46859_(posTry) && predicate.test(entity.f_19853_, posTry.m_142082_(0, -1, 0))) {
                    foundBlock = true;
                }
            } else {
                tryMax = adjustRangeY;
                while (entity.f_19853_.m_46859_(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, --newY, tryZ);
                }
                if (entity.f_19853_.m_46859_(posTry.m_142082_(0, 1, 0)) && predicate.test(entity.f_19853_, posTry)) {
                    foundBlock = true;
                }
            }
            if (!foundBlock) continue;
            return posTry;
        }
        return null;
    }

    public static boolean isWater(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60767_() == Material.f_76305_;
    }

    public static boolean isDeepWater(Level world, BlockPos pos) {
        boolean clearAbove = world.m_46859_(pos.m_6630_(1)) && world.m_46859_(pos.m_6630_(2)) && world.m_46859_(pos.m_6630_(3));
        boolean deep = world.m_8055_(pos).m_60767_() == Material.f_76305_ && world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76305_;
        boolean notUnderground = false;
        if (deep) {
            int height = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() - 1;
            notUnderground = height == pos.m_123342_();
        }
        return deep && notUnderground && clearAbove;
    }

    public static boolean isLand(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60767_().m_76333_();
    }

    public static boolean isFire(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60767_() == Material.f_76309_;
    }

    public static double getDistance(Entity ent, double x, double y, double z) {
        double d0 = ent.m_20185_() - x;
        double d1 = ent.m_20186_() - y;
        double d2 = ent.m_20189_() - z;
        return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
    }

    public static Field findField(Class<?> clazz, String ... fieldNames) {
        Exception failed = null;
        for (String fieldName : fieldNames) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (Exception e) {
                failed = e;
            }
        }
        throw new UnableToFindFieldException(failed);
    }

    public static int randFlip(Random rand, int i) {
        return rand.nextBoolean() ? rand.nextInt(i) : -rand.nextInt(i);
    }

    public static final String toEnglishName(String internalName) {
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static Direction.Axis getAxisBetween(BlockPos start, BlockPos end) {
        int zOffset;
        Direction.Axis axis = Direction.Axis.Y;
        int xOffset = Math.abs(end.m_123341_() - start.m_123341_());
        int maxOffset = Math.max(xOffset, zOffset = Math.abs(end.m_123343_() - start.m_123343_()));
        if (maxOffset > 0) {
            axis = xOffset == maxOffset ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }

    @Nullable
    public static BlockPos findLowestBlock(List<BlockPos> blocks) {
        if (blocks.isEmpty()) {
            return null;
        }
        BlockPos lowest = blocks.get(0);
        for (int i = 1; i < blocks.size(); ++i) {
            BlockPos block = blocks.get(i);
            if (lowest.m_123342_() <= block.m_123342_()) continue;
            lowest = block;
        }
        return lowest;
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        private UnableToFindFieldException(Exception e) {
            super(e);
        }
    }
}

