/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import net.tropicraft.core.common.block.tileentity.TropicraftBlockEntityTypes;

public class AirCompressorBlock
extends BaseEntityBlock {
    @Nonnull
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.f_54117_;

    public AirCompressorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return AirCompressorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TropicraftBlockEntityTypes.AIR_COMPRESSOR.get()), AirCompressorBlockEntity::compressTick);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent(this.m_7705_() + ".desc").m_130940_(ChatFormatting.GRAY));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21205_();
        AirCompressorBlockEntity mixer = (AirCompressorBlockEntity)world.m_7702_(pos);
        if (mixer.isDoneCompressing()) {
            mixer.ejectTank();
            return InteractionResult.CONSUME;
        }
        if (stack.m_41619_()) {
            mixer.ejectTank();
            return InteractionResult.CONSUME;
        }
        ItemStack ingredientStack = stack.m_41777_();
        ingredientStack.m_41764_(1);
        if (mixer.addTank(ingredientStack)) {
            player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.f_46443_) {
            AirCompressorBlockEntity te = (AirCompressorBlockEntity)world.m_7702_(pos);
            te.ejectTank();
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p, BlockState s) {
        return new AirCompressorBlockEntity(p, s);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState ret = super.m_5573_(context);
        return (BlockState)ret.m_61124_(FACING, (Comparable)context.m_8125_());
    }
}

