/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.tropicraft.core.common.block.tileentity.BambooChestBlockEntity;

public class BambooChestBlock
extends ChestBlock {
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<Container>> CHEST_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<Container>>(){

        public Optional<Container> acceptDouble(ChestBlockEntity p_225539_1_, ChestBlockEntity p_225539_2_) {
            return Optional.of(new CompoundContainer((Container)p_225539_1_, (Container)p_225539_2_));
        }

        public Optional<Container> acceptSingle(ChestBlockEntity p_225538_1_) {
            return Optional.of(p_225538_1_);
        }

        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    public static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity left, final ChestBlockEntity right) {
            CompoundContainer inventory = new CompoundContainer((Container)left, (Container)right);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$inventory;
                {
                    this.val$inventory = container;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                    if (left.m_7525_(player) && right.m_7525_(player)) {
                        left.m_59640_(playerInventory.f_35978_);
                        right.m_59640_(playerInventory.f_35978_);
                        return ChestMenu.m_39246_((int)id, (Inventory)playerInventory, (Container)this.val$inventory);
                    }
                    return null;
                }

                public Component m_5446_() {
                    if (left.m_8077_()) {
                        return left.m_5446_();
                    }
                    return right.m_8077_() ? right.m_5446_() : new TranslatableComponent("tropicraft.container.bambooChestDouble");
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ChestBlockEntity chest) {
            return Optional.of(chest);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    protected BambooChestBlock(BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends ChestBlockEntity>> tileEntityTypeIn) {
        super(props, tileEntityTypeIn);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BambooChestBlockEntity(pos, state);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        return ((Optional)this.m_5641_(state, worldIn, pos, false).m_5649_(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    @Deprecated
    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        BambooChestBlockEntity tileEntity = (BambooChestBlockEntity)world.m_7702_(pos);
        if (tileEntity != null && tileEntity.isUnbreakable()) {
            return 0.0f;
        }
        return super.m_5880_(state, player, world, pos);
    }
}

