/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.BongoDrumBlock;
import net.tropicraft.core.common.block.MangroveLeavesBlock;
import net.tropicraft.core.common.block.MangroveRootsBlock;
import net.tropicraft.core.common.block.MudBlock;
import net.tropicraft.core.common.block.PropaguleBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicraftLeavesBlock;
import net.tropicraft.core.common.block.TropicraftLogBlock;
import net.tropicraft.core.common.block.TropicsFlowerBlock;
import net.tropicraft.core.common.block.VolcanicSandBlock;
import net.tropicraft.core.common.block.WaterloggableSaplingBlock;

public class Builder {
    public static Supplier<Block> block(BlockBehaviour.Properties properties) {
        return Builder.block(() -> properties);
    }

    public static Supplier<Block> block(Supplier<BlockBehaviour.Properties> properties) {
        return Builder.block(Block::new, properties);
    }

    public static <T extends Block> Supplier<T> block(Function<BlockBehaviour.Properties, T> ctor, BlockBehaviour.Properties properties) {
        return Builder.block(ctor, () -> properties);
    }

    public static <T extends Block> Supplier<T> block(Function<BlockBehaviour.Properties, T> ctor, Supplier<BlockBehaviour.Properties> properties) {
        return () -> (Block)ctor.apply((BlockBehaviour.Properties)properties.get());
    }

    public static Supplier<Block> ore(MaterialColor color) {
        return Builder.block(Builder.prop(Material.f_76278_, color).m_60913_(3.0f, 3.0f));
    }

    public static Supplier<Block> oreBlock(MaterialColor color) {
        return Builder.block(Builder.prop(Material.f_76279_, color).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 6.0f));
    }

    public static Supplier<TropicsFlowerBlock> flower(TropicraftFlower type) {
        return Builder.block((BlockBehaviour.Properties p) -> new TropicsFlowerBlock(type.getEffect(), type.getEffectDuration(), type.getShape(), (BlockBehaviour.Properties)p), Builder.lazyProp((Supplier<? extends Block>)Blocks.f_50112_.delegate));
    }

    public static Supplier<BlockTropicraftSand> sand(MaterialColor color) {
        return Builder.sand(color, 0.5f, 0.5f);
    }

    public static Supplier<BlockTropicraftSand> sand(MaterialColor color, float hardness, float resistance) {
        return Builder.sand(BlockTropicraftSand::new, color, hardness, resistance);
    }

    public static Supplier<VolcanicSandBlock> volcanicSand(MaterialColor color) {
        return Builder.sand(VolcanicSandBlock::new, color, 0.5f, 0.5f);
    }

    public static <T extends BlockTropicraftSand> Supplier<T> sand(Function<BlockBehaviour.Properties, T> ctor, MaterialColor color, float hardness, float resistance) {
        return Builder.block(ctor, Builder.prop(Material.f_76317_, color).m_60918_(SoundType.f_56746_).m_60913_(hardness, resistance));
    }

    public static Supplier<MudBlock> mud() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_).m_60956_(0.5f).m_60922_((s, w, p, e) -> true).m_60924_((s, w, p) -> true).m_60971_((s, w, p) -> true).m_60960_((s, w, p) -> true);
        return Builder.block(MudBlock::new, properties);
    }

    public static Supplier<RotatedPillarBlock> bundle(BlockBehaviour.Properties properties) {
        return Builder.block(RotatedPillarBlock::new, properties);
    }

    public static Supplier<Block> plank(MaterialColor color) {
        return Builder.block(Builder.prop(Material.f_76320_, color).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
    }

    public static Supplier<RotatedPillarBlock> log(MaterialColor topColor, MaterialColor sideColor) {
        return Builder.block(RotatedPillarBlock::new, Builder.logProperties(topColor, sideColor));
    }

    public static Supplier<RotatedPillarBlock> log(MaterialColor topColor, MaterialColor sideColor, Supplier<RegistryObject<RotatedPillarBlock>> stripped) {
        return Builder.block((BlockBehaviour.Properties properties) -> new TropicraftLogBlock((BlockBehaviour.Properties)properties, () -> Builder.lambda$log$8((Supplier)stripped)), Builder.logProperties(topColor, sideColor));
    }

    private static BlockBehaviour.Properties logProperties(MaterialColor topColor, MaterialColor sideColor) {
        return Builder.prop(Material.f_76320_, (BlockState state) -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : sideColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_);
    }

    public static Supplier<RotatedPillarBlock> wood(MaterialColor color) {
        return Builder.block(RotatedPillarBlock::new, Builder.woodProperties(color));
    }

    public static Supplier<RotatedPillarBlock> wood(MaterialColor color, Supplier<RegistryObject<RotatedPillarBlock>> stripped) {
        return Builder.block((BlockBehaviour.Properties properties) -> new TropicraftLogBlock((BlockBehaviour.Properties)properties, () -> Builder.lambda$wood$11((Supplier)stripped)), Builder.woodProperties(color));
    }

    private static BlockBehaviour.Properties woodProperties(MaterialColor color) {
        return Builder.prop(Material.f_76320_, color).m_60978_(2.0f).m_60918_(SoundType.f_56736_);
    }

    public static Supplier<StairBlock> stairs(RegistryObject<? extends Block> source) {
        return Builder.block((BlockBehaviour.Properties p) -> new StairBlock(source.lazyMap(Block::m_49966_), p), Builder.lazyProp(source));
    }

    public static Supplier<SlabBlock> slab(Supplier<? extends Block> source) {
        return Builder.block(SlabBlock::new, Builder.lazyProp(source));
    }

    public static Supplier<LeavesBlock> leaves(boolean decay) {
        return Builder.block(decay ? LeavesBlock::new : TropicraftLeavesBlock::new, Builder.lazyProp((Supplier<? extends Block>)Blocks.f_50050_.delegate));
    }

    public static Supplier<LeavesBlock> mangroveLeaves(Supplier<RegistryObject<PropaguleBlock>> propagule) {
        return Builder.block((BlockBehaviour.Properties properties) -> new MangroveLeavesBlock(properties.m_60977_(), () -> Builder.lambda$mangroveLeaves$14((Supplier)propagule)), Builder.lazyProp((Supplier<? extends Block>)Blocks.f_50050_.delegate));
    }

    public static Supplier<Block> mangroveRoots() {
        return () -> new MangroveRootsBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60924_((state, world, pos) -> false).m_60982_((state, world, pos) -> true));
    }

    @SafeVarargs
    public static Supplier<SaplingBlock> sapling(AbstractTreeGrower tree, final Supplier<? extends Block> ... validPlantBlocks) {
        return Builder.block((BlockBehaviour.Properties p) -> new SaplingBlock(tree, (BlockBehaviour.Properties)p){

            protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
                Block block = state.m_60734_();
                if (validPlantBlocks == null || validPlantBlocks.length == 0) {
                    return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_50599_ || block == Blocks.f_50093_;
                }
                return Arrays.stream(validPlantBlocks).map(Supplier::get).anyMatch(b -> b == block);
            }
        }, Builder.lazyProp((Supplier<? extends Block>)Blocks.f_50746_.delegate));
    }

    public static Supplier<SaplingBlock> waterloggableSapling(AbstractTreeGrower tree) {
        return Builder.block((BlockBehaviour.Properties p) -> new WaterloggableSaplingBlock(tree, (BlockBehaviour.Properties)p), Builder.lazyProp((Supplier<? extends Block>)Blocks.f_50746_.delegate));
    }

    public static Supplier<PropaguleBlock> propagule(AbstractTreeGrower tree) {
        return Builder.block((BlockBehaviour.Properties p) -> new PropaguleBlock(tree, (BlockBehaviour.Properties)p), Builder.lazyProp((Supplier<? extends Block>)Blocks.f_50746_.delegate));
    }

    public static Supplier<FenceBlock> fence(Supplier<? extends Block> source) {
        return Builder.block(FenceBlock::new, Builder.lazyProp(source));
    }

    public static Supplier<FenceGateBlock> fenceGate(Supplier<? extends Block> source) {
        return Builder.block(FenceGateBlock::new, Builder.lazyProp(source));
    }

    public static Supplier<WallBlock> wall(Supplier<? extends Block> source) {
        return Builder.block(WallBlock::new, Builder.lazyProp(source));
    }

    public static Supplier<BongoDrumBlock> bongo(BongoDrumBlock.Size bongoSize) {
        return Builder.block((BlockBehaviour.Properties p) -> new BongoDrumBlock(bongoSize, (BlockBehaviour.Properties)p), Builder.woodProperties(MaterialColor.f_76372_));
    }

    public static Supplier<FlowerPotBlock> pot(Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> flower, Supplier<BlockBehaviour.Properties> properties) {
        return Builder.block((BlockBehaviour.Properties p) -> new FlowerPotBlock(emptyPot, flower, p), properties);
    }

    public static Supplier<FlowerPotBlock> tropicraftPot() {
        return Builder.pot(null, (Supplier<? extends Block>)Blocks.f_50016_.delegate, Builder.lazyProp(Material.f_76310_).then(p -> p.m_60913_(0.2f, 5.0f).m_60918_(SoundType.f_56754_)));
    }

    public static Supplier<FlowerPotBlock> tropicraftPot(Supplier<? extends Block> block) {
        return Builder.pot(TropicraftBlocks.BAMBOO_FLOWER_POT, block, Builder.lazyProp(Material.f_76310_).then(p -> p.m_60913_(0.2f, 5.0f).m_60918_(SoundType.f_56754_)));
    }

    public static Supplier<FlowerPotBlock> vanillaPot(Supplier<? extends Block> block) {
        return Builder.pot(() -> (FlowerPotBlock)Blocks.f_50276_.delegate.get(), block, Builder.lazyProp((Supplier<? extends Block>)Blocks.f_50276_.delegate));
    }

    private static BlockBehaviour.Properties prop(Material material) {
        return BlockBehaviour.Properties.m_60939_((Material)material);
    }

    private static BlockBehaviour.Properties prop(Material material, MaterialColor color) {
        return BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color);
    }

    private static BlockBehaviour.Properties prop(Material material, Function<BlockState, MaterialColor> color) {
        return BlockBehaviour.Properties.m_60947_((Material)material, color);
    }

    private static ComposableSupplier<BlockBehaviour.Properties> lazyProp(Material material) {
        return () -> Builder.prop(material);
    }

    private static ComposableSupplier<BlockBehaviour.Properties> lazyProp(Material material, MaterialColor color) {
        return () -> Builder.prop(material, color);
    }

    private static ComposableSupplier<BlockBehaviour.Properties> lazyProp(Supplier<? extends Block> source) {
        return () -> {
            Objects.requireNonNull((Block)source.get(), "Must register source block before using it");
            return BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)source.get()));
        };
    }

    private static /* synthetic */ PropaguleBlock lambda$mangroveLeaves$14(Supplier propagule) {
        return (PropaguleBlock)((Object)((RegistryObject)propagule.get()).get());
    }

    private static /* synthetic */ RotatedPillarBlock lambda$wood$11(Supplier stripped) {
        return (RotatedPillarBlock)((RegistryObject)stripped.get()).get();
    }

    private static /* synthetic */ RotatedPillarBlock lambda$log$8(Supplier stripped) {
        return (RotatedPillarBlock)((RegistryObject)stripped.get()).get();
    }

    static interface ComposableSupplier<T>
    extends Supplier<T> {
        default public <R> ComposableSupplier<R> then(Function<T, R> func) {
            return () -> func.apply(this.get());
        }
    }
}

