/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class PapayaBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)7.0, (double)3.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)1.0, (double)3.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)4.0, (double)3.0, (double)1.0, (double)12.0, (double)12.0, (double)9.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)4.0, (double)3.0, (double)7.0, (double)12.0, (double)12.0, (double)15.0);

    public PapayaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 2;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 1 && worldIn.f_46441_.nextInt(5) == 0) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Block block = level.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))).m_60734_();
        return block == TropicraftBlocks.PAPAYA_LOG.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            default -> NORTH_AABB;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockstate = (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction)).m_60710_((LevelReader)level, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == stateIn.m_61143_((Property)BlockStateProperties.f_61374_) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7370_(BlockGetter pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Integer)pState.m_61143_((Property)AGE) < 1;
    }

    public boolean m_5491_(Level pLevel, Random pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, AGE});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

