/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TikiTorchBlock
extends Block {
    public static final EnumProperty<TorchSection> SECTION = EnumProperty.m_61587_((String)"section", TorchSection.class);
    protected static final VoxelShape BASE_SHAPE = Shapes.m_83064_((AABB)new AABB(0.4, 0.0, 0.4, 0.6, 0.999999, 0.6));
    protected static final VoxelShape TOP_SHAPE = Shapes.m_83064_((AABB)new AABB(0.4, 0.0, 0.4, 0.6, 0.6, 0.6));

    public TikiTorchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SECTION, (Comparable)((Object)TorchSection.UPPER)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SECTION});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        TorchSection section = (TorchSection)((Object)state.m_61143_(SECTION));
        if (section == TorchSection.UPPER) {
            return TOP_SHAPE;
        }
        return BASE_SHAPE;
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (TikiTorchBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7495_(), (Direction)Direction.UP)) {
            return true;
        }
        BlockState blockstate = world.m_8055_(pos.m_7495_());
        return blockstate.m_60734_() == this && blockstate.m_61143_(SECTION) != TorchSection.UPPER && super.m_7898_(state, world, pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (this.placeShortTorchOn(context.m_43725_().m_8055_(blockpos.m_7495_()))) {
            return (BlockState)this.m_49966_().m_61124_(SECTION, (Comparable)((Object)TorchSection.UPPER));
        }
        BlockState ret = (BlockState)this.m_49966_().m_61124_(SECTION, (Comparable)((Object)TorchSection.LOWER));
        return blockpos.m_123342_() < context.m_43725_().m_151558_() - 1 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context) && context.m_43725_().m_8055_(blockpos.m_6630_(2)).m_60629_(context) ? ret : null;
    }

    @Deprecated
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122434_() == Direction.Axis.Y && !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TorchSection section = (TorchSection)((Object)state.m_61143_(SECTION));
        if (section == TorchSection.UPPER) {
            return;
        }
        worldIn.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_(SECTION, (Comparable)((Object)TorchSection.MIDDLE)), 3);
        worldIn.m_7731_(pos.m_6630_(2), (BlockState)this.m_49966_().m_61124_(SECTION, (Comparable)((Object)TorchSection.UPPER)), 3);
    }

    private boolean placeShortTorchOn(BlockState state) {
        return state.m_204336_(BlockTags.f_13039_) || state.m_204336_(BlockTags.f_13032_);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        TorchSection section = (TorchSection)((Object)state.m_61143_(SECTION));
        BlockPos base = pos.m_6625_(section.height);
        for (TorchSection otherSection : TorchSection.values()) {
            BlockPos pos2 = base.m_6630_(otherSection.height);
            BlockState state2 = world.m_8055_(pos2);
            if (state2.m_60734_() != this || state2.m_61143_(SECTION) != otherSection) continue;
            super.m_6240_(world, player, pos2, state2, te, stack);
            world.m_7731_(pos2, world.m_6425_(pos2).m_76188_(), world.f_46443_ ? 11 : 3);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean ret = false;
        TorchSection section = (TorchSection)((Object)state.m_61143_(SECTION));
        BlockPos base = pos.m_6625_(section.height);
        for (TorchSection otherSection : TorchSection.values()) {
            BlockPos pos2 = base.m_6630_(otherSection.height);
            BlockState state2 = world.m_8055_(pos2);
            if (state2.m_60734_() != this || state2.m_61143_(SECTION) != otherSection) continue;
            if (player.m_7500_()) {
                ret |= super.onDestroyedByPlayer(state2, world, pos2, player, willHarvest, fluid);
                continue;
            }
            this.m_5707_(world, pos2, state2, player);
            ret = true;
        }
        return ret;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        boolean isTop;
        boolean bl = isTop = state.m_61143_(SECTION) == TorchSection.UPPER;
        if (isTop) {
            double d = (float)pos.m_123341_() + 0.5f;
            double d1 = (float)pos.m_123342_() + 0.7f;
            double d2 = (float)pos.m_123343_() + 0.5f;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, d1, d2, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static enum TorchSection implements StringRepresentable
    {
        UPPER(2),
        MIDDLE(1),
        LOWER(0);

        final int height;

        private TorchSection(int height) {
            this.height = height;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

