/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftItemRenderers;
import net.tropicraft.core.common.Foods;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.BambooChestBlock;
import net.tropicraft.core.common.block.BoardwalkBlock;
import net.tropicraft.core.common.block.BongoDrumBlock;
import net.tropicraft.core.common.block.Builder;
import net.tropicraft.core.common.block.CoconutBlock;
import net.tropicraft.core.common.block.CoffeeBushBlock;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.GrowableDoublePlantBlock;
import net.tropicraft.core.common.block.GrowableSinglePlantBlock;
import net.tropicraft.core.common.block.PapayaBlock;
import net.tropicraft.core.common.block.PineappleBlock;
import net.tropicraft.core.common.block.PortalWaterBlock;
import net.tropicraft.core.common.block.PropaguleBlock;
import net.tropicraft.core.common.block.ReedsBlock;
import net.tropicraft.core.common.block.SifterBlock;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicraftTrees;
import net.tropicraft.core.common.block.VolcanoBlock;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;
import net.tropicraft.core.common.block.jigarbov.JigarbovTorchType;
import net.tropicraft.core.common.block.tileentity.TropicraftBlockEntityTypes;

public class TropicraftBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tropicraft");
    public static final DeferredRegister<Item> BLOCKITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tropicraft");
    public static final RegistryObject<PortalWaterBlock> TELEPORT_WATER = TropicraftBlocks.registerNoItem("teleport_water", () -> new PortalWaterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60993_()));
    public static final RegistryObject<LiquidBlock> PORTAL_WATER = TropicraftBlocks.registerNoItem("portal_water", () -> new LiquidBlock(() -> Fluids.f_76193_, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60993_()));
    public static final RegistryObject<Block> CHUNK = TropicraftBlocks.register("chunk", Builder.block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(6.0f, 30.0f)));
    public static final RegistryObject<Block> AZURITE_ORE = TropicraftBlocks.register("azurite_ore", Builder.ore(MaterialColor.f_76419_));
    public static final RegistryObject<Block> EUDIALYTE_ORE = TropicraftBlocks.register("eudialyte_ore", Builder.ore(MaterialColor.f_76419_));
    public static final RegistryObject<Block> MANGANESE_ORE = TropicraftBlocks.register("manganese_ore", Builder.ore(MaterialColor.f_76365_));
    public static final RegistryObject<Block> SHAKA_ORE = TropicraftBlocks.register("shaka_ore", Builder.ore(MaterialColor.f_76365_));
    public static final RegistryObject<Block> ZIRCON_ORE = TropicraftBlocks.register("zircon_ore", Builder.ore(MaterialColor.f_76419_));
    public static final RegistryObject<Block> AZURITE_BLOCK = TropicraftBlocks.register("azurite_block", Builder.oreBlock(MaterialColor.f_76415_));
    public static final RegistryObject<Block> EUDIALYTE_BLOCK = TropicraftBlocks.register("eudialyte_block", Builder.oreBlock(MaterialColor.f_76418_));
    public static final RegistryObject<Block> MANGANESE_BLOCK = TropicraftBlocks.register("manganese_block", Builder.oreBlock(MaterialColor.f_76422_));
    public static final RegistryObject<Block> SHAKA_BLOCK = TropicraftBlocks.register("shaka_block", Builder.oreBlock(MaterialColor.f_76361_));
    public static final RegistryObject<Block> ZIRCON_BLOCK = TropicraftBlocks.register("zircon_block", Builder.oreBlock(MaterialColor.f_76364_));
    public static final RegistryObject<Block> ZIRCONIUM_BLOCK = TropicraftBlocks.register("zirconium_block", Builder.oreBlock(MaterialColor.f_76418_));
    public static final Map<TropicraftFlower, RegistryObject<FlowerBlock>> FLOWERS = Arrays.stream(TropicraftFlower.values()).collect(Collectors.toMap(Function.identity(), f -> TropicraftBlocks.register(f.getId(), Builder.flower(f)), (f1, f2) -> {
        throw new IllegalStateException();
    }, () -> new EnumMap(TropicraftFlower.class)));
    public static final RegistryObject<Block> PURIFIED_SAND = TropicraftBlocks.register("purified_sand", Builder.sand(MaterialColor.f_76400_));
    public static final RegistryObject<Block> PACKED_PURIFIED_SAND = TropicraftBlocks.register("packed_purified_sand", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76400_).m_60999_().m_60978_(0.8f)));
    public static final RegistryObject<Block> CORAL_SAND = TropicraftBlocks.register("coral_sand", Builder.sand(MaterialColor.f_76418_));
    public static final RegistryObject<Block> FOAMY_SAND = TropicraftBlocks.register("foamy_sand", Builder.sand(MaterialColor.f_76363_));
    public static final RegistryObject<Block> VOLCANIC_SAND = TropicraftBlocks.register("volcanic_sand", Builder.volcanicSand(MaterialColor.f_76420_));
    public static final RegistryObject<Block> MINERAL_SAND = TropicraftBlocks.register("mineral_sand", Builder.sand(MaterialColor.f_76400_));
    public static final RegistryObject<Block> MUD = TropicraftBlocks.register("mud", Builder.mud());
    public static final RegistryObject<Block> MUD_WITH_PIANGUAS = TropicraftBlocks.register("mud_with_pianguas", Builder.mud());
    public static final RegistryObject<RotatedPillarBlock> BAMBOO_BUNDLE = TropicraftBlocks.register("bamboo_bundle", Builder.bundle(BlockBehaviour.Properties.m_60944_((Material)Material.f_76271_, (MaterialColor)MaterialColor.f_76405_).m_60918_(SoundType.f_56754_).m_60913_(0.2f, 5.0f)));
    public static final RegistryObject<RotatedPillarBlock> THATCH_BUNDLE = TropicraftBlocks.register("thatch_bundle", Builder.bundle(BlockBehaviour.Properties.m_60944_((Material)Material.f_76315_, (MaterialColor)MaterialColor.f_76411_).m_60918_(SoundType.f_56740_).m_60913_(0.2f, 5.0f)));
    public static final RegistryObject<Block> MAHOGANY_PLANKS = TropicraftBlocks.register("mahogany_planks", Builder.plank(MaterialColor.f_76362_));
    public static final RegistryObject<Block> PALM_PLANKS = TropicraftBlocks.register("palm_planks", Builder.plank(MaterialColor.f_76411_));
    public static final RegistryObject<RotatedPillarBlock> MAHOGANY_LOG = TropicraftBlocks.register("mahogany_log", Builder.log(MaterialColor.f_76411_, MaterialColor.f_76362_));
    public static final RegistryObject<RotatedPillarBlock> PALM_LOG = TropicraftBlocks.register("palm_log", Builder.log(MaterialColor.f_76419_, MaterialColor.f_76362_));
    public static final RegistryObject<RotatedPillarBlock> MAHOGANY_WOOD = TropicraftBlocks.register("mohogany_wood", Builder.wood(MaterialColor.f_76411_));
    public static final RegistryObject<RotatedPillarBlock> PALM_WOOD = TropicraftBlocks.register("palm_wood", Builder.wood(MaterialColor.f_76419_));
    public static final RegistryObject<StairBlock> PALM_STAIRS = TropicraftBlocks.register("palm_stairs", Builder.stairs(PALM_PLANKS));
    public static final RegistryObject<StairBlock> MAHOGANY_STAIRS = TropicraftBlocks.register("mahogany_stairs", Builder.stairs(MAHOGANY_PLANKS));
    public static final RegistryObject<StairBlock> THATCH_STAIRS = TropicraftBlocks.register("thatch_stairs", Builder.stairs(THATCH_BUNDLE));
    public static final RegistryObject<StairBlock> THATCH_STAIRS_FUZZY = TropicraftBlocks.register("thatch_stairs_fuzzy", Builder.stairs(THATCH_BUNDLE));
    public static final RegistryObject<StairBlock> BAMBOO_STAIRS = TropicraftBlocks.register("bamboo_stairs", Builder.stairs(BAMBOO_BUNDLE));
    public static final RegistryObject<StairBlock> CHUNK_STAIRS = TropicraftBlocks.register("chunk_stairs", Builder.stairs(CHUNK));
    public static final RegistryObject<Block> COCONUT = TropicraftBlocks.register("coconut", () -> new CoconutBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76285_).m_60978_(2.0f).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<SlabBlock> BAMBOO_SLAB = TropicraftBlocks.register("bamboo_slab", Builder.slab(BAMBOO_BUNDLE));
    public static final RegistryObject<SlabBlock> THATCH_SLAB = TropicraftBlocks.register("thatch_slab", Builder.slab(THATCH_BUNDLE));
    public static final RegistryObject<SlabBlock> CHUNK_SLAB = TropicraftBlocks.register("chunk_slab", Builder.slab(CHUNK));
    public static final RegistryObject<SlabBlock> PALM_SLAB = TropicraftBlocks.register("palm_slab", Builder.slab(PALM_PLANKS));
    public static final RegistryObject<SlabBlock> MAHOGANY_SLAB = TropicraftBlocks.register("mahogany_slab", Builder.slab(MAHOGANY_PLANKS));
    public static final RegistryObject<LeavesBlock> MAHOGANY_LEAVES = TropicraftBlocks.register("mahogany_leaves", Builder.leaves(false));
    public static final RegistryObject<LeavesBlock> PALM_LEAVES = TropicraftBlocks.register("palm_leaves", Builder.leaves(false));
    public static final RegistryObject<LeavesBlock> KAPOK_LEAVES = TropicraftBlocks.register("kapok_leaves", Builder.leaves(false));
    public static final RegistryObject<LeavesBlock> FRUIT_LEAVES = TropicraftBlocks.register("fruit_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> GRAPEFRUIT_LEAVES = TropicraftBlocks.register("grapefruit_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> LEMON_LEAVES = TropicraftBlocks.register("lemon_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> LIME_LEAVES = TropicraftBlocks.register("lime_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> ORANGE_LEAVES = TropicraftBlocks.register("orange_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> PAPAYA_LEAVES = TropicraftBlocks.register("papaya_leaves", Builder.leaves(false));
    public static final RegistryObject<SaplingBlock> GRAPEFRUIT_SAPLING = TropicraftBlocks.register("grapefruit_sapling", Builder.sapling(TropicraftTrees.GRAPEFRUIT, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> LEMON_SAPLING = TropicraftBlocks.register("lemon_sapling", Builder.sapling(TropicraftTrees.LEMON, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> LIME_SAPLING = TropicraftBlocks.register("lime_sapling", Builder.sapling(TropicraftTrees.LIME, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> ORANGE_SAPLING = TropicraftBlocks.register("orange_sapling", Builder.sapling(TropicraftTrees.ORANGE, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> PAPAYA_SAPLING = TropicraftBlocks.register("papaya_sapling", Builder.sapling(TropicraftTrees.PAPAYA, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> MAHOGANY_SAPLING = TropicraftBlocks.register("mahogany_sapling", Builder.sapling(TropicraftTrees.RAINFOREST, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> PALM_SAPLING = TropicraftBlocks.register("palm_sapling", Builder.sapling(TropicraftTrees.PALM, new Supplier[]{() -> Blocks.f_49992_, CORAL_SAND, FOAMY_SAND, VOLCANIC_SAND, PURIFIED_SAND, MINERAL_SAND}));
    public static final RegistryObject<RotatedPillarBlock> PAPAYA_LOG = TropicraftBlocks.register("papaya_log", Builder.log(MaterialColor.f_76419_, MaterialColor.f_76362_));
    public static final RegistryObject<RotatedPillarBlock> PAPAYA_WOOD = TropicraftBlocks.register("papaya_wood", Builder.wood(MaterialColor.f_76419_));
    public static final RegistryObject<RotatedPillarBlock> RED_MANGROVE_LOG = TropicraftBlocks.register("red_mangrove_log", Builder.log(MaterialColor.f_76419_, MaterialColor.f_76362_, () -> STRIPPED_MANGROVE_LOG));
    public static final RegistryObject<RotatedPillarBlock> RED_MANGROVE_WOOD = TropicraftBlocks.register("red_mangrove_wood", Builder.wood(MaterialColor.f_76419_, () -> STRIPPED_MANGROVE_WOOD));
    public static final RegistryObject<Block> RED_MANGROVE_ROOTS = TropicraftBlocks.register("red_mangrove_roots", Builder.mangroveRoots());
    public static final RegistryObject<RotatedPillarBlock> LIGHT_MANGROVE_LOG = TropicraftBlocks.register("light_mangrove_log", Builder.log(MaterialColor.f_76419_, MaterialColor.f_76362_, () -> STRIPPED_MANGROVE_LOG));
    public static final RegistryObject<RotatedPillarBlock> LIGHT_MANGROVE_WOOD = TropicraftBlocks.register("light_mangrove_wood", Builder.wood(MaterialColor.f_76419_, () -> STRIPPED_MANGROVE_WOOD));
    public static final RegistryObject<Block> LIGHT_MANGROVE_ROOTS = TropicraftBlocks.register("light_mangrove_roots", Builder.mangroveRoots());
    public static final RegistryObject<RotatedPillarBlock> BLACK_MANGROVE_LOG = TropicraftBlocks.register("black_mangrove_log", Builder.log(MaterialColor.f_76419_, MaterialColor.f_76362_, () -> STRIPPED_MANGROVE_LOG));
    public static final RegistryObject<RotatedPillarBlock> BLACK_MANGROVE_WOOD = TropicraftBlocks.register("black_mangrove_wood", Builder.wood(MaterialColor.f_76419_, () -> STRIPPED_MANGROVE_WOOD));
    public static final RegistryObject<Block> BLACK_MANGROVE_ROOTS = TropicraftBlocks.register("black_mangrove_roots", Builder.mangroveRoots());
    public static final RegistryObject<LeavesBlock> RED_MANGROVE_LEAVES = TropicraftBlocks.register("red_mangrove_leaves", Builder.mangroveLeaves(() -> RED_MANGROVE_PROPAGULE));
    public static final RegistryObject<LeavesBlock> TALL_MANGROVE_LEAVES = TropicraftBlocks.register("tall_mangrove_leaves", Builder.mangroveLeaves(() -> TALL_MANGROVE_PROPAGULE));
    public static final RegistryObject<LeavesBlock> TEA_MANGROVE_LEAVES = TropicraftBlocks.register("tea_mangrove_leaves", Builder.mangroveLeaves(() -> TEA_MANGROVE_PROPAGULE));
    public static final RegistryObject<LeavesBlock> BLACK_MANGROVE_LEAVES = TropicraftBlocks.register("black_mangrove_leaves", Builder.mangroveLeaves(() -> BLACK_MANGROVE_PROPAGULE));
    public static final RegistryObject<PropaguleBlock> RED_MANGROVE_PROPAGULE = TropicraftBlocks.register("red_mangrove_propagule", Builder.propagule(TropicraftTrees.RED_MANGROVE));
    public static final RegistryObject<PropaguleBlock> TALL_MANGROVE_PROPAGULE = TropicraftBlocks.register("tall_mangrove_propagule", Builder.propagule(TropicraftTrees.TALL_MANGROVE));
    public static final RegistryObject<PropaguleBlock> TEA_MANGROVE_PROPAGULE = TropicraftBlocks.register("tea_mangrove_propagule", Builder.propagule(TropicraftTrees.TEA_MANGROVE));
    public static final RegistryObject<PropaguleBlock> BLACK_MANGROVE_PROPAGULE = TropicraftBlocks.register("black_mangrove_propagule", Builder.propagule(TropicraftTrees.BLACK_MANGROVE));
    public static final RegistryObject<RotatedPillarBlock> STRIPPED_MANGROVE_LOG = TropicraftBlocks.register("stripped_mangrove_log", Builder.log(MaterialColor.f_76419_, MaterialColor.f_76362_));
    public static final RegistryObject<RotatedPillarBlock> STRIPPED_MANGROVE_WOOD = TropicraftBlocks.register("stripped_mangrove_wood", Builder.wood(MaterialColor.f_76419_));
    public static final RegistryObject<Block> MANGROVE_PLANKS = TropicraftBlocks.register("mangrove_planks", Builder.plank(MaterialColor.f_76411_));
    public static final RegistryObject<StairBlock> MANGROVE_STAIRS = TropicraftBlocks.register("mangrove_stairs", Builder.stairs(MANGROVE_PLANKS));
    public static final RegistryObject<SlabBlock> MANGROVE_SLAB = TropicraftBlocks.register("mangrove_slab", Builder.slab(MANGROVE_PLANKS));
    public static final RegistryObject<FenceBlock> MANGROVE_FENCE = TropicraftBlocks.register("mangrove_fence", Builder.fence(MANGROVE_PLANKS));
    public static final RegistryObject<FenceGateBlock> MANGROVE_FENCE_GATE = TropicraftBlocks.register("mangrove_fence_gate", Builder.fenceGate(MANGROVE_PLANKS));
    public static final RegistryObject<DoorBlock> MANGROVE_DOOR = TropicraftBlocks.register("mangrove_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_)){});
    public static final RegistryObject<TrapDoorBlock> MANGROVE_TRAPDOOR = TropicraftBlocks.register("mangrove_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MANGROVE_DOOR.get()))){});
    public static final RegistryObject<ReedsBlock> REEDS = TropicraftBlocks.register("reeds", () -> new ReedsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50130_)));
    public static final RegistryObject<PapayaBlock> PAPAYA = TropicraftBlocks.registerWithFood("papaya", () -> new PapayaBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60977_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()), Foods.PAPAYA);
    public static final RegistryObject<FenceBlock> BAMBOO_FENCE = TropicraftBlocks.register("bamboo_fence", Builder.fence(BAMBOO_BUNDLE));
    public static final RegistryObject<FenceBlock> THATCH_FENCE = TropicraftBlocks.register("thatch_fence", Builder.fence(THATCH_BUNDLE));
    public static final RegistryObject<FenceBlock> CHUNK_FENCE = TropicraftBlocks.register("chunk_fence", Builder.fence(CHUNK));
    public static final RegistryObject<FenceBlock> PALM_FENCE = TropicraftBlocks.register("palm_fence", Builder.fence(PALM_PLANKS));
    public static final RegistryObject<FenceBlock> MAHOGANY_FENCE = TropicraftBlocks.register("mahogany_fence", Builder.fence(MAHOGANY_PLANKS));
    public static final RegistryObject<FenceGateBlock> BAMBOO_FENCE_GATE = TropicraftBlocks.register("bamboo_fence_gate", Builder.fenceGate(BAMBOO_BUNDLE));
    public static final RegistryObject<FenceGateBlock> THATCH_FENCE_GATE = TropicraftBlocks.register("thatch_fence_gate", Builder.fenceGate(THATCH_BUNDLE));
    public static final RegistryObject<FenceGateBlock> CHUNK_FENCE_GATE = TropicraftBlocks.register("chunk_fence_gate", Builder.fenceGate(CHUNK));
    public static final RegistryObject<FenceGateBlock> PALM_FENCE_GATE = TropicraftBlocks.register("palm_fence_gate", Builder.fenceGate(PALM_PLANKS));
    public static final RegistryObject<FenceGateBlock> MAHOGANY_FENCE_GATE = TropicraftBlocks.register("mahogany_fence_gate", Builder.fenceGate(MAHOGANY_PLANKS));
    public static final RegistryObject<WallBlock> CHUNK_WALL = TropicraftBlocks.register("chunk_wall", Builder.wall(CHUNK));
    public static final RegistryObject<DoorBlock> BAMBOO_DOOR = TropicraftBlocks.register("bamboo_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BAMBOO_BUNDLE.get())).m_60978_(1.0f).m_60955_()){});
    public static final RegistryObject<DoorBlock> PALM_DOOR = TropicraftBlocks.register("palm_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_)){});
    public static final RegistryObject<DoorBlock> MAHOGANY_DOOR = TropicraftBlocks.register("mahogany_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_)){});
    public static final RegistryObject<DoorBlock> THATCH_DOOR = TropicraftBlocks.register("thatch_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)THATCH_BUNDLE.get()))){});
    public static final RegistryObject<TrapDoorBlock> BAMBOO_TRAPDOOR = TropicraftBlocks.register("bamboo_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BAMBOO_DOOR.get()))){});
    public static final RegistryObject<TrapDoorBlock> PALM_TRAPDOOR = TropicraftBlocks.register("palm_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PALM_DOOR.get()))){});
    public static final RegistryObject<TrapDoorBlock> MAHOGANY_TRAPDOOR = TropicraftBlocks.register("mahogany_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MAHOGANY_DOOR.get()))){});
    public static final RegistryObject<TrapDoorBlock> THATCH_TRAPDOOR = TropicraftBlocks.register("thatch_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)THATCH_BUNDLE.get()))){});
    public static final RegistryObject<TallFlowerBlock> IRIS = TropicraftBlocks.register("iris", () -> new TallFlowerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<PineappleBlock> PINEAPPLE = TropicraftBlocks.register("pineapple", () -> new PineappleBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60977_().m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<BongoDrumBlock> SMALL_BONGO_DRUM = TropicraftBlocks.register("small_bongo_drum", Builder.bongo(BongoDrumBlock.Size.SMALL));
    public static final RegistryObject<BongoDrumBlock> MEDIUM_BONGO_DRUM = TropicraftBlocks.register("medium_bongo_drum", Builder.bongo(BongoDrumBlock.Size.MEDIUM));
    public static final RegistryObject<BongoDrumBlock> LARGE_BONGO_DRUM = TropicraftBlocks.register("large_bongo_drum", Builder.bongo(BongoDrumBlock.Size.LARGE));
    public static final RegistryObject<LadderBlock> BAMBOO_LADDER = TropicraftBlocks.register("bamboo_ladder", () -> new LadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50571_)){});
    public static final RegistryObject<Block> BAMBOO_BOARDWALK = TropicraftBlocks.register("bamboo_boardwalk", () -> new BoardwalkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BAMBOO_SLAB.get())).m_60955_()));
    public static final RegistryObject<Block> PALM_BOARDWALK = TropicraftBlocks.register("palm_boardwalk", () -> new BoardwalkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PALM_SLAB.get())).m_60955_()));
    public static final RegistryObject<Block> MAHOGANY_BOARDWALK = TropicraftBlocks.register("mahogany_boardwalk", () -> new BoardwalkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MAHOGANY_SLAB.get())).m_60955_()));
    public static final RegistryObject<Block> MANGROVE_BOARDWALK = TropicraftBlocks.register("mangrove_boardwalk", () -> new BoardwalkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MANGROVE_SLAB.get())).m_60955_()));
    public static final RegistryObject<BambooChestBlock> BAMBOO_CHEST = TropicraftBlocks.register("bamboo_chest", () -> new BambooChestBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BAMBOO_BUNDLE.get())).m_60978_(1.0f), () -> TropicraftBlockEntityTypes.BAMBOO_CHEST.get()), () -> TropicraftItemRenderers.bambooChest());
    public static final RegistryObject<SifterBlock> SIFTER = TropicraftBlocks.register("sifter", () -> new SifterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_()));
    public static final RegistryObject<DrinkMixerBlock> DRINK_MIXER = TropicraftBlocks.register("drink_mixer", () -> new DrinkMixerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 30.0f).m_60955_()), () -> TropicraftItemRenderers.drinkMixer());
    public static final RegistryObject<AirCompressorBlock> AIR_COMPRESSOR = TropicraftBlocks.register("air_compressor", () -> new AirCompressorBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 30.0f).m_60955_()), () -> TropicraftItemRenderers.airCompressor());
    public static final RegistryObject<VolcanoBlock> VOLCANO = TropicraftBlocks.registerNoItem("volcano", () -> new VolcanoBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_).m_60993_()));
    public static final RegistryObject<TikiTorchBlock> TIKI_TORCH = TropicraftBlocks.register("tiki_torch", () -> new TikiTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_60918_(SoundType.f_56736_).m_60953_(state -> state.m_61143_(TikiTorchBlock.SECTION) == TikiTorchBlock.TorchSection.UPPER ? 15 : 0)));
    public static final RegistryObject<FlowerPotBlock> BAMBOO_FLOWER_POT = TropicraftBlocks.register("bamboo_flower_pot", Builder.tropicraftPot());
    public static final RegistryObject<CoffeeBushBlock> COFFEE_BUSH = TropicraftBlocks.registerNoItem("coffee_bush", () -> new CoffeeBushBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76399_).m_60978_(0.15f).m_60918_(SoundType.f_56740_).m_60955_()));
    public static final RegistryObject<BushBlock> GOLDEN_LEATHER_FERN = TropicraftBlocks.register("small_golden_leather_fern", () -> new GrowableSinglePlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50035_), () -> TALL_GOLDEN_LEATHER_FERN));
    public static final RegistryObject<DoublePlantBlock> TALL_GOLDEN_LEATHER_FERN = TropicraftBlocks.registerNoItem("tall_golden_leather_fern", () -> new GrowableDoublePlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50360_), () -> LARGE_GOLDEN_LEATHER_FERN).setPickItem(() -> GOLDEN_LEATHER_FERN));
    public static final RegistryObject<HugePlantBlock> LARGE_GOLDEN_LEATHER_FERN = TropicraftBlocks.registerNoItem("golden_leather_fern", () -> new HugePlantBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60955_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_)).setPickItem(() -> GOLDEN_LEATHER_FERN));
    private static final Set<RegistryObject<? extends Block>> POTTABLE_PLANTS = ImmutableSet.builder().add((Object[])new RegistryObject[]{PALM_SAPLING, MAHOGANY_SAPLING, GRAPEFRUIT_SAPLING, LEMON_SAPLING, LIME_SAPLING, ORANGE_SAPLING}).add(IRIS).addAll(FLOWERS.values()).build();
    public static final List<RegistryObject<FlowerPotBlock>> BAMBOO_POTTED_TROPICS_PLANTS = ImmutableList.copyOf((Collection)POTTABLE_PLANTS.stream().map(b -> TropicraftBlocks.registerNoItem("bamboo_potted_" + b.getId().m_135815_(), Builder.tropicraftPot((Supplier<? extends Block>)b))).collect(Collectors.toList()));
    public static final List<RegistryObject<FlowerPotBlock>> VANILLA_POTTED_TROPICS_PLANTS = ImmutableList.copyOf((Collection)POTTABLE_PLANTS.stream().map(b -> TropicraftBlocks.registerNoItem("potted_" + b.getId().m_135815_(), Builder.vanillaPot((Supplier<? extends Block>)b))).collect(Collectors.toList()));
    public static final List<RegistryObject<FlowerPotBlock>> BAMBOO_POTTED_VANILLA_PLANTS = ImmutableList.copyOf((Collection)Stream.of(Blocks.f_50746_, Blocks.f_50747_, Blocks.f_50748_, Blocks.f_50749_, Blocks.f_50750_, Blocks.f_50751_, Blocks.f_50035_, Blocks.f_50111_, Blocks.f_50112_, Blocks.f_50113_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50116_, Blocks.f_50117_, Blocks.f_50118_, Blocks.f_50119_, Blocks.f_50120_, Blocks.f_50121_, Blocks.f_50071_, Blocks.f_50070_, Blocks.f_50073_, Blocks.f_50072_, Blocks.f_50036_, Blocks.f_50128_).map(b -> TropicraftBlocks.registerNoItem("bamboo_potted_" + b.getRegistryName().m_135815_(), Builder.tropicraftPot(() -> b))).collect(Collectors.toList()));
    public static final List<RegistryObject<FlowerPotBlock>> ALL_POTTED_PLANTS = ImmutableList.builder().addAll(BAMBOO_POTTED_TROPICS_PLANTS).addAll(VANILLA_POTTED_TROPICS_PLANTS).addAll(BAMBOO_POTTED_VANILLA_PLANTS).build();
    public static final Map<JigarbovTorchType, RegistryObject<RedstoneWallTorchBlock>> JIGARBOV_WALL_TORCHES = Arrays.stream(JigarbovTorchType.values()).collect(Collectors.toMap(Function.identity(), type -> TropicraftBlocks.registerNoItem("jigarbov_" + type.getName() + "_wall_torch", () -> new RedstoneWallTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50123_).lootFrom(() -> Blocks.f_50174_)){

        public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
            return new ItemStack((ItemLike)Items.f_41978_);
        }
    })));

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup) {
        return TropicraftBlocks.register(name, sup, TropicraftBlocks::itemDefault);
    }

    private static <T extends Block> RegistryObject<T> registerWithFood(String name, Supplier<? extends T> sup, FoodProperties food) {
        return TropicraftBlocks.register(name, sup, TropicraftBlocks::itemDefault);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Supplier<IItemRenderProperties> renderProperties) {
        return TropicraftBlocks.register(name, sup, (RegistryObject<T> block) -> TropicraftBlocks.item((RegistryObject<? extends Block>)block, renderProperties));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, CreativeModeTab tab) {
        return TropicraftBlocks.register(name, sup, (RegistryObject<T> block) -> TropicraftBlocks.item((RegistryObject<? extends Block>)block, tab));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = TropicraftBlocks.registerNoItem(name, sup);
        BLOCKITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> itemDefault(RegistryObject<? extends Block> block) {
        return TropicraftBlocks.item(block, Tropicraft.TROPICRAFT_ITEM_GROUP);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, FoodProperties food) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP).m_41489_(food));
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, final Supplier<IItemRenderProperties> renderProperties) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(Tropicraft.TROPICRAFT_ITEM_GROUP)){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                consumer.accept((IItemRenderProperties)renderProperties.get());
            }
        };
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, CreativeModeTab itemGroup) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(itemGroup));
    }
}

