/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.block.TropicraftBlocks;

public enum TropicraftFlower implements Supplier<Block>
{
    ACAI_VINE((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 7, 16),
    ANEMONE((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 9),
    BROMELIAD((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 9),
    CANNA((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0),
    COMMELINA_DIFFUSA((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0),
    CROCOSMIA((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0),
    CROTON((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 13),
    DRACAENA((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 13),
    TROPICAL_FERN((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 13),
    FOLIAGE((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 13),
    MAGIC_MUSHROOM((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 11),
    ORANGE_ANTHURIUM((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 11),
    ORCHID((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0),
    PATHOS((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 15, 12),
    RED_ANTHURIUM((Supplier<MobEffect>)MobEffects.f_19605_.delegate, 0, 11);

    private final String name;
    private final Supplier<MobEffect> effect;
    private final int effectDuration;
    private final VoxelShape shape;

    private TropicraftFlower(Supplier<MobEffect> effect, int effectDuration) {
        this(effect, effectDuration, 7);
    }

    private TropicraftFlower(Supplier<MobEffect> effect, int effectDuration, int w) {
        this(effect, effectDuration, w, 15);
    }

    private TropicraftFlower(Supplier<MobEffect> effect, int effectDuration, int w, int h) {
        this(null, effect, effectDuration, w, h);
    }

    private TropicraftFlower(String name, Supplier<MobEffect> effect, int effectDuration, int w, int h) {
        this.name = name == null ? Util.toEnglishName(this.name()) : name;
        this.effect = effect;
        this.effectDuration = effectDuration;
        float halfW = (float)w / 2.0f;
        this.shape = Block.m_49796_((double)(8.0f - halfW), (double)0.0, (double)(8.0f - halfW), (double)(8.0f + halfW), (double)h, (double)(8.0f + halfW));
    }

    public MobEffect getEffect() {
        return this.effect.get();
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    public String getId() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Block get() {
        return (Block)TropicraftBlocks.FLOWERS.get(this).get();
    }

    public String getEnglishName() {
        return this.name;
    }
}

