/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.tree.CitrusFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.CitrusTrunkPlacer;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.PapayaFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.PapayaTreeDecorator;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;

public class TropicraftTrees {
    public static final BeehiveDecorator BEEHIVE_002 = new BeehiveDecorator(0.02f);
    public static final BeehiveDecorator BEEHIVE_005 = new BeehiveDecorator(0.05f);
    public static final AbstractTreeGrower GRAPEFRUIT = TropicraftTrees.createFruit(TropicraftBlocks.GRAPEFRUIT_LEAVES);
    public static final AbstractTreeGrower LEMON = TropicraftTrees.createFruit(TropicraftBlocks.LEMON_LEAVES);
    public static final AbstractTreeGrower LIME = TropicraftTrees.createFruit(TropicraftBlocks.LIME_LEAVES);
    public static final AbstractTreeGrower ORANGE = TropicraftTrees.createFruit(TropicraftBlocks.ORANGE_LEAVES);
    public static final AbstractTreeGrower PAPAYA = TropicraftTrees.create((MinecraftServer server, Random random, boolean beehive) -> {
        TreeConfiguration config = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TropicraftBlocks.PAPAYA_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 3), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TropicraftBlocks.PAPAYA_LEAVES.get())), (FoliagePlacer)new PapayaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68249_((List)ImmutableList.of((Object)BEEHIVE_005, (Object)((Object)new PapayaTreeDecorator()))).m_68251_();
        return new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)config);
    });
    public static final AbstractTreeGrower RAINFOREST = TropicraftTrees.create((MinecraftServer server, Random random, boolean beehive) -> {
        int treeType = random.nextInt(4);
        if (treeType == 0) {
            return new ConfiguredFeature((Feature)((RainforestTreeFeature)((Object)((Object)TropicraftFeatures.TALL_TREE.get()))), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
        }
        if (treeType == 1) {
            return new ConfiguredFeature((Feature)((RainforestTreeFeature)((Object)((Object)TropicraftFeatures.SMALL_TUALUNG.get()))), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
        }
        if (treeType == 2) {
            return new ConfiguredFeature((Feature)((RainforestTreeFeature)((Object)((Object)TropicraftFeatures.UP_TREE.get()))), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
        }
        return new ConfiguredFeature((Feature)((RainforestTreeFeature)((Object)((Object)TropicraftFeatures.LARGE_TUALUNG.get()))), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
    });
    public static final AbstractTreeGrower PALM = TropicraftTrees.create((MinecraftServer server, Random random, boolean beehive) -> {
        int palmType = random.nextInt(3);
        if (palmType == 0) {
            return new ConfiguredFeature((Feature)((PalmTreeFeature)((Object)((Object)TropicraftFeatures.NORMAL_PALM_TREE.get()))), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
        }
        if (palmType == 1) {
            return new ConfiguredFeature((Feature)((PalmTreeFeature)((Object)((Object)TropicraftFeatures.CURVED_PALM_TREE.get()))), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
        }
        return new ConfiguredFeature((Feature)((PalmTreeFeature)((Object)((Object)TropicraftFeatures.LARGE_PALM_TREE.get()))), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
    });
    public static final AbstractTreeGrower RED_MANGROVE = TropicraftTrees.create("red_mangrove");
    public static final AbstractTreeGrower TALL_MANGROVE = TropicraftTrees.create("tall_mangrove");
    public static final AbstractTreeGrower TEA_MANGROVE = TropicraftTrees.create("tea_mangrove");
    public static final AbstractTreeGrower BLACK_MANGROVE = TropicraftTrees.create("black_mangrove");

    private static AbstractTreeGrower createFruit(Supplier<? extends Block> fruitLeaves) {
        return TropicraftTrees.create((MinecraftServer server, Random random, boolean beehive) -> {
            WeightedStateProvider leaves = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((LeavesBlock)TropicraftBlocks.FRUIT_LEAVES.get()).m_49966_(), 1).m_146271_((Object)((Block)fruitLeaves.get()).m_49966_(), 1));
            TreeConfiguration config = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), (TrunkPlacer)new CitrusTrunkPlacer(6, 3, 0), (BlockStateProvider)leaves, (FoliagePlacer)new CitrusFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68251_();
            return new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)config);
        });
    }

    private static AbstractTreeGrower create(String id) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)new ResourceLocation("tropicraft", id));
        return TropicraftTrees.create((MinecraftServer server, Random random, boolean beehive) -> {
            RegistryAccess.Frozen registries = server.m_206579_();
            Registry features = registries.m_175515_(Registry.f_122881_);
            return (ConfiguredFeature)features.m_6246_(key);
        });
    }

    private static AbstractTreeGrower create(final FeatureProvider featureProvider) {
        return new AbstractTreeGrower(){

            @Nullable
            protected Holder<? extends ConfiguredFeature<?, ?>> m_203525_(Random random, boolean beehive) {
                return null;
            }

            public boolean m_6334_(ServerLevel world, ChunkGenerator generator, BlockPos pos, BlockState sapling, Random random) {
                ConfiguredFeature<?, ?> feature = featureProvider.getFeature(world.m_142572_(), random, this.hasFlowers((LevelAccessor)world, pos));
                if (feature == null) {
                    return false;
                }
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 4);
                if (feature.m_65385_((WorldGenLevel)world, generator, random, pos)) {
                    return true;
                }
                world.m_7731_(pos, sapling, 4);
                return false;
            }

            private boolean hasFlowers(LevelAccessor world, BlockPos origin) {
                BlockPos min = origin.m_142082_(-2, -1, -2);
                BlockPos max = origin.m_142082_(2, 1, 2);
                for (BlockPos pos : BlockPos.MutableBlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
                    if (!world.m_8055_(pos).m_204336_(BlockTags.f_13041_)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static interface FeatureProvider {
        @Nullable
        public ConfiguredFeature<?, ?> getFeature(MinecraftServer var1, Random var2, boolean var3);
    }
}

