/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.tileentity.IMachineBlock;
import net.tropicraft.core.common.block.tileentity.TropicraftBlockEntityTypes;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.Drinks;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.network.TropicraftPackets;
import net.tropicraft.core.common.network.message.MessageMixerInventory;
import net.tropicraft.core.common.network.message.MessageMixerStart;

public class DrinkMixerBlockEntity
extends BlockEntity
implements IMachineBlock {
    private static final int TICKS_TO_MIX = 80;
    private static final int MAX_NUM_INGREDIENTS = 3;
    private int ticks;
    public NonNullList<ItemStack> ingredients;
    private boolean mixing = false;
    public ItemStack result = ItemStack.f_41583_;

    public DrinkMixerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TropicraftBlockEntityTypes.DRINK_MIXER.get(), pos, state);
        this.ingredients = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.ticks = nbt.m_128451_("MixTicks");
        this.mixing = nbt.m_128471_("Mixing");
        for (int i = 0; i < 3; ++i) {
            if (!nbt.m_128441_("Ingredient" + i)) continue;
            this.ingredients.set(i, (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Ingredient" + i)));
        }
        if (nbt.m_128441_("Result")) {
            this.result = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Result"));
        }
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("MixTicks", this.ticks);
        nbt.m_128379_("Mixing", this.mixing);
        for (int i = 0; i < 3; ++i) {
            CompoundTag ingredientNbt = new CompoundTag();
            ((ItemStack)this.ingredients.get(i)).m_41739_(ingredientNbt);
            nbt.m_128365_("Ingredient" + i, (Tag)ingredientNbt);
        }
        CompoundTag resultNbt = new CompoundTag();
        this.result.m_41739_(resultNbt);
        nbt.m_128365_("Result", (Tag)resultNbt);
    }

    public static void mixTick(Level level, BlockPos pos, BlockState state, DrinkMixerBlockEntity mixer) {
        mixer.tick();
    }

    private void tick() {
        if (this.ticks < 80 && this.mixing) {
            ++this.ticks;
            if (this.ticks == 80) {
                this.finishMixing();
            }
        }
    }

    public boolean isDoneMixing() {
        return !this.result.m_41619_();
    }

    public NonNullList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public static List<Ingredient> listIngredients(@Nonnull ItemStack stack) {
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        if (Drink.isDrink(stack.m_41720_())) {
            Collections.addAll(is, CocktailItem.getIngredients(stack));
        } else {
            Ingredient i = Ingredient.findMatchingIngredient(stack);
            if (i != null) {
                is.add(i);
            }
        }
        return is;
    }

    public void startMixing() {
        this.ticks = 0;
        this.mixing = true;
        if (!this.f_58857_.f_46443_) {
            TropicraftPackets.sendToDimension(new MessageMixerStart(this), this.f_58857_);
        }
    }

    private void dropItem(@Nonnull ItemStack stack, @Nullable Player at) {
        if (at == null) {
            BlockPos pos = this.m_58899_().m_142300_((Direction)this.m_58900_().m_61143_((Property)DrinkMixerBlock.FACING));
            Containers.m_18992_((Level)this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        } else {
            Containers.m_18992_((Level)this.f_58857_, (double)at.m_20185_(), (double)at.m_20186_(), (double)at.m_20189_(), (ItemStack)stack);
        }
    }

    public void emptyMixer(@Nullable Player at) {
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.ingredients.get(i)).m_41619_()) continue;
            this.dropItem((ItemStack)this.ingredients.get(i), at);
            this.ingredients.set(i, (Object)ItemStack.f_41583_);
        }
        this.ticks = 80;
        this.mixing = false;
        this.syncInventory();
    }

    public void retrieveResult(@Nullable Player at) {
        if (this.result.m_41619_()) {
            return;
        }
        this.dropItem(this.result, at);
        for (int i = 0; i < 3; ++i) {
            ItemStack container;
            if (((ItemStack)this.ingredients.get(i)).m_41619_() || (container = ((ItemStack)this.ingredients.get(i)).m_41720_().getContainerItem((ItemStack)this.ingredients.get(i))).m_41619_()) continue;
            this.dropItem(container, at);
        }
        this.ingredients.clear();
        this.result = ItemStack.f_41583_;
        this.syncInventory();
    }

    public void finishMixing() {
        this.result = this.getResult(this.getIngredients());
        this.mixing = false;
        this.ticks = 0;
        this.syncInventory();
    }

    public boolean addToMixer(@Nonnull ItemStack ingredient) {
        if (((ItemStack)this.ingredients.get(0)).m_41619_()) {
            Ingredient i;
            if (!Drink.isDrink(ingredient.m_41720_()) && (i = Ingredient.findMatchingIngredient(ingredient)) == null) {
                return false;
            }
            this.ingredients.set(0, (Object)ingredient);
            this.syncInventory();
            return true;
        }
        if (((ItemStack)this.ingredients.get(1)).m_41619_()) {
            if (Drink.isDrink(ingredient.m_41720_())) {
                return false;
            }
            Ingredient ing0 = Ingredient.findMatchingIngredient((ItemStack)this.ingredients.get(0));
            Ingredient i = Ingredient.findMatchingIngredient(ingredient);
            if (i == null || ing0.id == i.id) {
                return false;
            }
            this.ingredients.set(1, (Object)ingredient);
            this.syncInventory();
            return true;
        }
        if (((ItemStack)this.ingredients.get(2)).m_41619_()) {
            if (Drink.isDrink(ingredient.m_41720_())) {
                return false;
            }
            Ingredient ing0 = Ingredient.findMatchingIngredient((ItemStack)this.ingredients.get(0));
            Ingredient ing1 = Ingredient.findMatchingIngredient((ItemStack)this.ingredients.get(1));
            Ingredient i = Ingredient.findMatchingIngredient(ingredient);
            if (i == null || ing0.id == i.id || ing1.id == i.id) {
                return false;
            }
            this.ingredients.set(2, (Object)ingredient);
            this.syncInventory();
            return true;
        }
        return false;
    }

    public boolean isMixing() {
        return this.mixing;
    }

    private boolean isMixerFull() {
        return MixerRecipes.isValidRecipe(this.ingredients);
    }

    public boolean canMix() {
        return !this.mixing && this.isMixerFull();
    }

    @Override
    public boolean isActive() {
        return this.isMixing();
    }

    @Override
    public float getProgress(float partialTicks) {
        return ((float)this.ticks + partialTicks) / 80.0f;
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.m_61143_((Property)DrinkMixerBlock.FACING);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected void syncInventory() {
        if (!this.f_58857_.f_46443_) {
            TropicraftPackets.sendToDimension(new MessageMixerInventory(this), this.f_58857_);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private CompoundTag writeItems(CompoundTag nbt) {
        this.m_183515_(nbt);
        return nbt;
    }

    public ItemStack getResult(NonNullList<ItemStack> ingredients2) {
        return Drinks.getResult(ingredients2);
    }
}

