/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.data;

import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;

public class TropicraftBlockTagsProvider
extends BlockTagsProvider {
    public TropicraftBlockTagsProvider(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
        super(generatorIn, "tropicraft", existingFileHelper);
    }

    protected void m_6577_() {
        this.createAndAppend(TropicraftTags.Blocks.SAND, (TagKey<Block>)BlockTags.f_13029_, new Supplier[]{TropicraftBlocks.PURIFIED_SAND, TropicraftBlocks.CORAL_SAND, TropicraftBlocks.FOAMY_SAND, TropicraftBlocks.MINERAL_SAND, TropicraftBlocks.VOLCANIC_SAND});
        this.createTag(TropicraftTags.Blocks.MUD, new Supplier[]{TropicraftBlocks.MUD, TropicraftBlocks.MUD_WITH_PIANGUAS});
        this.createAndAppend(TropicraftTags.Blocks.SAPLINGS, (TagKey<Block>)BlockTags.f_13104_, new Supplier[]{TropicraftBlocks.PALM_SAPLING, TropicraftBlocks.MAHOGANY_SAPLING, TropicraftBlocks.GRAPEFRUIT_SAPLING, TropicraftBlocks.LEMON_SAPLING, TropicraftBlocks.LIME_SAPLING, TropicraftBlocks.ORANGE_SAPLING, TropicraftBlocks.PAPAYA_SAPLING, TropicraftBlocks.RED_MANGROVE_PROPAGULE, TropicraftBlocks.TALL_MANGROVE_PROPAGULE, TropicraftBlocks.TEA_MANGROVE_PROPAGULE, TropicraftBlocks.BLACK_MANGROVE_PROPAGULE});
        this.createAndAppend(TropicraftTags.Blocks.LEAVES, (TagKey<Block>)BlockTags.f_13035_, new Supplier[]{TropicraftBlocks.MAHOGANY_LEAVES, TropicraftBlocks.PALM_LEAVES, TropicraftBlocks.KAPOK_LEAVES, TropicraftBlocks.FRUIT_LEAVES, TropicraftBlocks.GRAPEFRUIT_LEAVES, TropicraftBlocks.LEMON_LEAVES, TropicraftBlocks.LIME_LEAVES, TropicraftBlocks.ORANGE_LEAVES, TropicraftBlocks.RED_MANGROVE_LEAVES, TropicraftBlocks.TALL_MANGROVE_LEAVES, TropicraftBlocks.TEA_MANGROVE_LEAVES, TropicraftBlocks.BLACK_MANGROVE_LEAVES, TropicraftBlocks.PAPAYA_LEAVES});
        this.createAndAppend(TropicraftTags.Blocks.SMALL_FLOWERS, (TagKey<Block>)BlockTags.f_13037_, TropicraftFlower.ACAI_VINE, TropicraftFlower.ANEMONE, TropicraftFlower.BROMELIAD, TropicraftFlower.CANNA, TropicraftFlower.COMMELINA_DIFFUSA, TropicraftFlower.CROCOSMIA, TropicraftFlower.CROTON, TropicraftFlower.DRACAENA, TropicraftFlower.TROPICAL_FERN, TropicraftFlower.FOLIAGE, TropicraftFlower.MAGIC_MUSHROOM, TropicraftFlower.ORANGE_ANTHURIUM, TropicraftFlower.ORCHID, TropicraftFlower.PATHOS, TropicraftFlower.RED_ANTHURIUM);
        this.createTag(TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftFlower.ACAI_VINE, TropicraftFlower.ANEMONE, TropicraftFlower.BROMELIAD, TropicraftFlower.CANNA, TropicraftFlower.COMMELINA_DIFFUSA, TropicraftFlower.CROCOSMIA, TropicraftFlower.CROTON, TropicraftFlower.DRACAENA, TropicraftFlower.TROPICAL_FERN, TropicraftFlower.FOLIAGE, TropicraftFlower.ORANGE_ANTHURIUM, TropicraftFlower.ORCHID, TropicraftFlower.PATHOS, TropicraftFlower.RED_ANTHURIUM);
        this.createTag(TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftFlower.MAGIC_MUSHROOM, TropicraftFlower.CROCOSMIA, TropicraftFlower.COMMELINA_DIFFUSA, TropicraftFlower.ORCHID, TropicraftFlower.ANEMONE, TropicraftFlower.BROMELIAD, TropicraftFlower.CANNA, TropicraftFlower.RED_ANTHURIUM, TropicraftFlower.DRACAENA, TropicraftFlower.ORANGE_ANTHURIUM);
        this.createTag(TropicraftTags.Blocks.OVERWORLD_FLOWERS, TropicraftFlower.ORCHID, TropicraftFlower.PATHOS, TropicraftFlower.RED_ANTHURIUM, TropicraftFlower.COMMELINA_DIFFUSA, TropicraftFlower.ANEMONE, TropicraftFlower.ORANGE_ANTHURIUM);
        this.createAndAppend(TropicraftTags.Blocks.LOGS, (TagKey<Block>)BlockTags.f_13105_, new Supplier[]{TropicraftBlocks.PALM_LOG, TropicraftBlocks.MAHOGANY_LOG, TropicraftBlocks.LIGHT_MANGROVE_LOG, TropicraftBlocks.RED_MANGROVE_LOG, TropicraftBlocks.BLACK_MANGROVE_LOG, TropicraftBlocks.STRIPPED_MANGROVE_LOG, TropicraftBlocks.PAPAYA_LOG, TropicraftBlocks.PALM_WOOD, TropicraftBlocks.MAHOGANY_WOOD, TropicraftBlocks.LIGHT_MANGROVE_WOOD, TropicraftBlocks.RED_MANGROVE_WOOD, TropicraftBlocks.BLACK_MANGROVE_WOOD, TropicraftBlocks.STRIPPED_MANGROVE_WOOD, TropicraftBlocks.PAPAYA_WOOD});
        this.createAndAppend(TropicraftTags.Blocks.PLANKS, (TagKey<Block>)BlockTags.f_13090_, new Supplier[]{TropicraftBlocks.PALM_PLANKS, TropicraftBlocks.MAHOGANY_PLANKS, TropicraftBlocks.MANGROVE_PLANKS});
        this.createTag(TropicraftTags.Blocks.ROOTS, new Supplier[]{TropicraftBlocks.RED_MANGROVE_ROOTS, TropicraftBlocks.LIGHT_MANGROVE_ROOTS, TropicraftBlocks.BLACK_MANGROVE_ROOTS});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_SLABS, (TagKey<Block>)BlockTags.f_13097_, new Supplier[]{TropicraftBlocks.PALM_SLAB, TropicraftBlocks.MAHOGANY_SLAB, TropicraftBlocks.MANGROVE_SLAB});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_STAIRS, (TagKey<Block>)BlockTags.f_13096_, new Supplier[]{TropicraftBlocks.PALM_STAIRS, TropicraftBlocks.MAHOGANY_STAIRS, TropicraftBlocks.MANGROVE_STAIRS});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_DOORS, (TagKey<Block>)BlockTags.f_13095_, new Supplier[]{TropicraftBlocks.PALM_DOOR, TropicraftBlocks.MAHOGANY_DOOR, TropicraftBlocks.MANGROVE_DOOR});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_TRAPDOORS, (TagKey<Block>)BlockTags.f_13102_, new Supplier[]{TropicraftBlocks.PALM_TRAPDOOR, TropicraftBlocks.MAHOGANY_TRAPDOOR, TropicraftBlocks.MANGROVE_TRAPDOOR});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_FENCES, (TagKey<Block>)BlockTags.f_13098_, new Supplier[]{TropicraftBlocks.PALM_FENCE, TropicraftBlocks.MAHOGANY_FENCE, TropicraftBlocks.MANGROVE_FENCE});
        this.extendAndAppend(TropicraftTags.Blocks.SLABS, TropicraftTags.Blocks.WOODEN_SLABS, (TagKey<Block>)BlockTags.f_13031_, new Supplier[]{TropicraftBlocks.BAMBOO_SLAB, TropicraftBlocks.CHUNK_SLAB, TropicraftBlocks.THATCH_SLAB});
        this.extendAndAppend(TropicraftTags.Blocks.STAIRS, TropicraftTags.Blocks.WOODEN_STAIRS, (TagKey<Block>)BlockTags.f_13030_, new Supplier[]{TropicraftBlocks.BAMBOO_STAIRS, TropicraftBlocks.CHUNK_STAIRS, TropicraftBlocks.THATCH_STAIRS});
        this.extendAndAppend(TropicraftTags.Blocks.DOORS, TropicraftTags.Blocks.WOODEN_DOORS, (TagKey<Block>)BlockTags.f_13103_, new Supplier[]{TropicraftBlocks.BAMBOO_DOOR, TropicraftBlocks.THATCH_DOOR});
        this.extendAndAppend(TropicraftTags.Blocks.TRAPDOORS, TropicraftTags.Blocks.WOODEN_TRAPDOORS, (TagKey<Block>)BlockTags.f_13036_, new Supplier[]{TropicraftBlocks.BAMBOO_TRAPDOOR, TropicraftBlocks.THATCH_TRAPDOOR});
        this.extendAndAppend(TropicraftTags.Blocks.FENCES, TropicraftTags.Blocks.WOODEN_FENCES, (TagKey<Block>)BlockTags.f_13039_, new Supplier[]{TropicraftBlocks.BAMBOO_FENCE, TropicraftBlocks.CHUNK_FENCE, TropicraftBlocks.THATCH_FENCE});
        this.createAndAppend(TropicraftTags.Blocks.WALLS, (TagKey<Block>)BlockTags.f_13032_, new Supplier[]{TropicraftBlocks.CHUNK_WALL});
        this.createAndAppend(TropicraftTags.Blocks.CLIMBABLE, (TagKey<Block>)BlockTags.f_13082_, new Supplier[]{TropicraftBlocks.BAMBOO_LADDER});
        this.createAndAppend(TropicraftTags.Blocks.FLOWER_POTS, (TagKey<Block>)BlockTags.f_13045_, (Supplier[])Stream.concat(TropicraftBlocks.BAMBOO_POTTED_TROPICS_PLANTS.stream(), Stream.concat(TropicraftBlocks.BAMBOO_POTTED_VANILLA_PLANTS.stream(), TropicraftBlocks.VANILLA_POTTED_TROPICS_PLANTS.stream())).toArray(RegistryObject[]::new));
        this.appendToTag((TagKey<Block>)BlockTags.f_144281_, TropicraftTags.Blocks.LEAVES);
        this.createTag((TagKey<Block>)BlockTags.f_144280_, new Supplier[]{TropicraftBlocks.MAHOGANY_PLANKS, TropicraftBlocks.MAHOGANY_LOG, TropicraftBlocks.MAHOGANY_STAIRS, TropicraftBlocks.MAHOGANY_SLAB, TropicraftBlocks.MAHOGANY_FENCE, TropicraftBlocks.MAHOGANY_DOOR, TropicraftBlocks.MAHOGANY_TRAPDOOR, TropicraftBlocks.MAHOGANY_BOARDWALK, TropicraftBlocks.MAHOGANY_FENCE_GATE, TropicraftBlocks.MAHOGANY_WOOD, TropicraftBlocks.BLACK_MANGROVE_ROOTS, TropicraftBlocks.RED_MANGROVE_ROOTS, TropicraftBlocks.LIGHT_MANGROVE_ROOTS, TropicraftBlocks.BLACK_MANGROVE_LOG, TropicraftBlocks.RED_MANGROVE_LOG, TropicraftBlocks.LIGHT_MANGROVE_LOG, TropicraftBlocks.STRIPPED_MANGROVE_LOG, TropicraftBlocks.BLACK_MANGROVE_WOOD, TropicraftBlocks.RED_MANGROVE_WOOD, TropicraftBlocks.LIGHT_MANGROVE_WOOD, TropicraftBlocks.STRIPPED_MANGROVE_WOOD, TropicraftBlocks.MANGROVE_PLANKS, TropicraftBlocks.MANGROVE_STAIRS, TropicraftBlocks.MANGROVE_SLAB, TropicraftBlocks.MANGROVE_FENCE, TropicraftBlocks.MANGROVE_DOOR, TropicraftBlocks.MANGROVE_TRAPDOOR, TropicraftBlocks.MANGROVE_BOARDWALK, TropicraftBlocks.MANGROVE_FENCE_GATE, TropicraftBlocks.PALM_PLANKS, TropicraftBlocks.PALM_LOG, TropicraftBlocks.PALM_STAIRS, TropicraftBlocks.PALM_SLAB, TropicraftBlocks.PALM_FENCE, TropicraftBlocks.PALM_DOOR, TropicraftBlocks.PALM_TRAPDOOR, TropicraftBlocks.PALM_BOARDWALK, TropicraftBlocks.PALM_FENCE_GATE, TropicraftBlocks.PALM_WOOD, TropicraftBlocks.PAPAYA_LOG, TropicraftBlocks.PAPAYA_WOOD, TropicraftBlocks.BAMBOO_BOARDWALK, TropicraftBlocks.BAMBOO_LADDER, TropicraftBlocks.COCONUT});
        this.createTag((TagKey<Block>)BlockTags.f_144283_, new Supplier[]{TropicraftBlocks.MUD, TropicraftBlocks.MUD_WITH_PIANGUAS, TropicraftBlocks.PURIFIED_SAND, TropicraftBlocks.CORAL_SAND, TropicraftBlocks.FOAMY_SAND, TropicraftBlocks.MINERAL_SAND, TropicraftBlocks.VOLCANIC_SAND});
        this.createTag((TagKey<Block>)BlockTags.f_144282_, new Supplier[]{TropicraftBlocks.AZURITE_ORE, TropicraftBlocks.ZIRCON_ORE, TropicraftBlocks.EUDIALYTE_ORE, TropicraftBlocks.SHAKA_ORE, TropicraftBlocks.MANGANESE_ORE, TropicraftBlocks.AZURITE_BLOCK, TropicraftBlocks.ZIRCON_BLOCK, TropicraftBlocks.EUDIALYTE_BLOCK, TropicraftBlocks.SHAKA_BLOCK, TropicraftBlocks.MANGANESE_BLOCK});
        this.createTag((TagKey<Block>)BlockTags.f_144285_, new Supplier[]{TropicraftBlocks.AZURITE_ORE, TropicraftBlocks.ZIRCON_ORE, TropicraftBlocks.EUDIALYTE_ORE, TropicraftBlocks.SHAKA_ORE, TropicraftBlocks.MANGANESE_ORE, TropicraftBlocks.AZURITE_BLOCK, TropicraftBlocks.ZIRCON_BLOCK, TropicraftBlocks.EUDIALYTE_BLOCK, TropicraftBlocks.SHAKA_BLOCK, TropicraftBlocks.MANGANESE_BLOCK});
        this.createTag(TropicraftTags.Blocks.BONGOS, new Supplier[]{TropicraftBlocks.SMALL_BONGO_DRUM, TropicraftBlocks.MEDIUM_BONGO_DRUM, TropicraftBlocks.LARGE_BONGO_DRUM});
    }

    @SafeVarargs
    private final <T> T[] resolveAll(IntFunction<T[]> creator, Supplier<? extends T> ... suppliers) {
        return Arrays.stream(suppliers).map(Supplier::get).toArray(creator);
    }

    @SafeVarargs
    private final void createTag(TagKey<Block> tag, Supplier<? extends Block> ... blocks) {
        this.m_206424_(tag).m_126584_((Object[])this.resolveAll(Block[]::new, blocks));
    }

    @SafeVarargs
    private final void appendToTag(TagKey<Block> tag, TagKey<Block> ... toAppend) {
        this.m_206424_(tag).addTags(toAppend);
    }

    @SafeVarargs
    private final void extendTag(TagKey<Block> tag, TagKey<Block> toExtend, Supplier<? extends Block> ... blocks) {
        this.m_206424_(tag).m_206428_(toExtend).m_126584_((Object[])this.resolveAll(Block[]::new, blocks));
    }

    @SafeVarargs
    private final void createAndAppend(TagKey<Block> tag, TagKey<Block> to, Supplier<? extends Block> ... blocks) {
        this.createTag(tag, blocks);
        this.appendToTag(to, tag);
    }

    @SafeVarargs
    private final void extendAndAppend(TagKey<Block> tag, TagKey<Block> toExtend, TagKey<Block> to, Supplier<? extends Block> ... blocks) {
        this.extendTag(tag, toExtend, blocks);
        this.appendToTag(to, tag);
    }

    public String m_6055_() {
        return "Tropicraft Block Tags";
    }
}

