/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.data;

import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropicraftItemTagsProvider
extends ItemTagsProvider {
    public TropicraftItemTagsProvider(DataGenerator generatorIn, BlockTagsProvider blockTags, ExistingFileHelper existingFileHelper) {
        super(generatorIn, blockTags, "tropicraft", existingFileHelper);
    }

    protected void m_6577_() {
        this.addItemsToTag(TropicraftTags.Items.AZURITE_ORE, new Supplier[]{TropicraftBlocks.AZURITE_ORE});
        this.addItemsToTag(TropicraftTags.Items.EUDIALYTE_ORE, new Supplier[]{TropicraftBlocks.EUDIALYTE_ORE});
        this.addItemsToTag(TropicraftTags.Items.ZIRCON_ORE, new Supplier[]{TropicraftBlocks.ZIRCON_ORE});
        this.addItemsToTag(TropicraftTags.Items.MANGANESE_ORE, new Supplier[]{TropicraftBlocks.MANGANESE_ORE});
        this.addItemsToTag(TropicraftTags.Items.SHAKA_ORE, new Supplier[]{TropicraftBlocks.SHAKA_ORE});
        this.appendToTag((TagKey<Item>)Tags.Items.ORES, TropicraftTags.Items.AZURITE_ORE, TropicraftTags.Items.EUDIALYTE_ORE, TropicraftTags.Items.ZIRCON_ORE, TropicraftTags.Items.MANGANESE_ORE, TropicraftTags.Items.SHAKA_ORE);
        this.addItemsToTag(TropicraftTags.Items.AZURITE_GEM, new Supplier[]{TropicraftItems.AZURITE});
        this.addItemsToTag(TropicraftTags.Items.EUDIALYTE_GEM, new Supplier[]{TropicraftItems.EUDIALYTE});
        this.addItemsToTag(TropicraftTags.Items.ZIRCON_GEM, new Supplier[]{TropicraftItems.ZIRCON});
        this.addItemsToTag(TropicraftTags.Items.MANGANESE_INGOT, new Supplier[]{TropicraftItems.MANGANESE});
        this.addItemsToTag(TropicraftTags.Items.SHAKA_INGOT, new Supplier[]{TropicraftItems.SHAKA});
        this.addItemsToTag(TropicraftTags.Items.ZIRCONIUM_GEM, new Supplier[]{TropicraftItems.ZIRCONIUM});
        this.appendToTag((TagKey<Item>)Tags.Items.GEMS, TropicraftTags.Items.AZURITE_GEM, TropicraftTags.Items.EUDIALYTE_GEM, TropicraftTags.Items.ZIRCON_GEM, TropicraftTags.Items.ZIRCONIUM_GEM);
        this.appendToTag((TagKey<Item>)Tags.Items.INGOTS, TropicraftTags.Items.MANGANESE_INGOT, TropicraftTags.Items.SHAKA_INGOT);
        this.addItemsToTag(TropicraftTags.Items.MANGROVE_LOGS, new Supplier[]{TropicraftBlocks.LIGHT_MANGROVE_LOG, TropicraftBlocks.RED_MANGROVE_LOG, TropicraftBlocks.BLACK_MANGROVE_LOG});
        this.addItemsToTag(TropicraftTags.Items.LEATHER, new Supplier[]{TropicraftItems.IGUANA_LEATHER});
        this.appendToTag((TagKey<Item>)Tags.Items.LEATHER, TropicraftTags.Items.LEATHER);
        this.addItemsToTag((TagKey<Item>)Tags.Items.RODS_WOODEN, new Supplier[]{TropicraftItems.BAMBOO_STICK});
        this.addItemsToTag((TagKey<Item>)ItemTags.f_13156_, new Supplier[]{TropicraftItems.RAW_FISH, TropicraftItems.COOKED_FISH});
        this.addItemsToTag(TropicraftTags.Items.SHELLS, new Supplier[]{TropicraftItems.SOLONOX_SHELL, TropicraftItems.FROX_CONCH, TropicraftItems.PAB_SHELL, TropicraftItems.RUBE_NAUTILUS, TropicraftItems.STARFISH, TropicraftItems.TURTLE_SHELL});
        this.addItemsToTag(TropicraftTags.Items.SWORDS, new Supplier[]{Items.f_42420_.delegate, Items.f_42425_.delegate, Items.f_42383_.delegate, Items.f_42430_.delegate, Items.f_42388_.delegate, Items.f_42393_.delegate, TropicraftItems.EUDIALYTE_SWORD, TropicraftItems.ZIRCON_SWORD, TropicraftItems.ZIRCONIUM_SWORD});
        for (RegistryObject registryObject : TropicraftItems.ASHEN_MASKS.values()) {
            this.addItemsToTag(TropicraftTags.Items.ASHEN_MASKS, new Supplier[]{registryObject});
        }
        for (RegistryObject registryObject : TropicraftBlocks.FLOWERS.values()) {
            this.addItemsToTag((TagKey<Item>)ItemTags.f_13149_, new Supplier[]{registryObject});
        }
        this.addItemsToTag(TropicraftTags.Items.FRUITS, new ItemLike[]{Items.f_42410_});
        this.addItemsToTag(TropicraftTags.Items.FRUITS, new Supplier[]{TropicraftItems.GRAPEFRUIT, TropicraftItems.LEMON, TropicraftItems.LIME, TropicraftItems.ORANGE});
        this.addItemsToTag(TropicraftTags.Items.MEATS, new ItemLike[]{Items.f_42579_, Items.f_42485_, Items.f_42581_, Items.f_42697_, Items.f_42658_});
        for (RegistryObject registryObject : TropicraftItems.MUSIC_DISCS.values()) {
            this.addItemsToTag(TropicraftTags.Items.MUSIC_DISCS, new Supplier[]{registryObject});
        }
        this.appendToTag((TagKey<Item>)ItemTags.f_13158_, TropicraftTags.Items.MUSIC_DISCS);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.SAND, TropicraftTags.Items.SAND, (TagKey<Item>)ItemTags.f_13137_);
        this.m_206421_(TropicraftTags.Blocks.MUD, TropicraftTags.Items.MUD);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.SAPLINGS, TropicraftTags.Items.SAPLINGS, (TagKey<Item>)ItemTags.f_13180_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.LEAVES, TropicraftTags.Items.LEAVES, (TagKey<Item>)ItemTags.f_13143_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.SMALL_FLOWERS, TropicraftTags.Items.SMALL_FLOWERS, (TagKey<Item>)ItemTags.f_13145_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.LOGS, TropicraftTags.Items.LOGS, (TagKey<Item>)ItemTags.f_13182_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.PLANKS, TropicraftTags.Items.PLANKS, (TagKey<Item>)ItemTags.f_13168_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.WOODEN_SLABS, TropicraftTags.Items.WOODEN_SLABS, (TagKey<Item>)ItemTags.f_13175_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.WOODEN_STAIRS, TropicraftTags.Items.WOODEN_STAIRS, (TagKey<Item>)ItemTags.f_13174_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.WOODEN_DOORS, TropicraftTags.Items.WOODEN_DOORS, (TagKey<Item>)ItemTags.f_13173_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.WOODEN_TRAPDOORS, TropicraftTags.Items.WOODEN_TRAPDOORS, (TagKey<Item>)ItemTags.f_13178_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.WOODEN_FENCES, TropicraftTags.Items.WOODEN_FENCES, (TagKey<Item>)ItemTags.f_13176_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.SLABS, TropicraftTags.Items.SLABS, (TagKey<Item>)ItemTags.f_13139_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.STAIRS, TropicraftTags.Items.STAIRS, (TagKey<Item>)ItemTags.f_13138_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.DOORS, TropicraftTags.Items.DOORS, (TagKey<Item>)ItemTags.f_13179_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.TRAPDOORS, TropicraftTags.Items.TRAPDOORS, (TagKey<Item>)ItemTags.f_13144_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.FENCES, TropicraftTags.Items.FENCES, (TagKey<Item>)ItemTags.f_13147_);
        this.copyBlockAndAppendToTag(TropicraftTags.Blocks.WALLS, TropicraftTags.Items.WALLS, (TagKey<Item>)ItemTags.f_13140_);
    }

    @SafeVarargs
    private final void addItemsToTag(TagKey<Item> tag, Supplier<? extends ItemLike> ... items) {
        this.m_206424_(tag).m_126584_((Object[])((Item[])Arrays.stream(items).map(Supplier::get).map(ItemLike::m_5456_).toArray(Item[]::new)));
    }

    private void addItemsToTag(TagKey<Item> tag, ItemLike ... items) {
        this.m_206424_(tag).m_126584_((Object[])((Item[])Arrays.stream(items).map(ItemLike::m_5456_).toArray(Item[]::new)));
    }

    @SafeVarargs
    private final void appendToTag(TagKey<Item> tag, TagKey<Item> ... toAppend) {
        this.m_206424_(tag).addTags(toAppend);
    }

    private void copyBlockAndAppendToTag(TagKey<Block> blockTag, TagKey<Item> itemTag, TagKey<Item> toAddTo) {
        this.m_206421_(blockTag, itemTag);
        this.appendToTag(toAddTo, itemTag);
    }

    public String m_6055_() {
        return "Tropicraft Item Tags";
    }
}

