/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.block.PapayaBlock;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.data.loot.MatchSwordCondition;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.neutral.TreeFrogEntity;
import net.tropicraft.core.common.item.RecordMusic;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropicraftLootTableProvider
extends LootTableProvider {
    public TropicraftLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(Entities::new, (Object)LootContextParamSets.f_81415_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationresults) {
    }

    private static class Blocks
    extends BlockLoot {
        private static final float[] FRUIT_SAPLING_RATES = new float[]{0.1f, 0.125f, 0.16666667f, 0.2f};
        private static final float[] SAPLING_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        private static final float[] RARE_SAPLING_RATES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};

        private Blocks() {
        }

        protected void addTables() {
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK);
            this.dropsOreItem((Supplier<? extends Block>)TropicraftBlocks.AZURITE_ORE, (Supplier<? extends ItemLike>)TropicraftItems.AZURITE);
            this.dropsOreItem((Supplier<? extends Block>)TropicraftBlocks.EUDIALYTE_ORE, (Supplier<? extends ItemLike>)TropicraftItems.EUDIALYTE);
            this.dropsOreItem((Supplier<? extends Block>)TropicraftBlocks.ZIRCON_ORE, (Supplier<? extends ItemLike>)TropicraftItems.ZIRCON);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.SHAKA_ORE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGANESE_ORE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.AZURITE_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.EUDIALYTE_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.ZIRCON_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.ZIRCONIUM_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.SHAKA_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGANESE_BLOCK);
            TropicraftBlocks.FLOWERS.values().forEach(this::dropsSelf);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PURIFIED_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PACKED_PURIFIED_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CORAL_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.FOAMY_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.VOLCANIC_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MINERAL_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MUD);
            this.m_124165_((Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get(), (LootTable.Builder)Blocks.m_124131_((ItemLike)((ItemLike)TropicraftBlocks.MUD_WITH_PIANGUAS.get()), (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)TropicraftBlocks.MUD_WITH_PIANGUAS.get())).m_6509_(f_124062_)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)TropicraftBlocks.MUD.get()))))).m_79161_(LootPool.m_79043_().m_6509_(f_124063_).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)TropicraftItems.PIANGUAS.get())).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))))));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_BUNDLE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_BUNDLE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_PLANKS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_PLANKS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_ROOTS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_ROOTS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_ROOTS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.STRIPPED_MANGROVE_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.STRIPPED_MANGROVE_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_PLANKS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_STAIRS_FUZZY);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.BAMBOO_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.THATCH_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.CHUNK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.PALM_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.MAHOGANY_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.MANGROVE_SLAB);
            this.leaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.MAHOGANY_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.MAHOGANY_SAPLING, RARE_SAPLING_RATES);
            this.leaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.PALM_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.PALM_SAPLING, SAPLING_RATES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.KAPOK_LEAVES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.FRUIT_LEAVES);
            this.fruitLeaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.GRAPEFRUIT_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.GRAPEFRUIT_SAPLING, (Supplier<? extends ItemLike>)TropicraftItems.GRAPEFRUIT);
            this.fruitLeaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.LEMON_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.LEMON_SAPLING, (Supplier<? extends ItemLike>)TropicraftItems.LEMON);
            this.fruitLeaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.LIME_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.LIME_SAPLING, (Supplier<? extends ItemLike>)TropicraftItems.LIME);
            this.fruitLeaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.ORANGE_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.ORANGE_SAPLING, (Supplier<? extends ItemLike>)TropicraftItems.ORANGE);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.RED_MANGROVE_LEAVES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.TALL_MANGROVE_LEAVES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.TEA_MANGROVE_LEAVES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.BLACK_MANGROVE_LEAVES);
            this.leaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.PAPAYA_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.PAPAYA_SAPLING, SAPLING_RATES);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.GRAPEFRUIT_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LEMON_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LIME_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.ORANGE_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_PROPAGULE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.TALL_MANGROVE_PROPAGULE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.TEA_MANGROVE_PROPAGULE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_PROPAGULE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK_WALL);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_DOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.THATCH_DOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_DOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_DOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_DOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_TRAPDOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_TRAPDOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_TRAPDOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_TRAPDOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_TRAPDOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.IRIS);
            this.m_124175_((Block)TropicraftBlocks.PINEAPPLE.get(), b -> Blocks.droppingChunks(b, TropicraftItems.PINEAPPLE_CUBES, (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER))));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.REEDS);
            this.m_124175_((Block)TropicraftBlocks.PAPAYA.get(), b -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)Blocks.m_124131_((ItemLike)b, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((PapayaBlock)((Object)((Object)TropicraftBlocks.PAPAYA.get()))).m_5456_()).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PapayaBlock.AGE, 1))))))));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.SMALL_BONGO_DRUM);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MEDIUM_BONGO_DRUM);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LARGE_BONGO_DRUM);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_LADDER);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_BOARDWALK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_BOARDWALK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_BOARDWALK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_BOARDWALK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_CHEST);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.SIFTER);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.DRINK_MIXER);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.AIR_COMPRESSOR);
            this.m_124175_((Block)TropicraftBlocks.TIKI_TORCH.get(), b -> Blocks.m_124161_((Block)b, TikiTorchBlock.SECTION, (Comparable)((Object)TikiTorchBlock.TorchSection.UPPER)));
            this.m_124175_((Block)TropicraftBlocks.COCONUT.get(), b -> Blocks.droppingChunks(b, TropicraftItems.COCONUT_CHUNK));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FLOWER_POT);
            TropicraftBlocks.ALL_POTTED_PLANTS.forEach(ro -> this.m_124175_((Block)ro.get(), b -> Blocks.droppingFlowerPotAndFlower((FlowerPotBlock)b)));
            this.m_124165_((Block)TropicraftBlocks.COFFEE_BUSH.get(), Blocks.dropNumberOfItems((Block)TropicraftBlocks.COFFEE_BUSH.get(), TropicraftItems.RAW_COFFEE_BEAN, 1, 3));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.GOLDEN_LEATHER_FERN);
            this.dropsOther((Supplier<? extends Block>)TropicraftBlocks.TALL_GOLDEN_LEATHER_FERN, (Supplier<? extends ItemLike>)TropicraftBlocks.GOLDEN_LEATHER_FERN);
            this.dropsOther((Supplier<? extends Block>)TropicraftBlocks.LARGE_GOLDEN_LEATHER_FERN, (Supplier<? extends ItemLike>)TropicraftBlocks.GOLDEN_LEATHER_FERN);
        }

        private void dropsSelf(Supplier<? extends Block> block) {
            this.m_124288_(block.get());
        }

        private void dropsOther(Supplier<? extends Block> block, Supplier<? extends ItemLike> drops) {
            this.m_124147_(block.get(), drops.get());
        }

        private void dropsOreItem(Supplier<? extends Block> block, Supplier<? extends ItemLike> item) {
            this.m_124175_(block.get(), b -> Blocks.m_124139_((Block)b, (Item)((ItemLike)item.get()).m_5456_()));
        }

        private void slab(Supplier<? extends SlabBlock> block) {
            this.m_124175_((Block)block.get(), x$0 -> BlockLoot.m_124290_((Block)x$0));
        }

        private void leaves(Supplier<? extends LeavesBlock> block, Supplier<? extends SaplingBlock> sapling, float[] rates) {
            this.m_124175_((Block)block.get(), b -> Blocks.m_124157_((Block)b, (Block)((Block)sapling.get()), (float[])rates));
        }

        private void leavesNoSapling(Supplier<? extends LeavesBlock> block) {
            this.m_124175_((Block)block.get(), Blocks::droppingWithSticks);
        }

        private void fruitLeaves(Supplier<? extends LeavesBlock> block, Supplier<? extends SaplingBlock> sapling, Supplier<? extends ItemLike> fruit) {
            this.m_124175_((Block)block.get(), b -> Blocks.droppingWithChancesSticksAndFruit(b, (Block)sapling.get(), (ItemLike)fruit.get(), FRUIT_SAPLING_RATES));
        }

        protected static LootTable.Builder onlyWithSilkTouchOrShears(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_6509_(f_124065_).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)));
        }

        protected static LootTable.Builder droppingWithSticks(Block block) {
            return Blocks.onlyWithSilkTouchOrShears(block).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(f_124066_).m_79076_(((LootPoolSingletonContainer.Builder)Blocks.m_124131_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }

        protected static LootTable.Builder droppingWithChancesSticksAndFruit(Block block, Block sapling, ItemLike fruit, float[] chances) {
            return Blocks.m_124157_((Block)block, (Block)sapling, (float[])chances).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(f_124066_).m_79076_((LootPoolEntryContainer.Builder)Blocks.m_124131_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)fruit))));
        }

        private void doubleBlock(Supplier<? extends Block> block) {
            this.m_124175_(block.get(), b -> Blocks.m_124161_((Block)b, (Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
        }

        protected static LootTable.Builder droppingFlowerPotAndFlower(FlowerPotBlock fullPot) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)Blocks.m_124134_((ItemLike)fullPot.getEmptyPot(), (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)fullPot.getEmptyPot())))).m_79161_((LootPool.Builder)Blocks.m_124134_((ItemLike)fullPot.m_53560_(), (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)fullPot.m_53560_()))));
        }

        private static LootPool.Builder droppingChunksPool(Block block, Supplier<? extends ItemLike> chunk) {
            return LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)chunk.get()).m_6509_(MatchSwordCondition.builder())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_7170_((LootPoolEntryContainer.Builder)Blocks.m_124134_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)block))));
        }

        protected static LootTable.Builder droppingChunks(Block block, Supplier<? extends ItemLike> chunk) {
            return LootTable.m_79147_().m_79161_(Blocks.droppingChunksPool(block, chunk));
        }

        protected static LootTable.Builder droppingChunks(Block block, Supplier<? extends ItemLike> chunk, LootItemCondition.Builder condition) {
            return LootTable.m_79147_().m_79161_(Blocks.droppingChunksPool(block, chunk).m_6509_(condition));
        }

        private static LootTable.Builder dropNumberOfItems(Block block, Supplier<? extends ItemLike> drop, int minDrops, int maxDrops) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)Blocks.m_124134_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)minDrops, (float)maxDrops)))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return TropicraftBlocks.BLOCKS.getEntries().stream().map(Supplier::get).filter(block -> {
                ResourceLocation lootTable = block.m_60589_();
                return lootTable != null && lootTable.m_135827_().equals("tropicraft");
            }).collect(Collectors.toList());
        }
    }

    private static class Entities
    extends EntityLoot {
        private Entities() {
        }

        protected void addTables() {
            this.m_124371_((EntityType)TropicraftEntities.TROPI_CREEPER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)((RegistryObject)TropicraftItems.MUSIC_DISCS.get((Object)RecordMusic.EASTERN_ISLES)).get()))).m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_204077_(EntityTypeTags.f_13120_)))));
            this.dropItemsWithEnchantBonus(TropicraftEntities.IGUANA, TropicraftItems.IGUANA_LEATHER, TropicraftItems.SCALE, (NumberProvider)ConstantValue.m_165692_((float)3.0f));
            this.noDrops(TropicraftEntities.TROPI_SKELLY);
            this.dropItemsWithEnchantBonus(TropicraftEntities.EIH, ((Block)TropicraftBlocks.CHUNK.get()).m_5456_(), (NumberProvider)ConstantValue.m_165692_((float)3.0f));
            this.dropItem(TropicraftEntities.SEA_TURTLE, TropicraftItems.TURTLE_SHELL);
            this.dropItemsWithEnchantBonus(TropicraftEntities.MARLIN, TropicraftItems.FRESH_MARLIN, (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f));
            this.noDrops(TropicraftEntities.FAILGULL);
            this.dropItemsWithEnchantBonus(TropicraftEntities.DOLPHIN, TropicraftItems.TROPICAL_FERTILIZER, (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f));
            this.noDrops(TropicraftEntities.SEAHORSE);
            this.m_124371_((EntityType)TropicraftEntities.TREE_FROG.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(new EntityFlagsPredicate(null, null, null, null, Boolean.valueOf(false))).m_36654_(new NbtPredicate((CompoundTag)Util.m_137469_((Object)new CompoundTag(), c -> c.m_128405_("Type", TreeFrogEntity.Type.GREEN.ordinal())))))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)TropicraftItems.POISON_FROG_SKIN.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)TropicraftItems.FROG_LEG.get())))));
            this.dropItem(TropicraftEntities.SEA_URCHIN, TropicraftItems.SEA_URCHIN_ROE);
            this.noDrops(TropicraftEntities.SEA_URCHIN_EGG_ENTITY);
            this.dropItem(TropicraftEntities.STARFISH, TropicraftItems.STARFISH);
            this.noDrops(TropicraftEntities.STARFISH_EGG);
            this.noDrops(TropicraftEntities.V_MONKEY);
            this.noDrops(TropicraftEntities.RIVER_SARDINE);
            this.dropItem(TropicraftEntities.RIVER_SARDINE, TropicraftItems.RAW_FISH);
            this.dropItem(TropicraftEntities.PIRANHA, TropicraftItems.RAW_FISH);
            this.dropItem(TropicraftEntities.TROPICAL_FISH, TropicraftItems.RAW_FISH);
            this.dropItem(TropicraftEntities.EAGLE_RAY, TropicraftItems.RAW_RAY);
            this.noDrops(TropicraftEntities.TROPI_SPIDER);
            this.noDrops(TropicraftEntities.TROPI_SPIDER_EGG);
            this.noDrops(TropicraftEntities.ASHEN);
            this.dropItemsWithEnchantBonus(TropicraftEntities.HAMMERHEAD, TropicraftItems.TROPICAL_FERTILIZER, (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f));
            this.noDrops(TropicraftEntities.SEA_TURTLE_EGG);
            this.noDrops(TropicraftEntities.TROPI_BEE);
            this.noDrops(TropicraftEntities.COWKTAIL);
            this.dropItemsWithEnchantBonus(TropicraftEntities.MAN_O_WAR, Items.f_42518_, (NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)4.0f));
            this.noDrops(TropicraftEntities.TAPIR);
            this.noDrops(TropicraftEntities.JAGUAR);
            this.noDrops(TropicraftEntities.BROWN_BASILISK_LIZARD);
            this.noDrops(TropicraftEntities.GREEN_BASILISK_LIZARD);
            this.noDrops(TropicraftEntities.HUMMINGBIRD);
            this.noDrops(TropicraftEntities.FIDDLER_CRAB);
            this.noDrops(TropicraftEntities.SPIDER_MONKEY);
            this.noDrops(TropicraftEntities.WHITE_LIPPED_PECCARY);
            this.dropItem(TropicraftEntities.CUBERA, TropicraftItems.RAW_FISH);
        }

        public <T extends LivingEntity> void dropItemsWithEnchantBonus(RegistryObject<EntityType<T>> entity, RegistryObject<Item> loot, RegistryObject<Item> multiLoot, NumberProvider range) {
            this.m_124371_((EntityType)entity.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)loot.get())))).m_79161_(LootPool.m_79043_().m_165133_(range).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)multiLoot.get())).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)0.33333334f))))));
        }

        public <T extends LivingEntity> void dropItem(RegistryObject<EntityType<T>> entity, RegistryObject<Item> loot) {
            this.m_124371_((EntityType)entity.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)loot.get())))));
        }

        public <T extends LivingEntity> void dropItemsWithEnchantBonus(RegistryObject<EntityType<T>> entity, RegistryObject<Item> loot, NumberProvider range) {
            this.dropItemsWithEnchantBonus(entity, (Item)loot.get(), range);
        }

        public <T extends LivingEntity> void dropItemsWithEnchantBonus(RegistryObject<EntityType<T>> entity, Item loot, NumberProvider range) {
            this.m_124371_((EntityType)entity.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_(range).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)loot).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)0.33333334f))))));
        }

        public <T extends LivingEntity> void noDrops(RegistryObject<EntityType<T>> entity) {
            this.m_124371_((EntityType)entity.get(), LootTable.m_79147_());
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return TropicraftEntities.ENTITIES.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

