/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.data;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.item.TropicraftItems;
import org.apache.commons.lang3.StringUtils;

public class TropicraftRecipeProvider
extends RecipeProvider {
    public TropicraftRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.ore(TropicraftTags.Items.AZURITE_ORE, (Supplier)TropicraftItems.AZURITE, 0.3f, consumer);
        this.ore(TropicraftTags.Items.EUDIALYTE_ORE, (Supplier)TropicraftItems.EUDIALYTE, 0.5f, consumer);
        this.ore(TropicraftTags.Items.ZIRCON_ORE, (Supplier)TropicraftItems.ZIRCON, 0.5f, consumer);
        this.ore(TropicraftTags.Items.MANGANESE_ORE, (Supplier)TropicraftItems.MANGANESE, 0.5f, consumer);
        this.ore(TropicraftTags.Items.SHAKA_ORE, (Supplier)TropicraftItems.SHAKA, 0.7f, consumer);
        this.storage((Supplier)TropicraftItems.AZURITE, (Supplier)TropicraftBlocks.AZURITE_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftBlocks.EUDIALYTE_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftBlocks.ZIRCON_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftBlocks.ZIRCONIUM_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.MANGANESE, (Supplier)TropicraftBlocks.MANGANESE_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.SHAKA, (Supplier)TropicraftBlocks.SHAKA_BLOCK, consumer);
        this.pickaxe((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_PICKAXE, consumer);
        this.pickaxe((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_PICKAXE, consumer);
        this.pickaxe((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_PICKAXE, consumer);
        this.axe((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_AXE, consumer);
        this.axe((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_AXE, consumer);
        this.axe((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_AXE, consumer);
        this.shovel((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_SHOVEL, consumer);
        this.shovel((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_SHOVEL, consumer);
        this.shovel((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_SHOVEL, consumer);
        this.hoe((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_HOE, consumer);
        this.hoe((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_HOE, consumer);
        this.hoe((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_HOE, consumer);
        this.sword((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_SWORD, consumer);
        this.sword((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_SWORD, consumer);
        this.sword((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_SWORD, consumer);
        this.helmet((Supplier)TropicraftItems.SCALE, (Supplier)TropicraftItems.SCALE_HELMET, consumer);
        this.chestplate((Supplier)TropicraftItems.SCALE, (Supplier)TropicraftItems.SCALE_CHESTPLATE, consumer);
        this.leggings((Supplier)TropicraftItems.SCALE, (Supplier)TropicraftItems.SCALE_LEGGINGS, consumer);
        this.boots((Supplier)TropicraftItems.SCALE, (Supplier)TropicraftItems.SCALE_BOOTS, consumer);
        for (DyeColor color : DyeColor.values()) {
            ItemLike wool = (ItemLike)Sheep.f_29800_.get(color);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftItems.UMBRELLAS.get(color).get())).m_126130_("WWW").m_126130_(" B ").m_126130_(" B ").m_142409_("tropicraft:umbrellas").m_126127_(Character.valueOf('W'), wool).m_126127_(Character.valueOf('B'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_142284_("has_" + color.m_7912_() + "_wool", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)wool)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftItems.CHAIRS.get(color).get())).m_126130_("BWB").m_126130_("BWB").m_126130_("BWB").m_142409_("tropicraft:chairs").m_126127_(Character.valueOf('W'), wool).m_126127_(Character.valueOf('B'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_142284_("has_" + color.m_7912_() + "_wool", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)wool)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftItems.BEACH_FLOATS.get(color).get())).m_126130_("WWW").m_126130_("BBB").m_142409_("tropicraft:beach_floats").m_126127_(Character.valueOf('W'), wool).m_126127_(Character.valueOf('B'), (ItemLike)Blocks.f_50571_).m_142284_("has_" + color.m_7912_() + "_wool", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)wool)).m_176498_(consumer);
        }
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_STICK.get())).m_126130_("X").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41911_).m_142284_("has_bamboo", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_142700_(consumer, new ResourceLocation("stick_from_bamboo_item"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftBlocks.PACKED_PURIFIED_SAND.get())).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftBlocks.PURIFIED_SAND.get()).m_142284_("has_purified_sand", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftBlocks.PURIFIED_SAND.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_SPEAR.get())).m_126130_("X ").m_126130_(" X").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_142284_("has_bamboo_stick", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_STICK.get()))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)TropicraftItems.RAW_COFFEE_BEAN.get())).m_126209_((ItemLike)TropicraftItems.COFFEE_BERRY.get()).m_142284_("has_coffee_bean", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.COFFEE_BERRY.get()))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)TropicraftItems.ZIRCONIUM.get())).m_126211_((ItemLike)TropicraftItems.AZURITE.get(), 2).m_126211_((ItemLike)TropicraftItems.ZIRCON.get(), 2).m_142284_("has_zircon", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.ZIRCON.get()))).m_142284_("has_azurite", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.AZURITE.get()))).m_176498_(consumer);
        this.food((Supplier)TropicraftItems.RAW_COFFEE_BEAN, (Supplier)TropicraftItems.ROASTED_COFFEE_BEAN, 0.1f, consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_MUG.get())).m_126130_("X X").m_126130_("X X").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41911_).m_142284_("has_bamboo", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
        this.food((Supplier)Items.f_41867_.delegate, (Supplier)TropicraftItems.TOASTED_NORI, 0.1f, consumer);
        this.food((Supplier)TropicraftItems.FRESH_MARLIN, (Supplier)TropicraftItems.SEARED_MARLIN, 0.15f, consumer);
        this.food((Supplier)TropicraftItems.RAW_RAY, (Supplier)TropicraftItems.COOKED_RAY, 0.15f, consumer);
        this.food((Supplier)TropicraftItems.FROG_LEG, (Supplier)TropicraftItems.COOKED_FROG_LEG, 0.1f, consumer);
        this.food((Supplier)TropicraftItems.RAW_FISH, (Supplier)TropicraftItems.COOKED_FISH, 0.1f, consumer);
        this.dye(TropicraftFlower.COMMELINA_DIFFUSA, (Supplier)Items.f_42538_.delegate, 1, 2, consumer);
        this.dye(TropicraftFlower.CANNA, (Supplier)Items.f_42539_.delegate, 1, 2, consumer);
        this.dye(TropicraftFlower.ORANGE_ANTHURIUM, (Supplier)Items.f_42536_.delegate, 1, 2, consumer);
        this.dye(TropicraftFlower.RED_ANTHURIUM, (Supplier)Items.f_42497_.delegate, 1, 2, consumer);
        this.dye(TropicraftFlower.DRACAENA, (Supplier)Items.f_42496_.delegate, 1, 2, consumer);
        this.dye((Supplier)TropicraftBlocks.IRIS, (Supplier)Items.f_42493_.delegate, 1, 4, consumer);
        this.singleItem((Supplier)Blocks.f_50571_.delegate, (Supplier)TropicraftBlocks.BAMBOO_BUNDLE, 9, 1, consumer);
        this.singleItem((Supplier)Blocks.f_50130_.delegate, (Supplier)TropicraftBlocks.THATCH_BUNDLE, 9, 1, consumer);
        this.planks((Supplier)TropicraftBlocks.MAHOGANY_LOG, (Supplier)TropicraftBlocks.MAHOGANY_PLANKS, consumer);
        this.planks((Supplier)TropicraftBlocks.PALM_LOG, (Supplier)TropicraftBlocks.PALM_PLANKS, consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)TropicraftBlocks.MANGROVE_PLANKS.get()), (int)4).m_206419_(TropicraftTags.Items.MANGROVE_LOGS).m_142284_("has_light_mangrove_log", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftBlocks.LIGHT_MANGROVE_LOG.get()))).m_142284_("has_red_mangrove_log", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftBlocks.RED_MANGROVE_LOG.get()))).m_142284_("has_black_mangrove_log", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftBlocks.BLACK_MANGROVE_LOG.get()))).m_176498_(consumer);
        this.bark((Supplier)TropicraftBlocks.MAHOGANY_LOG, (Supplier)TropicraftBlocks.MAHOGANY_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.PALM_LOG, (Supplier)TropicraftBlocks.PALM_WOOD, consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50002_).m_126209_((ItemLike)TropicraftBlocks.PAPAYA_LOG.get()).m_142284_("has_papaya_log", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftBlocks.PAPAYA_LOG.get()))).m_176498_(consumer);
        this.bark((Supplier)TropicraftBlocks.PAPAYA_LOG, (Supplier)TropicraftBlocks.PAPAYA_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.RED_MANGROVE_LOG, (Supplier)TropicraftBlocks.RED_MANGROVE_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.LIGHT_MANGROVE_LOG, (Supplier)TropicraftBlocks.LIGHT_MANGROVE_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.BLACK_MANGROVE_LOG, (Supplier)TropicraftBlocks.BLACK_MANGROVE_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.STRIPPED_MANGROVE_LOG, (Supplier)TropicraftBlocks.STRIPPED_MANGROVE_WOOD, consumer);
        this.stairs((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_STAIRS, "wooden_stairs", false, consumer);
        this.stairs((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_STAIRS, "wooden_stairs", false, consumer);
        this.stairs((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_STAIRS, "wooden_stairs", false, consumer);
        this.stairs((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_STAIRS, null, false, consumer);
        this.stairs((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_STAIRS, null, false, consumer);
        this.stairs((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_STAIRS, null, true, consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)TropicraftBlocks.THATCH_STAIRS_FUZZY.get()), (int)4).m_126130_("C  ").m_126130_("XC ").m_126130_("XXC").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftBlocks.THATCH_BUNDLE.get()).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41909_).m_142284_("has_thatch_bundle", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftBlocks.THATCH_BUNDLE.get()))).m_176498_(consumer);
        this.slab((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_SLAB, "wooden_slab", false, consumer);
        this.slab((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_SLAB, "wooden_slab", false, consumer);
        this.slab((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_SLAB, "wooden_slab", false, consumer);
        this.slab((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_SLAB, null, false, consumer);
        this.slab((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_SLAB, null, false, consumer);
        this.slab((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_SLAB, null, true, consumer);
        this.fence((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_FENCE, "wooden_fence", consumer);
        this.fence((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_FENCE, "wooden_fence", consumer);
        this.fence((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_FENCE, "wooden_fence", consumer);
        this.fence((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_FENCE, null, consumer);
        this.fence((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_FENCE, null, consumer);
        this.fence((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_FENCE, null, consumer);
        this.fenceGate((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_FENCE_GATE, "wooden_fence_gate", consumer);
        this.fenceGate((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_FENCE_GATE, "wooden_fence_gate", consumer);
        this.fenceGate((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_FENCE_GATE, "wooden_fence_gate", consumer);
        this.fenceGate((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_FENCE_GATE, null, consumer);
        this.fenceGate((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_FENCE_GATE, null, consumer);
        this.fenceGate((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_FENCE_GATE, null, consumer);
        this.wall((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_WALL, consumer);
        this.door((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_DOOR, "wooden_door", consumer);
        this.door((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_DOOR, "wooden_door", consumer);
        this.door((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_DOOR, "wooden_door", consumer);
        this.door((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_DOOR, null, consumer);
        this.door((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_DOOR, null, consumer);
        this.trapDoor((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_TRAPDOOR, "wooden_trapdoor", consumer);
        this.trapDoor((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_TRAPDOOR, "wooden_trapdoor", consumer);
        this.trapDoor((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_TRAPDOOR, "wooden_trapdoor", consumer);
        this.trapDoor((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_TRAPDOOR, null, consumer);
        this.trapDoor((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_TRAPDOOR, null, consumer);
        this.bongo((Supplier)TropicraftItems.IGUANA_LEATHER, (Supplier)TropicraftBlocks.MAHOGANY_PLANKS, 1, (Supplier)TropicraftBlocks.SMALL_BONGO_DRUM, consumer);
        this.bongo((Supplier)TropicraftItems.IGUANA_LEATHER, (Supplier)TropicraftBlocks.MAHOGANY_PLANKS, 2, (Supplier)TropicraftBlocks.MEDIUM_BONGO_DRUM, consumer);
        this.bongo((Supplier)TropicraftItems.IGUANA_LEATHER, (Supplier)TropicraftBlocks.MAHOGANY_PLANKS, 3, (Supplier)TropicraftBlocks.LARGE_BONGO_DRUM, consumer);
        this.goggles((Supplier)TropicraftItems.PINK_SCUBA_GOGGLES, (Supplier)Items.f_42489_.delegate, consumer);
        this.goggles((Supplier)TropicraftItems.YELLOW_SCUBA_GOGGLES, (Supplier)Items.f_42539_.delegate, consumer);
        this.flippers((Supplier)TropicraftItems.PINK_SCUBA_FLIPPERS, (Supplier)Items.f_42489_.delegate, consumer);
        this.flippers((Supplier)TropicraftItems.YELLOW_SCUBA_FLIPPERS, (Supplier)Items.f_42539_.delegate, consumer);
        this.harness((Supplier)TropicraftItems.PINK_SCUBA_HARNESS, (Supplier)Items.f_42489_.delegate, consumer);
        this.harness((Supplier)TropicraftItems.YELLOW_SCUBA_HARNESS, (Supplier)Items.f_42539_.delegate, consumer);
        this.ponyBottle((Supplier)TropicraftItems.PINK_PONY_BOTTLE, (Supplier)Items.f_42489_.delegate, consumer);
        this.ponyBottle((Supplier)TropicraftItems.YELLOW_PONY_BOTTLE, (Supplier)Items.f_42539_.delegate, consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)TropicraftItems.WATER_WAND.get()), (int)1).m_126130_("  X").m_126130_(" Y ").m_126130_("Y  ").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftItems.AZURITE.get()).m_126127_(Character.valueOf('Y'), (ItemLike)Items.f_42417_).m_142284_("has_" + this.safeName((IForgeRegistryEntry)TropicraftItems.AZURITE.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.AZURITE.get()))).m_142284_("has_gold_ingot", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_42417_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_ITEM_FRAME.get()), (int)1).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41911_).m_126127_(Character.valueOf('Y'), (ItemLike)Items.f_42454_).m_142284_("has_bamboo", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_142284_("has_leather", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_42454_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)TropicraftBlocks.AIR_COMPRESSOR.get()), (int)1).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftBlocks.CHUNK.get()).m_126127_(Character.valueOf('Y'), (ItemLike)TropicraftItems.AZURITE.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)TropicraftBlocks.CHUNK.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftBlocks.CHUNK.get()))).m_142284_("has_" + this.safeName((IForgeRegistryEntry)TropicraftItems.AZURITE.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.AZURITE.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)TropicraftBlocks.BAMBOO_LADDER.get()), (int)4).m_126130_("S S").m_126130_("BSB").m_126130_("S S").m_126127_(Character.valueOf('S'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_41911_).m_142284_("has_bamboo", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
        this.boardwalk((Supplier)TropicraftBlocks.BAMBOO_SLAB, (Supplier)TropicraftBlocks.BAMBOO_BOARDWALK, consumer);
        this.boardwalk((Supplier)TropicraftBlocks.PALM_SLAB, (Supplier)TropicraftBlocks.PALM_BOARDWALK, consumer);
        this.boardwalk((Supplier)TropicraftBlocks.MAHOGANY_SLAB, (Supplier)TropicraftBlocks.MAHOGANY_BOARDWALK, consumer);
        this.boardwalk((Supplier)TropicraftBlocks.MANGROVE_SLAB, (Supplier)TropicraftBlocks.MANGROVE_BOARDWALK, consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftBlocks.BAMBOO_CHEST.get())).m_126130_("BBB").m_126130_("B B").m_126130_("BBB").m_126127_(Character.valueOf('B'), (ItemLike)Items.f_41911_).m_142284_("has_bamboo", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftBlocks.SIFTER.get())).m_126130_("XXX").m_126130_("XIX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_206416_(Character.valueOf('I'), Tags.Items.GLASS).m_142409_("tropicraft:sifter").m_142284_("has_glass", (CriterionTriggerInstance)TropicraftRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftBlocks.SIFTER.get())).m_126130_("XXX").m_126130_("XIX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_206416_(Character.valueOf('I'), Tags.Items.GLASS_PANES).m_142409_("tropicraft:sifter").m_142284_("has_glass_pane", (CriterionTriggerInstance)TropicraftRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS_PANES)).m_142700_(consumer, new ResourceLocation("tropicraft", "sifter_with_glass_pane"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftBlocks.DRINK_MIXER.get())).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftBlocks.CHUNK.get()).m_126127_(Character.valueOf('Y'), (ItemLike)TropicraftItems.BAMBOO_MUG.get()).m_142284_("has_bamboo_mug", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_MUG.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftBlocks.TIKI_TORCH.get())).m_126130_("Y").m_126130_("X").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_206416_(Character.valueOf('Y'), ItemTags.f_13160_).m_142284_("has_bamboo_stick", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_STICK.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftBlocks.BAMBOO_FLOWER_POT.get())).m_126130_("# #").m_126130_(" # ").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_41911_).m_142284_("has_bamboo", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)((RegistryObject)TropicraftItems.COCKTAILS.get((Object)Drink.PINA_COLADA)).get())).m_126209_((ItemLike)TropicraftItems.BAMBOO_MUG.get()).m_126209_((ItemLike)TropicraftItems.COCONUT_CHUNK.get()).m_126209_((ItemLike)TropicraftItems.PINEAPPLE_CUBES.get()).m_142284_("has_bamboo_mug", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_MUG.get()))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)TropicraftItems.TROPICAL_FERTILIZER.get())).m_126209_((ItemLike)TropicraftFlower.MAGIC_MUSHROOM.get()).m_126209_((ItemLike)TropicraftFlower.CROTON.get()).m_142284_("has_magic_mushroom", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)TropicraftFlower.MAGIC_MUSHROOM.get())).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftItems.DAGGER.get())).m_126130_("X").m_126130_("I").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftBlocks.CHUNK.get()).m_126127_(Character.valueOf('I'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)TropicraftBlocks.CHUNK.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftBlocks.CHUNK.get()))).m_142284_("has_bamboo", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)TropicraftItems.BLOW_GUN.get())).m_126130_("X  ").m_126130_(" I ").m_126130_("  X").m_126127_(Character.valueOf('X'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_126127_(Character.valueOf('I'), (ItemLike)TropicraftItems.ZIRCON.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)TropicraftItems.ZIRCON.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.ZIRCON.get()))).m_142284_("has_" + this.safeName((IForgeRegistryEntry)TropicraftItems.BAMBOO_STICK.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.BAMBOO_STICK.get()))).m_176498_(consumer);
    }

    private ResourceLocation safeId(ResourceLocation id) {
        return new ResourceLocation(id.m_135827_(), this.safeName(id));
    }

    private ResourceLocation safeId(IForgeRegistryEntry<?> registryEntry) {
        return this.safeId(registryEntry.getRegistryName());
    }

    private String safeName(ResourceLocation nameSource) {
        return nameSource.m_135815_().replace('/', '_');
    }

    private String safeName(IForgeRegistryEntry<?> registryEntry) {
        return this.safeName(registryEntry.getRegistryName());
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void ore(TagKey<Item> source, Supplier<T> result, float xp, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(source), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100).m_142284_("has_" + this.safeName(source.f_203868_()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_206406_(source)).m_176498_(consumer);
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(source), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100).m_142284_("has_" + this.safeName(source.f_203868_()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_206406_(source)).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting");
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void food(Supplier<? extends T> source, Supplier<? extends T> result, float xp, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176498_(consumer);
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100, (SimpleCookingSerializer)RecipeSerializer.f_44093_).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smoking");
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (float)xp, (int)100, (SimpleCookingSerializer)RecipeSerializer.f_44094_).m_142284_("has_" + this.safeName(((IForgeRegistryEntry)((ItemLike)source.get())).getRegistryName()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_campfire");
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void storage(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("XXX").m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_142284_("has_at_least_9_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)input.get()), (int)9).m_126209_((ItemLike)output.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)output.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)output.get()))).m_176500_(consumer, this.safeId((IForgeRegistryEntry)input.get()) + "_from_" + this.safeName((IForgeRegistryEntry)output.get()));
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void pickaxe(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("XXX").m_126130_(" B ").m_126130_(" B ").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_142284_("has_" + this.safeName((IForgeRegistryEntry<?>)Items.f_41911_), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void shovel(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_(" X ").m_126130_(" B ").m_126130_(" B ").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_142284_("has_" + this.safeName((IForgeRegistryEntry<?>)Items.f_41911_), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void axe(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("XX ").m_126130_("XB ").m_126130_(" B ").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_142284_("has_" + this.safeName((IForgeRegistryEntry<?>)Items.f_41911_), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void hoe(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("XX ").m_126130_(" B ").m_126130_(" B ").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_142284_("has_" + this.safeName((IForgeRegistryEntry<?>)Items.f_41911_), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void sword(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_(" X ").m_126130_(" X ").m_126130_(" B ").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_126127_(Character.valueOf('B'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_142284_("has_" + this.safeName((IForgeRegistryEntry<?>)Items.f_41911_), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Items.f_41911_)).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void helmet(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("XXX").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void chestplate(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("X X").m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void leggings(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("XXX").m_126130_("X X").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void boots(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126130_("X X").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)input.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)input.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)input.get()))).m_176498_(consumer);
    }

    @CheckReturnValue
    private <T extends ItemLike & IForgeRegistryEntry<?>> ShapelessRecipeBuilder singleItemUnfinished(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount) {
        return ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)result.get()), (int)amount).m_126211_((ItemLike)source.get(), required).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get())));
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void dye(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount, Consumer<FinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, required, amount).m_142700_(consumer, new ResourceLocation("tropicraft", ((IForgeRegistryEntry)((ItemLike)result.get())).getRegistryName().m_135815_()));
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void singleItem(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount, Consumer<FinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, required, amount).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void planks(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<FinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, 1, 4).m_142409_("planks").m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void bark(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)source.get()).m_142409_("bark").m_142284_("has_log", (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Blocks.f_50003_)).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void stairs(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)4).m_126130_("X  ").m_126130_("XX ").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176498_(consumer);
        if (stone) {
            SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get())).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void slab(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176498_(consumer);
        if (stone) {
            SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get()), (int)2).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void boardwalk(Supplier<? extends T> slab, Supplier<? extends T> result, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("XXX").m_126130_("S S").m_126127_(Character.valueOf('X'), (ItemLike)slab.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_142409_("tropicraft:boardwalk").m_142284_("has_" + this.safeName((IForgeRegistryEntry)slab.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)slab.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void fence(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("W#W").m_126130_("W#W").m_126127_(Character.valueOf('W'), (ItemLike)source.get()).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void fenceGate(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("#W#").m_126130_("#W#").m_126127_(Character.valueOf('W'), (ItemLike)source.get()).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void wall(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176498_(consumer);
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)source.get()}), (ItemLike)((ItemLike)result.get())).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176500_(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void door(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("XX").m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void trapDoor(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)2).m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_142409_(group).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void bongo(Supplier<? extends T> top, Supplier<? extends T> bottom, int size, Supplier<? extends T> result, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_(StringUtils.repeat((char)'T', (int)size)).m_126130_(StringUtils.repeat((char)'B', (int)size)).m_126130_(StringUtils.repeat((char)'B', (int)size)).m_126127_(Character.valueOf('T'), (ItemLike)top.get()).m_126127_(Character.valueOf('B'), (ItemLike)bottom.get()).m_142409_("tropicraft:bongos").m_142284_("has_" + this.safeName((IForgeRegistryEntry)top.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)top.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void goggles(Supplier<? extends T> result, Supplier<? extends T> source, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("YYY").m_126130_("X X").m_126130_(" Z ").m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50185_).m_126127_(Character.valueOf('Y'), (ItemLike)TropicraftItems.ZIRCON.get()).m_126127_(Character.valueOf('Z'), (ItemLike)source.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_142284_("has_" + this.safeName((IForgeRegistryEntry)TropicraftItems.ZIRCON.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.ZIRCON.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void flippers(Supplier<? extends T> result, Supplier<? extends T> source, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("XX").m_126130_("YY").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_126127_(Character.valueOf('Y'), (ItemLike)TropicraftItems.ZIRCON.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)source.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)source.get()))).m_142284_("has_" + this.safeName((IForgeRegistryEntry)TropicraftItems.ZIRCON.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.ZIRCON.get()))).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void ponyBottle(Supplier<? extends T> result, Supplier<? extends T> source, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("Y").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50362_).m_126127_(Character.valueOf('Y'), (ItemLike)Blocks.f_50164_).m_142284_("has_" + this.safeName((IForgeRegistryEntry<?>)Blocks.f_50362_), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)Blocks.f_50362_)).m_176498_(consumer);
    }

    private <T extends ItemLike & IForgeRegistryEntry<?>> void harness(Supplier<? extends T> result, Supplier<? extends T> source, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)1).m_126130_("Y Y").m_126130_("YXY").m_126130_("YZY").m_126127_(Character.valueOf('X'), (ItemLike)source.get()).m_206416_(Character.valueOf('Y'), TropicraftTags.Items.LEATHER).m_126127_(Character.valueOf('Z'), (ItemLike)TropicraftItems.AZURITE.get()).m_142284_("has_" + this.safeName((IForgeRegistryEntry)TropicraftItems.AZURITE.get()), (CriterionTriggerInstance)TropicraftRecipeProvider.m_125977_((ItemLike)((ItemLike)TropicraftItems.AZURITE.get()))).m_176498_(consumer);
    }
}

