/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.dimension.TropicsTeleporter;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeSource;
import net.tropicraft.core.common.dimension.chunk.TropicraftChunkGenerator;
import net.tropicraft.core.mixin.worldgen.LevelStemAccessor;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="tropicraft")
public class TropicraftDimension {
    private static final Logger LOGGER = LogManager.getLogger(TropicraftDimension.class);
    public static final ResourceLocation ID = new ResourceLocation("tropicraft", "tropics");
    public static final ResourceKey<Level> WORLD = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)ID);
    public static final ResourceKey<LevelStem> DIMENSION = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)ID);
    public static final ResourceKey<DimensionType> DIMENSION_TYPE = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)ID);
    public static final ResourceKey<NoiseGeneratorSettings> DIMENSION_SETTINGS = ResourceKey.m_135785_((ResourceKey)Registry.f_122878_, (ResourceLocation)ID);

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        ServerLevel world;
        if (event.getWorld() instanceof ServerLevel && (world = (ServerLevel)event.getWorld()).m_46472_() == Level.f_46428_) {
            TropicraftDimension.upgradeTropicraftDimension(world.m_142572_());
        }
    }

    private static void upgradeTropicraftDimension(MinecraftServer server) {
        LevelStorageSource.LevelStorageAccess save = server.f_129744_;
        File oldDimension = save.m_78283_(new LevelResource("tropicraft/tropics")).toFile();
        Path newDimension = save.m_197394_(WORLD);
        if (oldDimension.exists() && !newDimension.toFile().exists()) {
            try {
                FileUtils.moveDirectory((File)oldDimension, (File)newDimension.toFile());
            }
            catch (IOException e) {
                LOGGER.error("Failed to move old tropicraft dimension to new location!", (Throwable)e);
            }
        }
    }

    public static void addDefaultDimensionKey() {
        ImmutableSet order = ImmutableSet.builder().addAll(LevelStemAccessor.getBuiltinOrder()).add(DIMENSION).build();
        LevelStemAccessor.setBuiltinOrder((Set<ResourceKey<LevelStem>>)order);
    }

    public static LevelStem createDimension(Registry<DimensionType> dimensionTypeRegistry, Registry<StructureSet> structureSetRegistry, Registry<Biome> biomeRegistry, Registry<NoiseGeneratorSettings> dimensionSettingsRegistry, Registry<NormalNoise.NoiseParameters> paramRegistry, long seed) {
        ChunkGenerator generator = TropicraftDimension.createGenerator(structureSetRegistry, paramRegistry, biomeRegistry, dimensionSettingsRegistry, seed);
        return new LevelStem(dimensionTypeRegistry.m_206081_(DIMENSION_TYPE), generator);
    }

    public static ChunkGenerator createGenerator(Registry<StructureSet> structureSetRegistry, Registry<NormalNoise.NoiseParameters> params, Registry<Biome> biomeRegistry, Registry<NoiseGeneratorSettings> dimensionSettingsRegistry, long seed) {
        Supplier<NoiseGeneratorSettings> dimensionSettings = () -> {
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)dimensionSettingsRegistry.m_6246_(DIMENSION_SETTINGS);
            return settings != null ? settings : (NoiseGeneratorSettings)dimensionSettingsRegistry.m_123013_(NoiseGeneratorSettings.f_64432_);
        };
        TropicraftBiomeSource biomeSource = new TropicraftBiomeSource(seed, biomeRegistry);
        return new TropicraftChunkGenerator(structureSetRegistry, params, biomeSource, seed, (Holder<NoiseGeneratorSettings>)dimensionSettingsRegistry.m_206081_((ResourceKey)dimensionSettingsRegistry.m_7854_((Object)dimensionSettings.get()).get()));
    }

    public static void teleportPlayer(ServerPlayer player, ResourceKey<Level> dimensionType) {
        ServerLevel destLevel = TropicraftDimension.getTeleportDestination(player, dimensionType);
        if (destLevel == null) {
            return;
        }
        ResourceKey destDimension = destLevel.m_46472_();
        if (!ForgeHooks.onTravelToDimension((Entity)player, (ResourceKey)destDimension)) {
            return;
        }
        int x = Mth.m_14107_((double)player.m_20185_());
        int z = Mth.m_14107_((double)player.m_20189_());
        LevelChunk chunk = destLevel.m_6325_(x >> 4, z >> 4);
        int topY = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x & 0xF, z & 0xF);
        player.m_8999_(destLevel, (double)x + 0.5, (double)topY + 1.0, (double)z + 0.5, player.m_146908_(), player.m_146909_());
        ForgeEventFactory.firePlayerChangedDimensionEvent((Player)player, (ResourceKey)destDimension, (ResourceKey)destDimension);
    }

    public static void teleportPlayerWithPortal(ServerPlayer player, ResourceKey<Level> dimensionType) {
        ServerLevel destLevel = TropicraftDimension.getTeleportDestination(player, dimensionType);
        if (destLevel == null) {
            return;
        }
        if (!player.m_20092_()) {
            player.m_19877_();
            player.changeDimension(destLevel, (ITeleporter)new TropicsTeleporter(destLevel));
            player.f_19839_ = 160;
        }
    }

    @Nullable
    private static ServerLevel getTeleportDestination(ServerPlayer player, ResourceKey<Level> dimensionType) {
        ResourceKey<Level> destination = player.f_19853_.m_46472_() == dimensionType ? Level.f_46428_ : dimensionType;
        ServerLevel destLevel = player.f_8924_.m_129880_(destination);
        if (destLevel == null) {
            LOGGER.error("Cannot teleport player to dimension {} as it does not exist!", (Object)destination.m_135782_());
            return null;
        }
        return destLevel;
    }

    public static int getSeaLevel(LevelReader world) {
        ResourceKey dimensionKey;
        if (world instanceof ServerLevel) {
            ServerChunkCache chunkProvider = ((ServerLevel)world).m_7726_();
            return chunkProvider.m_8481_().m_6337_();
        }
        if (world instanceof Level && (dimensionKey = ((Level)world).m_46472_()) == WORLD) {
            return 127;
        }
        return world.m_5736_();
    }
}

