/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.biome.TerrainShaper;

public final class TropicraftTerrainShaper {
    private static final ToFloatFunction<Float> NO_TRANSFORM = value -> value.floatValue();

    public static TerrainShaper tropics() {
        ToFloatFunction offsetTransform = offset -> offset.floatValue() + 0.5f;
        ToFloatFunction<Float> erosionTransform = NO_TRANSFORM;
        ToFloatFunction<Float> jaggednessTransform = NO_TRANSFORM;
        CubicSpline<TerrainShaper.Point> nearInlandDepth = TropicraftTerrainShaper.buildErosionOffsetSpline(-0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, (ToFloatFunction<Float>)offsetTransform);
        CubicSpline<TerrainShaper.Point> midInlandDepth = TropicraftTerrainShaper.buildErosionOffsetSpline(-0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, (ToFloatFunction<Float>)offsetTransform);
        CubicSpline<TerrainShaper.Point> farInlandDepth = TropicraftTerrainShaper.buildErosionOffsetSpline(-0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, (ToFloatFunction<Float>)offsetTransform);
        CubicSpline<TerrainShaper.Point> peaksDepth = TropicraftTerrainShaper.buildErosionOffsetSpline(-0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, (ToFloatFunction<Float>)offsetTransform);
        CubicSpline<TerrainShaper.Point> lagoonSpline = TropicraftTerrainShaper.buildLagoonOffset((ToFloatFunction<Float>)offsetTransform);
        CubicSpline offsetSampler = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.CONTINENTS, (ToFloatFunction)offsetTransform).m_184298_(-1.1f, 0.14f, 0.0f).m_184298_(-0.92f, -0.2222f, 0.0f).m_184298_(-0.41f, -0.2222f, 0.0f).m_184298_(-0.34f, -0.12f, 0.0f).m_184302_(-0.22f, lagoonSpline, 0.0f).m_184302_(-0.18f, lagoonSpline, 0.0f).m_184302_(-0.16f, nearInlandDepth, 0.0f).m_184302_(-0.15f, nearInlandDepth, 0.0f).m_184302_(-0.1f, midInlandDepth, 0.0f).m_184302_(0.25f, farInlandDepth, 0.0f).m_184302_(1.0f, peaksDepth, 0.0f).m_184297_();
        float beachFactorStrength = 6.25f;
        float nearinlandFactorStrength = 4.22f;
        float midInlandFactorStrength = 3.8f;
        float furtherInlandFactorStrength = 2.44f;
        CubicSpline factorSampler = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.CONTINENTS, NO_TRANSFORM).m_184298_(-1.1f, 0.54f, 0.0f).m_184298_(-0.92f, 3.95f, 0.0f).m_184298_(-0.19f, 3.95f, 0.0f).m_184302_(-0.15f, TropicraftTerrainShaper.getErosionFactor(6.25f, true, NO_TRANSFORM), 0.0f).m_184302_(-0.1f, TropicraftTerrainShaper.getErosionFactor(4.22f, true, erosionTransform), 0.0f).m_184302_(0.03f, TropicraftTerrainShaper.getErosionFactor(3.8f, true, erosionTransform), 0.0f).m_184302_(0.06f, TropicraftTerrainShaper.getErosionFactor(2.44f, false, erosionTransform), 0.0f).m_184297_();
        float f4 = 0.65f;
        CubicSpline jaggednessSampler = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.CONTINENTS, jaggednessTransform).m_184298_(-0.11f, 0.0f, 0.0f).m_184302_(0.03f, TropicraftTerrainShaper.buildErosionJaggednessSpline(1.0f, 0.5f, 0.0f, 0.0f, jaggednessTransform), 0.0f).m_184302_(0.65f, TropicraftTerrainShaper.buildErosionJaggednessSpline(1.0f, 1.0f, 1.0f, 0.0f, jaggednessTransform), 0.0f).m_184297_();
        return new TerrainShaper(offsetSampler, factorSampler, jaggednessSampler);
    }

    public static float peaksAndValleys(float p_187266_) {
        return -(Math.abs(Math.abs(p_187266_) - 0.6666667f) - 0.33333334f) * 3.0f;
    }

    private static CubicSpline<TerrainShaper.Point> buildErosionJaggednessSpline(float p_187295_, float p_187296_, float p_187297_, float p_187298_, ToFloatFunction<Float> p_187299_) {
        float f = -0.5775f;
        CubicSpline<TerrainShaper.Point> cubicspline = TropicraftTerrainShaper.buildRidgeJaggednessSpline(p_187295_, p_187297_, p_187299_);
        CubicSpline<TerrainShaper.Point> cubicspline1 = TropicraftTerrainShaper.buildRidgeJaggednessSpline(p_187296_, p_187298_, p_187299_);
        return CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.EROSION, p_187299_).m_184302_(-1.0f, cubicspline, 0.0f).m_184302_(-0.78f, cubicspline1, 0.0f).m_184302_(-0.5775f, cubicspline1, 0.0f).m_184298_(-0.375f, 0.0f, 0.0f).m_184297_();
    }

    private static CubicSpline<TerrainShaper.Point> buildRidgeJaggednessSpline(float p_187301_, float p_187302_, ToFloatFunction<Float> p_187303_) {
        float f = TropicraftTerrainShaper.peaksAndValleys(0.4f);
        float f1 = TropicraftTerrainShaper.peaksAndValleys(0.56666666f);
        float f2 = (f + f1) / 2.0f;
        CubicSpline.Builder builder = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.RIDGES, p_187303_);
        builder.m_184298_(f, 0.0f, 0.0f);
        if (p_187302_ > 0.0f) {
            builder.m_184302_(f2, TropicraftTerrainShaper.buildWeirdnessJaggednessSpline(p_187302_, p_187303_), 0.0f);
        } else {
            builder.m_184298_(f2, 0.0f, 0.0f);
        }
        if (p_187301_ > 0.0f) {
            builder.m_184302_(1.0f, TropicraftTerrainShaper.buildWeirdnessJaggednessSpline(p_187301_, p_187303_), 0.0f);
        } else {
            builder.m_184298_(1.0f, 0.0f, 0.0f);
        }
        return builder.m_184297_();
    }

    private static CubicSpline<TerrainShaper.Point> buildWeirdnessJaggednessSpline(float p_187305_, ToFloatFunction<Float> p_187306_) {
        float f = 0.63f * p_187305_;
        float f1 = 0.3f * p_187305_;
        return CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.WEIRDNESS, p_187306_).m_184298_(-0.01f, f, 0.0f).m_184298_(0.01f, f1, 0.0f).m_184297_();
    }

    private static CubicSpline<TerrainShaper.Point> getErosionFactor(float strengthForContinentalness, boolean coastal, ToFloatFunction<Float> p_187310_) {
        float defaultScale = 3.1f;
        float roughScale = 2.23f;
        CubicSpline defaultPVScaleSpline = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.WEIRDNESS, p_187310_).m_184298_(-0.2f, 3.1f, 0.0f).m_184298_(0.2f, strengthForContinentalness, 0.0f).m_184297_();
        CubicSpline.Builder erosionSplineBuilder = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.EROSION, p_187310_).m_184302_(-0.6f, defaultPVScaleSpline, 0.0f).m_184302_(-0.5f, CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.WEIRDNESS, p_187310_).m_184298_(-0.05f, 3.1f, 0.0f).m_184298_(0.05f, 2.23f, 0.0f).m_184297_(), 0.0f).m_184302_(-0.35f, defaultPVScaleSpline, 0.0f).m_184302_(-0.25f, defaultPVScaleSpline, 0.0f).m_184302_(-0.1f, CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.WEIRDNESS, p_187310_).m_184298_(-0.05f, 2.23f, 0.0f).m_184298_(0.05f, 3.1f, 0.0f).m_184297_(), 0.0f).m_184302_(0.03f, defaultPVScaleSpline, 0.0f);
        if (coastal) {
            CubicSpline coastalWeirdnessForShattered = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.WEIRDNESS, p_187310_).m_184298_(0.0f, strengthForContinentalness, 0.0f).m_184298_(0.1f, 0.625f, 0.0f).m_184297_();
            CubicSpline coastalRidgeForShattered = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.RIDGES, p_187310_).m_184298_(-0.9f, strengthForContinentalness, 0.0f).m_184302_(-0.69f, coastalWeirdnessForShattered, 0.0f).m_184297_();
            erosionSplineBuilder.m_184298_(0.35f, strengthForContinentalness, 0.0f).m_184302_(0.45f, coastalRidgeForShattered, 0.0f).m_184302_(0.55f, coastalRidgeForShattered, 0.0f).m_184298_(0.62f, strengthForContinentalness, 0.0f);
        } else {
            CubicSpline ridgeLowShattered = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.RIDGES, p_187310_).m_184302_(-0.7f, defaultPVScaleSpline, 0.0f).m_184298_(-0.15f, 1.37f, 0.0f).m_184297_();
            CubicSpline ridgeHighShattered = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.RIDGES, p_187310_).m_184302_(0.35f, defaultPVScaleSpline, 0.0f).m_184298_(0.7f, 1.56f, 0.0f).m_184297_();
            erosionSplineBuilder.m_184302_(0.05f, ridgeHighShattered, 0.0f).m_184302_(0.4f, ridgeHighShattered, 0.0f).m_184302_(0.45f, ridgeLowShattered, 0.0f).m_184302_(0.55f, ridgeLowShattered, 0.0f).m_184298_(0.58f, strengthForContinentalness, 0.0f);
        }
        return erosionSplineBuilder.m_184297_();
    }

    private static CubicSpline<TerrainShaper.Point> buildLagoonOffset(ToFloatFunction<Float> offsetTransform) {
        return CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.EROSION, offsetTransform).m_184298_(-1.0f, -0.12f, 0.0f).m_184298_(0.4f, -0.06f, 0.0f).m_184298_(1.0f, -0.01f, 0.0f).m_184297_();
    }

    private static CubicSpline<TerrainShaper.Point> buildMountainRidgeSplineWithPoints(float p_187331_, boolean p_187332_, ToFloatFunction<Float> p_187333_) {
        CubicSpline.Builder builder = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.RIDGES, p_187333_);
        float f = -0.7f;
        float f1 = -1.0f;
        float f2 = TropicraftTerrainShaper.mountainContinentalness(-1.0f, p_187331_, -0.7f);
        float f3 = 1.0f;
        float f4 = TropicraftTerrainShaper.mountainContinentalness(1.0f, p_187331_, -0.7f);
        float f5 = TropicraftTerrainShaper.calculateMountainRidgeZeroContinentalnessPoint(p_187331_);
        float f6 = -0.65f;
        if (-0.65f < f5 && f5 < 1.0f) {
            float f14 = TropicraftTerrainShaper.mountainContinentalness(-0.65f, p_187331_, -0.7f);
            float f8 = -0.75f;
            float f9 = TropicraftTerrainShaper.mountainContinentalness(-0.75f, p_187331_, -0.7f);
            float f10 = TropicraftTerrainShaper.calculateSlope(f2, f9, -1.0f, -0.75f);
            builder.m_184298_(-1.0f, f2, f10);
            builder.m_184298_(-0.75f, f9, 0.0f);
            builder.m_184298_(-0.65f, f14, 0.0f);
            float f11 = TropicraftTerrainShaper.mountainContinentalness(f5, p_187331_, -0.7f);
            float f12 = TropicraftTerrainShaper.calculateSlope(f11, f4, f5, 1.0f);
            float f13 = 0.01f;
            builder.m_184298_(f5 - 0.01f, f11, 0.0f);
            builder.m_184298_(f5, f11, f12);
            builder.m_184298_(1.0f, f4, f12);
        } else {
            float f7 = TropicraftTerrainShaper.calculateSlope(f2, f4, -1.0f, 1.0f);
            if (p_187332_) {
                builder.m_184298_(-1.0f, Math.max(0.2f, f2), 0.0f);
                builder.m_184298_(0.0f, Mth.m_14179_((float)0.5f, (float)f2, (float)f4), f7);
            } else {
                builder.m_184298_(-1.0f, f2, f7);
            }
            builder.m_184298_(1.0f, f4, f7);
        }
        return builder.m_184297_();
    }

    private static float calculateSlope(float p_187272_, float p_187273_, float p_187274_, float p_187275_) {
        return (p_187273_ - p_187272_) / (p_187275_ - p_187274_);
    }

    private static float mountainContinentalness(float p_187327_, float p_187328_, float p_187329_) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - p_187328_) * 0.5f;
        float f3 = 0.5f * (1.0f - p_187328_);
        float f4 = (p_187327_ + 1.17f) * 0.46082947f;
        float f5 = f4 * f2 - f3;
        return p_187327_ < p_187329_ ? Math.max(f5, -0.2222f) : Math.max(f5, 0.0f);
    }

    private static float calculateMountainRidgeZeroContinentalnessPoint(float p_187344_) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - p_187344_) * 0.5f;
        float f3 = 0.5f * (1.0f - p_187344_);
        return f3 / (0.46082947f * f2) - 1.17f;
    }

    private static CubicSpline<TerrainShaper.Point> buildErosionOffsetSpline(float p_187285_, float p_187286_, float p_187287_, float p_187288_, float p_187289_, float p_187290_, boolean p_187291_, boolean p_187292_, ToFloatFunction<Float> p_187293_) {
        float f = 0.6f;
        float f1 = 0.5f;
        float f2 = 0.5f;
        CubicSpline<TerrainShaper.Point> cubicspline = TropicraftTerrainShaper.buildMountainRidgeSplineWithPoints(Mth.m_14179_((float)p_187288_, (float)0.6f, (float)1.5f), p_187292_, p_187293_);
        CubicSpline<TerrainShaper.Point> cubicspline1 = TropicraftTerrainShaper.buildMountainRidgeSplineWithPoints(Mth.m_14179_((float)p_187288_, (float)0.6f, (float)1.0f), p_187292_, p_187293_);
        CubicSpline<TerrainShaper.Point> cubicspline2 = TropicraftTerrainShaper.buildMountainRidgeSplineWithPoints(p_187288_, p_187292_, p_187293_);
        CubicSpline<TerrainShaper.Point> cubicspline3 = TropicraftTerrainShaper.ridgeSpline(p_187285_ - 0.15f, 0.5f * p_187288_, Mth.m_14179_((float)0.5f, (float)0.5f, (float)0.5f) * p_187288_, 0.5f * p_187288_, 0.6f * p_187288_, 0.5f, p_187293_);
        CubicSpline<TerrainShaper.Point> cubicspline4 = TropicraftTerrainShaper.ridgeSpline(p_187285_, p_187289_ * p_187288_, p_187286_ * p_187288_, 0.5f * p_187288_, 0.6f * p_187288_, 0.5f, p_187293_);
        CubicSpline<TerrainShaper.Point> cubicspline5 = TropicraftTerrainShaper.ridgeSpline(p_187285_, p_187289_, p_187289_, p_187286_, p_187287_, 0.5f, p_187293_);
        CubicSpline<TerrainShaper.Point> cubicspline6 = TropicraftTerrainShaper.ridgeSpline(p_187285_, p_187289_, p_187289_, p_187286_, p_187287_, 0.5f, p_187293_);
        CubicSpline cubicspline7 = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.RIDGES, p_187293_).m_184298_(-1.0f, p_187285_, 0.0f).m_184302_(-0.4f, cubicspline5, 0.0f).m_184298_(0.0f, p_187287_ + 0.07f, 0.0f).m_184297_();
        CubicSpline<TerrainShaper.Point> cubicspline8 = TropicraftTerrainShaper.ridgeSpline(-0.02f, p_187290_, p_187290_, p_187286_, p_187287_, 0.0f, p_187293_);
        CubicSpline.Builder builder = CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.EROSION, p_187293_).m_184302_(-0.85f, cubicspline, 0.0f).m_184302_(-0.7f, cubicspline1, 0.0f).m_184302_(-0.4f, cubicspline2, 0.0f).m_184302_(-0.35f, cubicspline3, 0.0f).m_184302_(-0.1f, cubicspline4, 0.0f).m_184302_(0.2f, cubicspline5, 0.0f);
        if (p_187291_) {
            builder.m_184302_(0.4f, cubicspline6, 0.0f).m_184302_(0.45f, cubicspline7, 0.0f).m_184302_(0.55f, cubicspline7, 0.0f).m_184302_(0.58f, cubicspline6, 0.0f);
        }
        builder.m_184302_(0.7f, cubicspline8, 0.0f);
        return builder.m_184297_();
    }

    private static CubicSpline<TerrainShaper.Point> ridgeSpline(float p_187277_, float p_187278_, float p_187279_, float p_187280_, float p_187281_, float p_187282_, ToFloatFunction<Float> p_187283_) {
        float f = Math.max(0.5f * (p_187278_ - p_187277_), p_187282_);
        float f1 = 5.0f * (p_187279_ - p_187278_);
        return CubicSpline.m_184254_((ToFloatFunction)TerrainShaper.Coordinate.RIDGES, p_187283_).m_184298_(-1.0f, p_187277_, f).m_184298_(-0.4f, p_187278_, Math.min(f, f1)).m_184298_(0.0f, p_187279_, f1).m_184298_(0.4f, p_187280_, 2.0f * (p_187280_ - p_187279_)).m_184298_(1.0f, p_187281_, 0.7f * (p_187281_ - p_187280_)).m_184297_();
    }
}

