/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.dimension.TropicraftTerrainShaper;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeBuilder;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public class TropicraftBiomeSource
extends BiomeSource {
    public static final Codec<TropicraftBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(b -> b.seed), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(b -> b.biomes)).apply((Applicative)instance, instance.stable(TropicraftBiomeSource::new)));
    private static final TropicraftBiomeBuilder DEBUG_DATA_HOLDER = new TropicraftBiomeBuilder();
    private static final Set<ResourceKey<Biome>> POSSIBLE_BIOMES = Stream.of(TropicraftBiomes.TROPICS, TropicraftBiomes.OCEAN, TropicraftBiomes.RIVER, TropicraftBiomes.BEACH, TropicraftBiomes.RAINFOREST, TropicraftBiomes.BAMBOO_RAINFOREST, TropicraftBiomes.KELP_FOREST, TropicraftBiomes.MANGROVES, TropicraftBiomes.OVERGROWN_MANGROVES, TropicraftBiomes.OSA_RAINFOREST).map(RegistryObject::getKey).collect(Collectors.toSet());
    private final long seed;
    private final Registry<Biome> biomes;
    private final Climate.ParameterList<Holder<Biome>> parameters;

    public TropicraftBiomeSource(long seed, Registry<Biome> biomes) {
        super(POSSIBLE_BIOMES.stream().map(arg_0 -> biomes.m_206081_(arg_0)));
        this.seed = seed;
        this.biomes = biomes;
        ImmutableList.Builder builder = ImmutableList.builder();
        new TropicraftBiomeBuilder().addBiomes((point, biome) -> builder.add((Object)Pair.of((Object)point, (Object)biomes.m_206081_(biome.getKey()))));
        this.parameters = new Climate.ParameterList((List)builder.build());
    }

    public static void register() {
        Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)new ResourceLocation("tropicraft", "tropics"), CODEC);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeSource m_7206_(long seed) {
        return new TropicraftBiomeSource(seed, this.biomes);
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return (Holder)this.parameters.m_204252_(sampler.m_183445_(x, y, z));
    }

    public void m_207301_(List<String> p_207895_, BlockPos p_207896_, Climate.Sampler p_207897_) {
        int i = QuartPos.m_175400_((int)p_207896_.m_123341_());
        int j = QuartPos.m_175400_((int)p_207896_.m_123342_());
        int k = QuartPos.m_175400_((int)p_207896_.m_123343_());
        Climate.TargetPoint climate$targetpoint = p_207897_.m_183445_(i, j, k);
        float f = Climate.m_186796_((long)climate$targetpoint.f_187005_());
        float f1 = Climate.m_186796_((long)climate$targetpoint.f_187006_());
        float f2 = Climate.m_186796_((long)climate$targetpoint.f_187003_());
        float f3 = Climate.m_186796_((long)climate$targetpoint.f_187004_());
        float f4 = Climate.m_186796_((long)climate$targetpoint.f_187008_());
        double d0 = TropicraftTerrainShaper.peaksAndValleys(f4);
        p_207895_.add("Biome builder PV: " + OverworldBiomeBuilder.m_187155_((double)d0) + " C: " + DEBUG_DATA_HOLDER.getDebugStringForContinentalness(f) + " E: " + DEBUG_DATA_HOLDER.getDebugStringForErosion(f1) + " T: " + DEBUG_DATA_HOLDER.getDebugStringForTemperature(f2) + " H: " + DEBUG_DATA_HOLDER.getDebugStringForHumidity(f3));
    }
}

