/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome.simulate;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.Bootstrap;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeBuilder;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;
import net.tropicraft.core.common.dimension.biome.simulate.NoiseSimulationHelper;

public class BiomeSimulator {
    private static final Map<ResourceKey<Biome>, Integer> COLORS = new HashMap<ResourceKey<Biome>, Integer>();

    public static void main(String[] args) {
        BiomeSimulator.init(new NoiseSimulationHelper(new Random(100L).nextLong()));
    }

    public static void init(NoiseSimulationHelper sampler) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new TropicraftBiomeBuilder().addBiomes((point, biome) -> builder.add((Object)Pair.of((Object)point, (Object)biome.getKey())));
        Climate.ParameterList params = new Climate.ParameterList((List)builder.build());
        BufferedImage image = new BufferedImage(2048, 2048, 1);
        Reference2IntOpenHashMap map = new Reference2IntOpenHashMap();
        map.defaultReturnValue(0);
        for (int x = 0; x < 2048; ++x) {
            if (x % 256 == 0) {
                System.out.println("Mapping... " + (double)(x / 256) / 8.0 * 100.0 + "%");
            }
            for (int z = 0; z < 2048; ++z) {
                ResourceKey value = (ResourceKey)params.m_204252_(sampler.sample(x, 40, z));
                if (!COLORS.containsKey(value)) {
                    throw new RuntimeException("Resource key not found: " + value);
                }
                map.addTo((Object)value, 1);
                image.setRGB(x, z, COLORS.getOrDefault(value, 0));
            }
        }
        for (Reference2IntMap.Entry entry : map.reference2IntEntrySet()) {
            System.out.println(((ResourceKey)entry.getKey()).m_135782_() + ": " + (double)entry.getIntValue() / 4194304.0 * 100.0 + "%");
        }
        Path p = Paths.get(".", "run", "biomes.png");
        try {
            ImageIO.write((RenderedImage)image, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        SharedConstants.m_142977_();
        Bootstrap.m_135870_();
        COLORS.put((ResourceKey<Biome>)TropicraftBiomes.OCEAN.getKey(), 5172447);
        COLORS.put((ResourceKey<Biome>)TropicraftBiomes.RIVER.getKey(), 5172447);
        COLORS.put((ResourceKey<Biome>)TropicraftBiomes.BEACH.getKey(), 16440917);
        COLORS.put((ResourceKey<Biome>)TropicraftBiomes.RAINFOREST.getKey(), 353825);
        COLORS.put((ResourceKey<Biome>)TropicraftBiomes.BAMBOO_RAINFOREST.getKey(), 5751356);
        COLORS.put((ResourceKey<Biome>)TropicraftBiomes.OSA_RAINFOREST.getKey(), 5820749);
        COLORS.put((ResourceKey<Biome>)TropicraftBiomes.TROPICS.getKey(), 9286496);
        COLORS.put((ResourceKey<Biome>)TropicraftBiomes.MANGROVES.getKey(), 5409360);
        COLORS.put((ResourceKey<Biome>)TropicraftBiomes.OVERGROWN_MANGROVES.getKey(), 6129459);
    }
}

