/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CanyonWorldCarver;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class TropicsCanyonCarver
extends CanyonWorldCarver {
    private final float[] rs = new float[1024];

    public TropicsCanyonCarver(Codec<CanyonCarverConfiguration> codec) {
        super(codec);
        this.f_64983_ = ImmutableSet.builder().addAll((Iterable)this.f_64983_).add((Object)((Block)TropicraftBlocks.CORAL_SAND.get())).add((Object)((Block)TropicraftBlocks.FOAMY_SAND.get())).add((Object)((Block)TropicraftBlocks.MINERAL_SAND.get())).add((Object)((Block)TropicraftBlocks.PACKED_PURIFIED_SAND.get())).add((Object)((Block)TropicraftBlocks.PURIFIED_SAND.get())).add((Object)((Block)TropicraftBlocks.VOLCANIC_SAND.get())).add((Object[])new Block[]{(Block)TropicraftBlocks.MUD.get(), (Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get()}).build();
    }

    public boolean m_183279_(CarvingContext pContext, CanyonCarverConfiguration pConfig, ChunkAccess pChunk, Function<BlockPos, Holder<Biome>> pBiomeAccessor, Random pRandom, Aquifer pAquifer, ChunkPos pChunkPos, CarvingMask pCarvingMask) {
        int i = (this.m_65073_() * 2 - 1) * 16;
        double d0 = pChunkPos.m_151382_(pRandom.nextInt(16));
        int j = pRandom.nextInt(pRandom.nextInt(80) + 8) + 20;
        double d1 = pChunkPos.m_151391_(pRandom.nextInt(16));
        float f = pRandom.nextFloat() * ((float)Math.PI * 2);
        float f1 = pConfig.f_158967_.m_142269_(pRandom);
        double d2 = pConfig.f_159089_.m_142269_(pRandom);
        float f2 = pConfig.f_158968_.f_158993_.m_142269_(pRandom);
        int k = (int)((float)i * pConfig.f_158968_.f_158992_.m_142269_(pRandom));
        boolean l = false;
        this.genCanyon(pContext, pConfig, pChunk, pBiomeAccessor, pRandom.nextLong(), pAquifer, d0, j, d1, f2, f, f1, 0, k, d2, pCarvingMask);
        return true;
    }

    private void genCanyon(CarvingContext pContext, CanyonCarverConfiguration pConfig, ChunkAccess pChunk, Function<BlockPos, Holder<Biome>> pBiomeAccessor, long pSeed, Aquifer pAquifer, double pX, double pY, double pZ, float pThickness, float pYaw, float pPitch, int pBranchIndex, int pBranchCount, double pHorizontalVerticalRatio, CarvingMask pCarvingMask) {
        Random random = new Random(pSeed);
        float[] afloat = this.initWidthFactors(pContext, pConfig, random);
        float f = 0.0f;
        float f1 = 0.0f;
        for (int i = pBranchIndex; i < pBranchCount; ++i) {
            double d0 = 1.5 + (double)(Mth.m_14031_((float)((float)i * (float)Math.PI / (float)pBranchCount)) * pThickness);
            double d1 = d0 * pHorizontalVerticalRatio;
            d0 *= (double)pConfig.f_158968_.f_158995_.m_142269_(random);
            d1 = this.updateVerticalRadius(pConfig, random, d1, pBranchCount, i);
            float f2 = Mth.m_14089_((float)pPitch);
            float f3 = Mth.m_14031_((float)pPitch);
            pX += (double)(Mth.m_14089_((float)pYaw) * f2);
            pY += (double)f3;
            pZ += (double)(Mth.m_14031_((float)pYaw) * f2);
            pPitch *= 0.7f;
            pPitch += f1 * 0.05f;
            pYaw += f * 0.05f;
            f1 *= 0.8f;
            f *= 0.5f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (random.nextInt(4) == 0) continue;
            if (!TropicsCanyonCarver.m_159367_((ChunkPos)pChunk.m_7697_(), (double)pX, (double)pZ, (int)i, (int)pBranchCount, (float)pThickness)) {
                return;
            }
            this.m_190753_(pContext, (CarverConfiguration)pConfig, pChunk, pBiomeAccessor, pAquifer, pX, pY, pZ, d0, d1, pCarvingMask, (p_159082_, p_159083_, p_159084_, p_159085_, p_159086_) -> this.shouldSkip(p_159082_, afloat, p_159083_, p_159084_, p_159085_, p_159086_));
        }
    }

    private float[] initWidthFactors(CarvingContext pContext, CanyonCarverConfiguration pConfig, Random pRandom) {
        int i = pContext.m_142208_();
        float[] afloat = new float[i];
        float f = 1.0f;
        for (int j = 0; j < i; ++j) {
            if (j == 0 || pRandom.nextInt(pConfig.f_158968_.f_158994_) == 0) {
                f = 1.0f + pRandom.nextFloat() * pRandom.nextFloat();
            }
            afloat[j] = f * f;
        }
        return afloat;
    }

    private double updateVerticalRadius(CanyonCarverConfiguration p_159026_, Random p_159027_, double p_159028_, float p_159029_, float p_159030_) {
        float f = 1.0f - Mth.m_14154_((float)(0.5f - p_159030_ / p_159029_)) * 2.0f;
        float f1 = p_159026_.f_158968_.f_158996_ + p_159026_.f_158968_.f_158997_ * f;
        return (double)f1 * p_159028_ * (double)Mth.m_144924_((Random)p_159027_, (float)0.75f, (float)1.0f);
    }

    private boolean shouldSkip(CarvingContext pContext, float[] pWidthFactors, double pRelativeX, double pRelativeY, double pRelativeZ, int pY) {
        int i = pY - pContext.m_142201_();
        return (pRelativeX * pRelativeX + pRelativeZ * pRelativeZ) * (double)pWidthFactors[i - 1] + pRelativeY * pRelativeY / 6.0 >= 1.0;
    }
}

