/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.chunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.dimension.chunk.VolcanoGenerator;

public class TropicraftChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<TropicraftChunkGenerator> CODEC = RecordCodecBuilder.create(p_188643_ -> TropicraftChunkGenerator.m_208005_((RecordCodecBuilder.Instance)p_188643_).and(p_188643_.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(p_188716_ -> p_188716_.parameters), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(p_188711_ -> p_188711_.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(p_188690_ -> p_188690_.seed), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(p_204585_ -> p_204585_.f_64318_))).apply((Applicative)p_188643_, p_188643_.stable(TropicraftChunkGenerator::new)));
    private final VolcanoGenerator volcano;
    private final Registry<NormalNoise.NoiseParameters> parameters;
    private final long seed;

    public TropicraftChunkGenerator(Registry<StructureSet> structureset, Registry<NormalNoise.NoiseParameters> registry, BiomeSource biomes, long seed, Holder<NoiseGeneratorSettings> settings) {
        super(structureset, registry, biomes, seed, settings);
        this.parameters = registry;
        this.seed = seed;
        this.volcano = new VolcanoGenerator(seed, biomes, (ChunkGenerator)this);
    }

    public static void register() {
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)new ResourceLocation("tropicraft", "tropics"), CODEC);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator m_6819_(long seed) {
        return new TropicraftChunkGenerator((Registry<StructureSet>)this.f_207955_, this.parameters, this.f_62137_.m_7206_(seed), seed, (Holder<NoiseGeneratorSettings>)this.f_64318_);
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structures, ChunkAccess chunk) {
        return super.m_183489_(executor, blender, structures, chunk).thenApply(volcanoChunk -> {
            ChunkPos chunkPos = volcanoChunk.m_7697_();
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(this.seed));
            random.m_190064_(chunkPos.m_45588_(), 59317, 31931);
            this.volcano.generate(chunkPos.f_45578_, chunkPos.f_45579_, (ChunkAccess)volcanoChunk, random);
            return volcanoChunk;
        });
    }

    public int m_142647_(int x, int z, Heightmap.Types heightmapType, LevelHeightAccessor accessor) {
        int height = super.m_142647_(x, z, heightmapType, accessor);
        if (heightmapType != Heightmap.Types.OCEAN_FLOOR && heightmapType != Heightmap.Types.OCEAN_FLOOR_WG) {
            return Math.max(height, this.volcano.getVolcanoHeight(height, x, z));
        }
        return height;
    }

    public VolcanoGenerator getVolcano() {
        return this.volcano;
    }
}

