/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.CoffeeBushBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class CoffeePlantFeature
extends Feature<NoneFeatureConfiguration> {
    public static final BlockState GRASS_BLOCK = Blocks.f_50440_.m_49966_();
    public static final BlockState COFE = ((CoffeeBushBlock)((Object)TropicraftBlocks.COFFEE_BUSH.get())).m_52289_(6);
    public static final BlockState FARMLAND = Blocks.f_50093_.m_49966_();
    public static final BlockState WATER = Blocks.f_49990_.m_49966_();

    public CoffeePlantFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos upPos;
        WorldGenLevel world = context.m_159774_();
        Random random = context.m_159776_();
        BlockPos pos = context.m_159777_();
        BlockPos genPos = new BlockPos(pos.m_123341_() + random.nextInt(8) - random.nextInt(8), pos.m_123342_(), pos.m_123343_() + random.nextInt(8) - random.nextInt(8));
        if (!world.m_46859_(genPos) || world.m_8055_(genPos.m_7495_()).m_60734_() != GRASS_BLOCK.m_60734_() || world.m_46859_(genPos.m_6625_(2))) {
            return false;
        }
        Direction viableDirection = null;
        for (Object dir : Direction.Plane.HORIZONTAL) {
            int neighborx = genPos.m_123341_() + dir.m_122429_();
            int neighborz = genPos.m_123343_() + dir.m_122431_();
            if (world.m_46859_(new BlockPos(neighborx, pos.m_123342_() - 1, neighborz))) continue;
            viableDirection = dir;
            break;
        }
        if (viableDirection == null) {
            return false;
        }
        BlockPos waterPos = new BlockPos(genPos.m_123341_() + viableDirection.m_122429_(), pos.m_123342_() - 1, genPos.m_123343_() + viableDirection.m_122431_());
        world.m_7731_(waterPos, WATER, 3);
        world.m_7731_(genPos.m_7495_(), FARMLAND, 3);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            world.m_7731_(waterPos.m_142300_(dir), GRASS_BLOCK, 3);
        }
        for (int i = 0; i < 3 && world.m_46859_(upPos = genPos.m_6630_(i)); ++i) {
            world.m_7731_(upPos, COFE, 3);
        }
        return true;
    }
}

