/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.NoRotateSingleJigsawPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.PieceWithGenerationBounds;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.TropicraftStructurePieceTypes;

public class HomeTreeStructure
extends StructureFeature<JigsawConfiguration> {
    public HomeTreeStructure(Codec<JigsawConfiguration> codec, Predicate<PieceGeneratorSupplier.Context<JigsawConfiguration>> context) {
        super(codec, p_197102_ -> {
            if (!context.test(p_197102_)) {
                return Optional.empty();
            }
            BlockPos blockpos = new BlockPos(p_197102_.f_197355_().m_45604_(), 0, p_197102_.f_197355_().m_45605_());
            return JigsawPlacement.m_210284_((PieceGeneratorSupplier.Context)p_197102_, Piece::new, (BlockPos)blockpos, (boolean)true, (boolean)true);
        });
    }

    private static boolean isValid(ChunkGenerator generator, BlockPos pos, int startY, LevelHeightAccessor level) {
        int y = generator.m_142647_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, level);
        return y >= generator.m_6337_() && Math.abs(y - startY) < 10 && y < 150 && y > generator.m_6337_() + 2;
    }

    public static boolean checkLocation(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkGenerator generator = context.f_197352_();
        BlockPos pos = context.f_197355_().m_45615_();
        LevelHeightAccessor level = context.f_197357_();
        int y = generator.m_142647_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, level);
        return HomeTreeStructure.isValid(generator, pos.m_142082_(-4, 0, -4), y, level) && HomeTreeStructure.isValid(generator, pos.m_142082_(-4, 0, 4), y, level) && HomeTreeStructure.isValid(generator, pos.m_142082_(4, 0, 4), y, level) && HomeTreeStructure.isValid(generator, pos.m_142082_(4, 0, -4), y, level);
    }

    public static class Piece
    extends PoolElementStructurePiece {
        public Piece(StructureManager templates, StructurePoolElement piece, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds) {
            super(templates, piece, pos, groundLevelDelta, rotation, bounds);
            this.f_73383_ = this.fixGenerationBoundingBox(templates);
        }

        public Piece(StructurePieceSerializationContext pContext, CompoundTag data) {
            super(pContext, data);
            this.f_73383_ = this.fixGenerationBoundingBox(pContext.f_192764_());
        }

        private BoundingBox fixGenerationBoundingBox(StructureManager templates) {
            StructurePoolElement structurePoolElement = this.f_72597_;
            if (structurePoolElement instanceof PieceWithGenerationBounds) {
                PieceWithGenerationBounds piece = (PieceWithGenerationBounds)structurePoolElement;
                return piece.getGenerationBounds(templates, this.f_72598_, Rotation.NONE);
            }
            return this.f_73383_;
        }

        public Rotation m_6830_() {
            if (this.f_72597_ instanceof NoRotateSingleJigsawPiece) {
                return Rotation.NONE;
            }
            return super.m_6830_();
        }

        public StructurePieceType m_210000_() {
            return (StructurePieceType)TropicraftStructurePieceTypes.HOME_TREE.get();
        }
    }
}

