/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class SingleUndergrowthFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int LARGE_BUSH_CHANCE = 4;

    public SingleUndergrowthFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        context.m_159775_();
        Random rand = context.m_159776_();
        BlockPos pos = context.m_159777_();
        context.m_159778_();
        int size = 2;
        if (rand.nextInt(4) == 0) {
            size = 3;
        }
        if (!this.isValidPosition((LevelSimulatedReader)level, pos)) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(level, pos.m_123342_(), size)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isSoil((LevelAccessor)level, pos.m_7495_())) {
            return false;
        }
        level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 3);
        int count = 0;
        if (this.isValidPosition((LevelSimulatedReader)level, pos) && pos.m_123342_() < 255) {
            for (int y = pos.m_123342_(); y < pos.m_123342_() + size; ++y) {
                int bushWidth = size - (y - pos.m_123342_());
                for (int x = pos.m_123341_() - bushWidth; x < pos.m_123341_() + bushWidth; ++x) {
                    int xVariance = x - pos.m_123341_();
                    for (int z = pos.m_123343_() - bushWidth; z < pos.m_123343_() + bushWidth; ++z) {
                        int zVariance = z - pos.m_123343_();
                        BlockPos newPos = new BlockPos(x, y, z);
                        if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && rand.nextInt(2) == 0 || !this.isValidPosition((LevelSimulatedReader)level, newPos)) continue;
                        this.m_5974_((LevelWriter)level, newPos, ((LeavesBlock)TropicraftBlocks.KAPOK_LEAVES.get()).m_49966_());
                    }
                }
            }
            ++count;
        }
        this.m_5974_((LevelWriter)level, pos, ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).m_49966_());
        return count > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidPosition(LevelSimulatedReader level, BlockPos pos) {
        if (!TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)pos)) return false;
        if (level.m_7433_(pos, Blocks.f_50627_.m_49966_()::equals)) return false;
        return true;
    }
}

