/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.dimension.feature.CoffeePlantFeature;
import net.tropicraft.core.common.dimension.feature.EIHFeature;
import net.tropicraft.core.common.dimension.feature.HomeTreeStructure;
import net.tropicraft.core.common.dimension.feature.HugePlantFeature;
import net.tropicraft.core.common.dimension.feature.KoaVillageStructure;
import net.tropicraft.core.common.dimension.feature.ReedsFeature;
import net.tropicraft.core.common.dimension.feature.SingleUndergrowthFeature;
import net.tropicraft.core.common.dimension.feature.UndergroundSeaPickleFeature;
import net.tropicraft.core.common.dimension.feature.UndergrowthFeature;
import net.tropicraft.core.common.dimension.feature.config.RainforestVinesConfig;
import net.tropicraft.core.common.dimension.feature.tree.CurvedPalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.LargePalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.NormalPalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.RainforestVinesFeature;
import net.tropicraft.core.common.dimension.feature.tree.TallRainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TualungFeature;
import net.tropicraft.core.common.dimension.feature.tree.UpTreeFeature;

public class TropicraftFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"tropicraft");
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"tropicraft");
    public static final RegistryObject<PalmTreeFeature> NORMAL_PALM_TREE = TropicraftFeatures.register("normal_palm_tree", () -> new NormalPalmTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<PalmTreeFeature> CURVED_PALM_TREE = TropicraftFeatures.register("curved_palm_tree", () -> new CurvedPalmTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<PalmTreeFeature> LARGE_PALM_TREE = TropicraftFeatures.register("large_palm_tree", () -> new LargePalmTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<RainforestTreeFeature> UP_TREE = TropicraftFeatures.register("up_tree", () -> new UpTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<RainforestTreeFeature> SMALL_TUALUNG = TropicraftFeatures.register("small_tualung", () -> new TualungFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, 16, 9));
    public static final RegistryObject<RainforestTreeFeature> LARGE_TUALUNG = TropicraftFeatures.register("large_tualung", () -> new TualungFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_, 25, 11));
    public static final RegistryObject<RainforestTreeFeature> TALL_TREE = TropicraftFeatures.register("tall_tree", () -> new TallRainforestTreeFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<EIHFeature> EIH = TropicraftFeatures.register("eih", () -> new EIHFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<UndergrowthFeature> UNDERGROWTH = TropicraftFeatures.register("undergrowth", () -> new UndergrowthFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<SingleUndergrowthFeature> SINGLE_UNDERGROWTH = TropicraftFeatures.register("single_undergrowth", () -> new SingleUndergrowthFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<RainforestVinesFeature> VINES = TropicraftFeatures.register("rainforest_vines", () -> new RainforestVinesFeature(RainforestVinesConfig.CODEC));
    public static final RegistryObject<UndergroundSeaPickleFeature> UNDERGROUND_SEA_PICKLE = TropicraftFeatures.register("underground_sea_pickle", () -> new UndergroundSeaPickleFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> KOA_VILLAGE = TropicraftFeatures.registerStructure("koa_village", new KoaVillageStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> HOME_TREE = TropicraftFeatures.registerStructure("home_tree", new HomeTreeStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_, HomeTreeStructure::checkLocation), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final RegistryObject<CoffeePlantFeature> COFFEE_BUSH = TropicraftFeatures.register("coffee_bush", () -> new CoffeePlantFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<ReedsFeature> REEDS = TropicraftFeatures.register("reeds", () -> new ReedsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<HugePlantFeature> HUGE_PLANT = TropicraftFeatures.register("huge_plant", () -> new HugePlantFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.f_68068_));

    private static <T extends Feature<?>> RegistryObject<T> register(String name, Supplier<T> sup) {
        return FEATURES.register(name, sup);
    }

    private static <T extends StructureFeature<?>> RegistryObject<T> registerStructure(String name, T structure, GenerationStep.Decoration step) {
        StructureFeature.f_67032_.put(structure, step);
        return STRUCTURES.register(name, () -> structure);
    }

    public static <T> Holder<T> holderOf(RegistryObject<T> object) {
        return (Holder)object.getHolder().orElseThrow();
    }

    public static class Register {
        private final DeferredRegister<ConfiguredFeature<?, ?>> features = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"tropicraft");
        private final DeferredRegister<PlacedFeature> placed = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"tropicraft");

        private Register() {
        }

        public static Register create() {
            return new Register();
        }

        public void registerTo(IEventBus bus) {
            this.features.register(bus);
            this.placed.register(bus);
        }

        public <C extends FeatureConfiguration, F extends Feature<C>> RegistryObject<ConfiguredFeature<?, ?>> feature(String id, F feature, Supplier<C> config) {
            return this.features.register(id, () -> new ConfiguredFeature(feature, (FeatureConfiguration)config.get()));
        }

        public <C extends FeatureConfiguration, F extends Feature<C>> RegistryObject<ConfiguredFeature<?, ?>> feature(String id, Supplier<F> feature, Supplier<C> config) {
            return this.features.register(id, () -> new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)config.get()));
        }

        public <C extends FeatureConfiguration> RegistryObject<ConfiguredFeature<?, ?>> copyFeature(String id, Holder<ConfiguredFeature<C, ?>> source) {
            return this.features.register(id, () -> {
                ConfiguredFeature value = (ConfiguredFeature)source.m_203334_();
                return new ConfiguredFeature(value.f_65377_(), value.f_65378_());
            });
        }

        public <F extends Feature<NoneFeatureConfiguration>> RegistryObject<ConfiguredFeature<?, ?>> feature(String id, Supplier<F> feature) {
            return this.feature(id, feature, () -> NoneFeatureConfiguration.f_67816_);
        }

        public RegistryObject<ConfiguredFeature<?, ?>> randomFeature(String id, Supplier<List<Holder<PlacedFeature>>> choicesSupplier) {
            return this.features.register(id, () -> {
                List choices = (List)choicesSupplier.get();
                if (choices.size() == 2) {
                    Holder left = (Holder)choices.get(0);
                    Holder right = (Holder)choices.get(1);
                    return new ConfiguredFeature(Feature.f_65756_, (FeatureConfiguration)new RandomBooleanFeatureConfiguration(left, right));
                }
                return new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205800_((List)choices)));
            });
        }

        public RegistryObject<ConfiguredFeature<?, ?>> randomFeature(String id, List<Pair<RegistryObject<PlacedFeature>, Float>> choices, RegistryObject<PlacedFeature> defaultFeature) {
            return this.randomFeature(id, () -> choices.stream().map(pair -> {
                Holder holder = TropicraftFeatures.holderOf((RegistryObject)pair.getFirst());
                return new WeightedPlacedFeature(holder, ((Float)pair.getSecond()).floatValue());
            }).toList(), () -> TropicraftFeatures.holderOf(defaultFeature));
        }

        public RegistryObject<ConfiguredFeature<?, ?>> randomFeature(String id, Supplier<List<WeightedPlacedFeature>> choicesSupplier, Supplier<Holder<PlacedFeature>> defaultFeature) {
            return this.features.register(id, () -> {
                List choices = (List)choicesSupplier.get();
                return new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(choices, (Holder)defaultFeature.get()));
            });
        }

        @SafeVarargs
        public final RegistryObject<ConfiguredFeature<?, ?>> randomFeature(String id, RegistryObject<ConfiguredFeature<?, ?>> ... choices) {
            return this.randomFeature(id, () -> Arrays.stream(choices).map(this::inlinePlaced).toList());
        }

        @SafeVarargs
        public final RegistryObject<ConfiguredFeature<?, ?>> randomPlacedFeature(String id, RegistryObject<PlacedFeature> ... choices) {
            return this.randomFeature(id, () -> Arrays.stream(choices).map(TropicraftFeatures::holderOf).toList());
        }

        @SafeVarargs
        public final RegistryObject<PlacedFeature> randomChecked(String id, RegistryObject<PlacedFeature> ... choices) {
            RegistryObject<ConfiguredFeature<?, ?>> configured = this.randomPlacedFeature(id, choices);
            return this.placed.register(id, () -> new PlacedFeature(TropicraftFeatures.holderOf(configured), List.of()));
        }

        public RandomPatchConfiguration randomPatch(Supplier<? extends Block> block) {
            return this.randomPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)block.get()));
        }

        public RandomPatchConfiguration randomPatch(BlockStateProvider blockStateProvider) {
            return FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(blockStateProvider));
        }

        public OreConfiguration ore(int blobSize, Supplier<? extends Block> block) {
            return new OreConfiguration(OreFeatures.f_195072_, block.get().m_49966_(), blobSize);
        }

        public Holder<PlacedFeature> inlinePlaced(RegistryObject<ConfiguredFeature<?, ?>> object) {
            return PlacementUtils.m_206506_(TropicraftFeatures.holderOf(object), (PlacementModifier[])new PlacementModifier[0]);
        }

        public BlockStateProvider stateProvider(Supplier<? extends Block> block) {
            return BlockStateProvider.m_191382_((Block)block.get());
        }

        public RegistryObject<PlacedFeature> placed(String id, RegistryObject<ConfiguredFeature<?, ?>> feature, Supplier<List<PlacementModifier>> placement) {
            return this.placed.register(id, () -> new PlacedFeature(TropicraftFeatures.holderOf(feature), (List)placement.get()));
        }

        public List<PlacementModifier> sparseTreePlacement(float chance) {
            return this.treePlacement(0, chance, 1);
        }

        public List<PlacementModifier> treePlacement(int count, float extraChance, int extraCount) {
            return List.of(PlacementUtils.m_195364_((int)count, (float)extraChance, (int)extraCount), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_());
        }

        public List<PlacementModifier> rareOrePlacement(int rarity, PlacementModifier height) {
            return this.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)rarity), height);
        }

        public List<PlacementModifier> orePlacement(PlacementModifier count, PlacementModifier height) {
            return List.of(count, InSquarePlacement.m_191715_(), height, BiomeFilter.m_191561_());
        }

        public List<PlacementModifier> commonOrePlacement(int rarity, PlacementModifier height) {
            return this.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)rarity), height);
        }
    }
}

