/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.GravityProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tropicraft.core.common.dimension.feature.jigsaw.PathStructureProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;

public class SmoothingGravityProcessor
extends PathStructureProcessor {
    public static final Codec<SmoothingGravityProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Heightmap.Types.f_64274_.fieldOf("heightmap").forGetter(p -> p.heightmap), (App)Codec.INT.fieldOf("offset").forGetter(p -> p.offset)).apply((Applicative)instance, SmoothingGravityProcessor::new));
    private final Heightmap.Types heightmap;
    private final int offset;
    private final GravityProcessor baseline;

    public SmoothingGravityProcessor(Heightmap.Types heightmap, int offset) {
        this.heightmap = heightmap;
        this.offset = offset;
        this.baseline = new GravityProcessor(heightmap, offset);
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos seedPos, BlockPos pos2, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettingsIn, StructureTemplate template) {
        Direction.Axis pathDir = this.getPathDirection(level, seedPos, blockInfo, placementSettingsIn, template);
        if (pathDir == null) {
            pathDir = Direction.Axis.X;
        }
        BlockPos pos = blockInfo.f_74675_;
        BlockPos posForward = pos.m_142300_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)pathDir));
        BlockPos posBackward = pos.m_142300_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)pathDir));
        int heightForward = level.m_6924_(this.heightmap, posForward.m_123341_(), posForward.m_123343_()) + this.offset;
        int heightBackward = level.m_6924_(this.heightmap, posBackward.m_123341_(), posBackward.m_123343_()) + this.offset;
        int height = level.m_6924_(this.heightmap, pos.m_123341_(), pos.m_123343_()) + this.offset;
        if (heightForward > height && heightBackward > height) {
            return new StructureTemplate.StructureBlockInfo(new BlockPos(pos.m_123341_(), Math.min(heightForward, heightBackward), pos.m_123343_()), blockInfo.f_74676_, blockInfo.f_74677_);
        }
        return this.baseline.process(level, seedPos, pos2, originalBlockInfo, blockInfo, placementSettingsIn, template);
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)TropicraftProcessorTypes.SMOOTHING_GRAVITY.get();
    }
}

