/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;
import net.tropicraft.core.common.entity.TropicraftEntities;

public class SpawnerProcessor
extends StructureProcessor {
    public static final SpawnerProcessor IGUANA = new SpawnerProcessor((List<ResourceLocation>)ImmutableList.of((Object)TropicraftEntities.IGUANA.getId()));
    public static final SpawnerProcessor ASHEN = new SpawnerProcessor((List<ResourceLocation>)ImmutableList.of((Object)TropicraftEntities.ASHEN.getId()));
    public static final SpawnerProcessor EIH = new SpawnerProcessor((List<ResourceLocation>)ImmutableList.of((Object)TropicraftEntities.EIH.getId()));
    public static final SpawnerProcessor IGUANA_AND_ASHEN = new SpawnerProcessor((List<ResourceLocation>)ImmutableList.of((Object)TropicraftEntities.ASHEN.getId(), (Object)TropicraftEntities.IGUANA.getId()));
    public static final Codec<SpawnerProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("entity_types").forGetter(p -> p.entityTypes)).apply((Applicative)instance, SpawnerProcessor::new));
    private final List<ResourceLocation> entityTypes;

    public SpawnerProcessor(List<ResourceLocation> entityTypes) {
        this.entityTypes = entityTypes;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)TropicraftProcessorTypes.SPAWNER.get();
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        Block block = blockInfo.f_74676_.m_60734_();
        if (block != Blocks.f_50085_) {
            return blockInfo;
        }
        CompoundTag tag = new CompoundTag();
        String typeName = this.entityTypes.get(0).toString();
        tag.m_128359_("id", typeName);
        blockInfo.f_74677_.m_128469_("SpawnData").m_128359_("id", typeName);
        ListTag list = blockInfo.f_74677_.m_128437_("SpawnPotentials", 9);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbt = list.m_128728_(i);
            nbt.m_128469_("Entity").m_128359_("id", typeName);
        }
        return blockInfo;
    }
}

