/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tropicraft.core.common.dimension.feature.jigsaw.CheatyStructureProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;

public class StructureSupportsProcessor
extends CheatyStructureProcessor {
    public static final Codec<StructureSupportsProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("can_replace_land", (Object)false).forGetter(p -> p.canReplaceLand), (App)ResourceLocation.f_135803_.listOf().fieldOf("states_to_extend").forGetter(p -> new ArrayList<ResourceLocation>(p.statesToExtend))).apply((Applicative)instance, StructureSupportsProcessor::new));
    private final boolean canReplaceLand;
    private final Set<ResourceLocation> statesToExtend;

    public StructureSupportsProcessor(boolean canReplaceLand, List<ResourceLocation> statesToExtend) {
        this.canReplaceLand = canReplaceLand;
        this.statesToExtend = new ObjectOpenHashSet(statesToExtend);
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos seedPos, BlockPos pos2, StructureTemplate.StructureBlockInfo originalInfo, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placement, StructureTemplate template) {
        BlockPos pos = blockInfo.f_74675_;
        if (originalInfo.f_74675_.m_123342_() <= 1 && this.statesToExtend.contains(blockInfo.f_74676_.m_60734_().getRegistryName())) {
            if (!this.canReplaceLand && !this.canPassThrough(world, pos)) {
                return null;
            }
            if (originalInfo.f_74675_.m_123342_() == 0) {
                if (!this.canReplaceLand && !this.canPassThrough(world, pos.m_7494_())) {
                    return null;
                }
                BlockPos fencePos = pos.m_7495_();
                while (this.canPassThrough(world, fencePos)) {
                    BlockState state = blockInfo.f_74676_;
                    if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        state = (BlockState)state.m_61124_((Property)FenceBlock.f_52313_, (Comparable)Boolean.valueOf(world.m_8055_(fencePos).m_60734_() == Blocks.f_49990_));
                    }
                    this.setBlockState(world, fencePos, state);
                    fencePos = fencePos.m_7495_();
                }
            }
        }
        return blockInfo;
    }

    protected boolean canPassThrough(LevelReader world, BlockPos pos) {
        return this.isAirOrWater(world, pos) || world.m_5452_(Heightmap.Types.WORLD_SURFACE, pos).m_123342_() < pos.m_123342_();
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)TropicraftProcessorTypes.STRUCTURE_SUPPORTS.get();
    }
}

